from __future__ import annotations
from collections.abc import Callable
from dataclasses import dataclass, field
from kiota_abstractions.base_request_builder import BaseRequestBuilder
from kiota_abstractions.base_request_configuration import RequestConfiguration
from kiota_abstractions.default_query_parameters import QueryParameters
from kiota_abstractions.get_path_parameters import get_path_parameters
from kiota_abstractions.method import Method
from kiota_abstractions.request_adapter import RequestAdapter
from kiota_abstractions.request_information import RequestInformation
from kiota_abstractions.request_option import RequestOption
from kiota_abstractions.serialization import Parsable, ParsableFactory
from typing import Any, Optional, TYPE_CHECKING, Union
from warnings import warn

if TYPE_CHECKING:
    from ....models.access import Access

class DataRequestBuilder(BaseRequestBuilder):
    """
    Builds and executes requests for operations under /api/run/data
    """
    def __init__(self,request_adapter: RequestAdapter, path_parameters: Union[str, dict[str, Any]]) -> None:
        """
        Instantiates a new DataRequestBuilder and sets the default values.
        param path_parameters: The raw url or the url-template parameters for the request.
        param request_adapter: The request adapter to use to execute the requests.
        Returns: None
        """
        super().__init__(request_adapter, "{+baseurl}/api/run/data?start={start}&stop={stop}&test={test}{&access*,description*,owner*,schema*}", path_parameters)
    
    async def post(self,body: str, request_configuration: Optional[RequestConfiguration[DataRequestBuilderPostQueryParameters]] = None) -> Optional[str]:
        """
        Upload a new Run
        param body: The request body
        param request_configuration: Configuration for the request such as headers, query parameters, and middleware options.
        Returns: Optional[str]
        """
        if body is None:
            raise TypeError("body cannot be null.")
        request_info = self.to_post_request_information(
            body, request_configuration
        )
        if not self.request_adapter:
            raise Exception("Http core is null") 
        return await self.request_adapter.send_primitive_async(request_info, "str", None)
    
    def to_post_request_information(self,body: str, request_configuration: Optional[RequestConfiguration[DataRequestBuilderPostQueryParameters]] = None) -> RequestInformation:
        """
        Upload a new Run
        param body: The request body
        param request_configuration: Configuration for the request such as headers, query parameters, and middleware options.
        Returns: RequestInformation
        """
        if body is None:
            raise TypeError("body cannot be null.")
        request_info = RequestInformation(Method.POST, self.url_template, self.path_parameters)
        request_info.configure(request_configuration)
        request_info.headers.try_add("Accept", "text/plain;q=0.9")
        request_info.set_content_from_scalar(self.request_adapter, "application/json", body)
        return request_info
    
    def with_url(self,raw_url: str) -> DataRequestBuilder:
        """
        Returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
        param raw_url: The raw URL to use for the request builder.
        Returns: DataRequestBuilder
        """
        if raw_url is None:
            raise TypeError("raw_url cannot be null.")
        return DataRequestBuilder(self.request_adapter, raw_url)
    
    @dataclass
    class DataRequestBuilderPostQueryParameters():
        """
        Upload a new Run
        """
        # New Access level
        access: Optional[Access] = None

        # Run description
        description: Optional[str] = None

        # Name of the new owner
        owner: Optional[str] = None

        # Schema URI
        schema: Optional[str] = None

        # start timestamp of run, or json path expression
        start: Optional[str] = None

        # stop timestamp of run, or json path expression
        stop: Optional[str] = None

        # test name of ID
        test: Optional[str] = None

    
    @dataclass
    class DataRequestBuilderPostRequestConfiguration(RequestConfiguration[DataRequestBuilderPostQueryParameters]):
        """
        Configuration for the request such as headers, query parameters, and middleware options.
        """
        warn("This class is deprecated. Please use the generic RequestConfiguration class generated by the generator.", DeprecationWarning)
    

