from __future__ import annotations
from collections.abc import Callable
from dataclasses import dataclass, field
from kiota_abstractions.base_request_builder import BaseRequestBuilder
from kiota_abstractions.base_request_configuration import RequestConfiguration
from kiota_abstractions.default_query_parameters import QueryParameters
from kiota_abstractions.get_path_parameters import get_path_parameters
from kiota_abstractions.method import Method
from kiota_abstractions.request_adapter import RequestAdapter
from kiota_abstractions.request_information import RequestInformation
from kiota_abstractions.request_option import RequestOption
from kiota_abstractions.serialization import Parsable, ParsableFactory
from typing import Any, Optional, TYPE_CHECKING, Union
from warnings import warn

if TYPE_CHECKING:
    from ....models.label_info import LabelInfo

class AllLabelsRequestBuilder(BaseRequestBuilder):
    """
    Builds and executes requests for operations under /api/schema/allLabels
    """
    def __init__(self,request_adapter: RequestAdapter, path_parameters: Union[str, dict[str, Any]]) -> None:
        """
        Instantiates a new AllLabelsRequestBuilder and sets the default values.
        param path_parameters: The raw url or the url-template parameters for the request.
        param request_adapter: The request adapter to use to execute the requests.
        Returns: None
        """
        super().__init__(request_adapter, "{+baseurl}/api/schema/allLabels{?name*}", path_parameters)
    
    async def get(self,request_configuration: Optional[RequestConfiguration[AllLabelsRequestBuilderGetQueryParameters]] = None) -> Optional[list[LabelInfo]]:
        """
        Retrieve list of Labels for ny name. Allows users to retrieve all Label Definitions that have the same name
        param request_configuration: Configuration for the request such as headers, query parameters, and middleware options.
        Returns: Optional[list[LabelInfo]]
        """
        request_info = self.to_get_request_information(
            request_configuration
        )
        if not self.request_adapter:
            raise Exception("Http core is null") 
        from ....models.label_info import LabelInfo

        return await self.request_adapter.send_collection_async(request_info, LabelInfo, None)
    
    def to_get_request_information(self,request_configuration: Optional[RequestConfiguration[AllLabelsRequestBuilderGetQueryParameters]] = None) -> RequestInformation:
        """
        Retrieve list of Labels for ny name. Allows users to retrieve all Label Definitions that have the same name
        param request_configuration: Configuration for the request such as headers, query parameters, and middleware options.
        Returns: RequestInformation
        """
        request_info = RequestInformation(Method.GET, self.url_template, self.path_parameters)
        request_info.configure(request_configuration)
        request_info.headers.try_add("Accept", "application/json")
        return request_info
    
    def with_url(self,raw_url: str) -> AllLabelsRequestBuilder:
        """
        Returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
        param raw_url: The raw URL to use for the request builder.
        Returns: AllLabelsRequestBuilder
        """
        if raw_url is None:
            raise TypeError("raw_url cannot be null.")
        return AllLabelsRequestBuilder(self.request_adapter, raw_url)
    
    @dataclass
    class AllLabelsRequestBuilderGetQueryParameters():
        """
        Retrieve list of Labels for ny name. Allows users to retrieve all Label Definitions that have the same name
        """
        # Label name
        name: Optional[str] = None

    
    @dataclass
    class AllLabelsRequestBuilderGetRequestConfiguration(RequestConfiguration[AllLabelsRequestBuilderGetQueryParameters]):
        """
        Configuration for the request such as headers, query parameters, and middleware options.
        """
        warn("This class is deprecated. Please use the generic RequestConfiguration class generated by the generator.", DeprecationWarning)
    

