from __future__ import annotations
import datetime
from collections.abc import Callable
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Optional, TYPE_CHECKING, Union

@dataclass
class DatasetLog(AdditionalDataHolder, Parsable):
    """
    Dataset Log
    """
    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: dict[str, Any] = field(default_factory=dict)

    # The datasetId property
    dataset_id: Optional[int] = None
    # The datasetOrdinal property
    dataset_ordinal: Optional[int] = None
    # The id property
    id: Optional[int] = None
    # The level property
    level: Optional[int] = None
    # The message property
    message: Optional[str] = None
    # The runId property
    run_id: Optional[int] = None
    # The source property
    source: Optional[str] = None
    # The testId property
    test_id: Optional[int] = None
    # The timestamp property
    timestamp: Optional[datetime.datetime] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> DatasetLog:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: DatasetLog
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return DatasetLog()
    
    def get_field_deserializers(self,) -> dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: dict[str, Callable[[ParseNode], None]]
        """
        fields: dict[str, Callable[[Any], None]] = {
            "datasetId": lambda n : setattr(self, 'dataset_id', n.get_int_value()),
            "datasetOrdinal": lambda n : setattr(self, 'dataset_ordinal', n.get_int_value()),
            "id": lambda n : setattr(self, 'id', n.get_int_value()),
            "level": lambda n : setattr(self, 'level', n.get_int_value()),
            "message": lambda n : setattr(self, 'message', n.get_str_value()),
            "runId": lambda n : setattr(self, 'run_id', n.get_int_value()),
            "source": lambda n : setattr(self, 'source', n.get_str_value()),
            "testId": lambda n : setattr(self, 'test_id', n.get_int_value()),
            "timestamp": lambda n : setattr(self, 'timestamp', n.get_datetime_value()),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        writer.write_int_value("datasetId", self.dataset_id)
        writer.write_int_value("datasetOrdinal", self.dataset_ordinal)
        writer.write_int_value("id", self.id)
        writer.write_int_value("level", self.level)
        writer.write_str_value("message", self.message)
        writer.write_int_value("runId", self.run_id)
        writer.write_str_value("source", self.source)
        writer.write_int_value("testId", self.test_id)
        writer.write_datetime_value("timestamp", self.timestamp)
        writer.write_additional_data_value(self.additional_data)
    

