from __future__ import annotations
from collections.abc import Callable
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Optional, TYPE_CHECKING, Union

@dataclass
class TypeConfig(AdditionalDataHolder, Parsable):
    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: dict[str, Any] = field(default_factory=dict)

    # The builtIn property
    built_in: Optional[bool] = None
    # The enumName property
    enum_name: Optional[str] = None
    # The label property
    label: Optional[str] = None
    # The name property
    name: Optional[str] = None
    # The supportedAuths property
    supported_auths: Optional[list[str]] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> TypeConfig:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: TypeConfig
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return TypeConfig()
    
    def get_field_deserializers(self,) -> dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: dict[str, Callable[[ParseNode], None]]
        """
        fields: dict[str, Callable[[Any], None]] = {
            "builtIn": lambda n : setattr(self, 'built_in', n.get_bool_value()),
            "enumName": lambda n : setattr(self, 'enum_name', n.get_str_value()),
            "label": lambda n : setattr(self, 'label', n.get_str_value()),
            "name": lambda n : setattr(self, 'name', n.get_str_value()),
            "supportedAuths": lambda n : setattr(self, 'supported_auths', n.get_collection_of_primitive_values(str)),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        writer.write_bool_value("builtIn", self.built_in)
        writer.write_str_value("enumName", self.enum_name)
        writer.write_str_value("label", self.label)
        writer.write_str_value("name", self.name)
        writer.write_collection_of_primitive_values("supportedAuths", self.supported_auths)
        writer.write_additional_data_value(self.additional_data)
    

