# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.16.1
#   kernelspec:
#     display_name: Python 3 (ipykernel)
#     language: python
#     name: python3
# ---

# %% [markdown] slideshow={"slide_type": "slide"}
# # Decision confidence
#
# ```{warning}
# This chapter is under construction.
# ```

# %% [markdown] slideshow={"slide_type": "slide"}
# ## Terminology

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Confidence
#
# In general terms, **confidence** is the belief or conviction that a hypothesis or prediction is correct, that an outcome will be favorable, or that a chosen course of action is the best or most effective.
#
# In decision-making, confidence can be more precisely defined as **the subjective estimate of decision quality** {cite}`brusSourcesConfidenceValuebased2021`.

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Trust
#
# **Trust** is a social construct: the belief that someone or something will behave or perform as expected. It implies a relationship between a *trustor* and a *trustee*.
#
# **Self-confidence** is trust in one's abilities.

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Error monitoring
#
# In decision-making, **error monitoring (EM)** is the process by which one is able to detect his/her errors as soon as a response has been made {cite}`yeungMetacognitionHumanDecisionmaking2012`.
#
# EM allows adaptation of behavior both in the short and longer terms through gradual learning of actions' outcomes.

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Metacognition
#
# Confidence judgments and error monitoring are two related aspects of **metacognition**, the self-monitoring and self-control of one's own cognition (sometimes called *high order thinking*).
#
# [![Metacognition](_images/metacognition.jpg)](https://commons.wikimedia.org/wiki/File:Metacognition.jpg)

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Sensitivity

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Bias

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Uncertainty

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Belief

# %% [markdown] slideshow={"slide_type": "slide"}
# ## Usefulness of confidence in decision-making

# %% [markdown] slideshow={"slide_type": "slide"}
# ## Modeling decision confidence

# %% [markdown] slideshow={"slide_type": "slide"}
# ### Measuring confidence
#
# Two dominant methodologies:
#
# - Confidence ratings: after a decision, evaluate its correctness.
# - Confidence forced choice: after two decisions, choose which one is more likely to be correct.
#   - Disregards confidence biases to focus on confidence sensitivity.

# %%
