"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
    }
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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