# Generated by ariadne-codegen
# Source: cowdao_cowpy/subgraph/queries

from typing import Any, Dict

from .async_base_client import AsyncBaseClient
from .last_days_volume import LastDaysVolume
from .last_hours_volume import LastHoursVolume
from .totals import Totals


def gql(q: str) -> str:
    return q


class SubgraphClient(AsyncBaseClient):
    async def last_days_volume(self, days: int, **kwargs: Any) -> LastDaysVolume:
        query = gql(
            """
            query LastDaysVolume($days: Int!) {
              dailyTotals(orderBy: timestamp, orderDirection: desc, first: $days) {
                timestamp
                volumeUsd
              }
            }
            """
        )
        variables: Dict[str, object] = {"days": days}
        response = await self.execute(
            query=query, operation_name="LastDaysVolume", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return LastDaysVolume.model_validate(data)

    async def last_hours_volume(self, hours: int, **kwargs: Any) -> LastHoursVolume:
        query = gql(
            """
            query LastHoursVolume($hours: Int!) {
              hourlyTotals(orderBy: timestamp, orderDirection: desc, first: $hours) {
                timestamp
                volumeUsd
              }
            }
            """
        )
        variables: Dict[str, object] = {"hours": hours}
        response = await self.execute(
            query=query, operation_name="LastHoursVolume", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return LastHoursVolume.model_validate(data)

    async def totals(self, **kwargs: Any) -> Totals:
        query = gql(
            """
            query Totals {
              totals {
                tokens
                orders
                traders
                settlements
                volumeUsd
                volumeEth
                feesUsd
                feesEth
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="Totals", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Totals.model_validate(data)
