# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AksKubeConfigArgs', 'AksKubeConfig']

@pulumi.input_type
class AksKubeConfigArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 is_admin: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AksKubeConfig resource.
        :param pulumi.Input[str] cluster_name: Name of the AKS cluster you want the Kubeconfig from.
        :param pulumi.Input[str] resource_group_name: Name of the resource group that the cluster is part of.
        :param pulumi.Input[bool] is_admin: Specify whether you want to retrieve the admin kubeconfig or the user kubeconfig. Default value is false
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the AKS cluster you want the Kubeconfig from.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of the resource group that the cluster is part of.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether you want to retrieve the admin kubeconfig or the user kubeconfig. Default value is false
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_admin", value)


class AksKubeConfig(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AksKubeConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Name of the AKS cluster you want the Kubeconfig from.
        :param pulumi.Input[bool] is_admin: Specify whether you want to retrieve the admin kubeconfig or the user kubeconfig. Default value is false
        :param pulumi.Input[str] resource_group_name: Name of the resource group that the cluster is part of.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AksKubeConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AksKubeConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AksKubeConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AksKubeConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AksKubeConfigArgs.__new__(AksKubeConfigArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["is_admin"] = is_admin
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["kubeconfig"] = None
        super(AksKubeConfig, __self__).__init__(
            'kubeconfig:index:AksKubeConfig',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[str]:
        """
        Kubeconfig returned from AKS cluster
        """
        return pulumi.get(self, "kubeconfig")

