from narizaka.languages.uk.textnormalizer import norm

def test_uah():
    assert norm('просто 1 грн.') == 'просто одна гривня.'
    assert norm('1 грн. тест') == 'одна гривня тест'
    assert norm('Просто 1 грн. тест') == 'Просто одна гривня тест'
    assert norm('просто 1 грн.') == 'просто одна гривня.'
    assert norm('1 грн. тест') == 'одна гривня тест'
    assert norm('Просто 1 грн. тест') == 'Просто одна гривня тест'

    assert norm('просто 2 грн.') == 'просто дві гривні.'
    assert norm('2 грн. тест') == 'дві гривні тест'
    assert norm('Просто 2 грн. тест') == 'Просто дві гривні тест'
    assert norm('просто 2 грн.') == 'просто дві гривні.'
    assert norm('2 грн. тест') == 'дві гривні тест'
    assert norm('Просто 2 грн. тест') == 'Просто дві гривні тест'

    assert norm('просто 6 грн.') == 'просто шість гривень.'
    assert norm('6 грн. тест') == 'шість гривень тест'
    assert norm('Просто 6 грн. тест') == 'Просто шість гривень тест'
    assert norm('просто 6 грн.') == 'просто шість гривень.'
    assert norm('6 грн. тест') == 'шість гривень тест'
    assert norm('Просто 6 грн. тест') == 'Просто шість гривень тест'

    assert norm('просто 6 547 грн.') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грн. тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грн. тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('просто 6 547 грн.') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грн. тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грн. тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'
    
    assert norm('просто 1 грн') == 'просто одна гривня.'
    assert norm('1 грн тест') == 'одна гривня тест'
    assert norm('Просто 1 грн тест') == 'Просто одна гривня тест'
    assert norm('просто 1 грн') == 'просто одна гривня.'
    assert norm('1 грн тест') == 'одна гривня тест'
    assert norm('Просто 1 грн тест') == 'Просто одна гривня тест'

    assert norm('просто 2 грн') == 'просто дві гривні.'
    assert norm('2 грн тест') == 'дві гривні тест'
    assert norm('Просто 2 грн тест') == 'Просто дві гривні тест'
    assert norm('просто 2 грн') == 'просто дві гривні.'
    assert norm('2 грн тест') == 'дві гривні тест'
    assert norm('Просто 2 грн тест') == 'Просто дві гривні тест'

    assert norm('просто 6 грн') == 'просто шість гривень.'
    assert norm('6 грн тест') == 'шість гривень тест'
    assert norm('Просто 6 грн. тест') == 'Просто шість гривень тест'
    assert norm('просто 6 грн') == 'просто шість гривень.'
    assert norm('6 грн тест') == 'шість гривень тест'
    assert norm('Просто 6 грн тест') == 'Просто шість гривень тест'

    assert norm('просто 6 547 грн') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грн тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грн тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('просто 6 547 грн') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грн тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грн тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'

    assert norm('просто 1 грв.') == 'просто одна гривня.'
    assert norm('1 грв. тест') == 'одна гривня тест'
    assert norm('Просто 1 грв. тест') == 'Просто одна гривня тест'
    assert norm('просто 1 грв.') == 'просто одна гривня.'
    assert norm('1 грв. тест') == 'одна гривня тест'
    assert norm('Просто 1 грв. тест') == 'Просто одна гривня тест'

    assert norm('просто 2 грв.') == 'просто дві гривні.'
    assert norm('2 грв. тест') == 'дві гривні тест'
    assert norm('Просто 2 грв. тест') == 'Просто дві гривні тест'
    assert norm('просто 2 грв.') == 'просто дві гривні.'
    assert norm('2 грв. тест') == 'дві гривні тест'
    assert norm('Просто 2 грв. тест') == 'Просто дві гривні тест'

    assert norm('просто 6 грв.') == 'просто шість гривень.'
    assert norm('6 грв. тест') == 'шість гривень тест'
    assert norm('Просто 6 грв. тест') == 'Просто шість гривень тест'
    assert norm('просто 6 грв.') == 'просто шість гривень.'
    assert norm('6 грв. тест') == 'шість гривень тест'
    assert norm('Просто 6 грв. тест') == 'Просто шість гривень тест'

    assert norm('просто 6 547 грв.') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грв. тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грв. тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('просто 6 547 грв.') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грв. тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грв. тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'

    assert norm('просто 1 грв') == 'просто одна гривня.'
    assert norm('1 грв тест') == 'одна гривня тест'
    assert norm('Просто 1 грв тест') == 'Просто одна гривня тест'
    assert norm('просто 1 грв') == 'просто одна гривня.'
    assert norm('1 грв тест') == 'одна гривня тест'
    assert norm('Просто 1 грв тест') == 'Просто одна гривня тест'

    assert norm('просто 2 грв') == 'просто дві гривні.'
    assert norm('2 грв тест') == 'дві гривні тест'
    assert norm('Просто 2 грв тест') == 'Просто дві гривні тест'
    assert norm('просто 2 грв') == 'просто дві гривні.'
    assert norm('2 грв тест') == 'дві гривні тест'
    assert norm('Просто 2 грв тест') == 'Просто дві гривні тест'

    assert norm('просто 6 грв') == 'просто шість гривень.'
    assert norm('6 грв тест') == 'шість гривень тест'
    assert norm('Просто 6 грв тест') == 'Просто шість гривень тест'
    assert norm('просто 6 грв') == 'просто шість гривень.'
    assert norm('6 грв тест') == 'шість гривень тест'
    assert norm('Просто 6 грв тест') == 'Просто шість гривень тест'

    assert norm('просто 6 547 грв') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грв тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грв тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('просто 6 547 грв') == 'просто шість тисяч п\'ятсот сорок сім гривень.'
    assert norm('6 547 грв тест') == 'шість тисяч п\'ятсот сорок сім гривень тест'
    assert norm('Просто 6 547 грв тест') == 'Просто шість тисяч п\'ятсот сорок сім гривень тест'


def test_euro():
    # assert norm('просто 1€') == 'просто одне євро'
    # assert norm('1€ тест') == 'одне євро тест'
    # assert norm('Просто 1€ тест') == 'просто одне євро тест'
    # assert norm('просто 1€') == 'просто одне євро'
    # assert norm('1€ тест') == 'одне євро тест'
    # assert norm('Просто 1€ тест') == 'просто одне євро тест'

    assert norm('просто 2€') == 'просто два євро.'
    assert norm('2€ тест') == 'два євро тест'
    assert norm('Просто 2€ тест') == 'Просто два євро тест'
    assert norm('просто 2€') == 'просто два євро.'
    assert norm('2€ тест') == 'два євро тест'
    assert norm('Просто 2€ тест') == 'Просто два євро тест'

    assert norm('просто 6€') == 'просто шість євро.'
    assert norm('6€ тест') == 'шість євро тест'
    assert norm('Просто 6€ тест') == 'Просто шість євро тест'
    assert norm('просто 6€') == 'просто шість євро.'
    assert norm('6€ тест') == 'шість євро тест'
    assert norm('Просто 6€ тест') == 'Просто шість євро тест'

    assert norm('просто 6 547€') == 'просто шість тисяч п\'ятсот сорок сім євро.'
    assert norm('6 547€ тест') == 'шість тисяч п\'ятсот сорок сім євро тест'
    assert norm('Просто 6 547€ тест') == 'Просто шість тисяч п\'ятсот сорок сім євро тест'
    assert norm('просто 6 547€') == 'просто шість тисяч п\'ятсот сорок сім євро.'
    assert norm('6 547€ тест') == 'шість тисяч п\'ятсот сорок сім євро тест'
    assert norm('Просто 6 547€ тест') == 'Просто шість тисяч п\'ятсот сорок сім євро тест'


def test_unknown():
    assert norm('2-річний курс навчання.') == 'двох річний курс навчання.'
    assert norm('3-колісний велосипед.') == 'трьох колісний велосипед.'
    assert norm('5-стопний хорей.') == 'п\'яти стопний хорей.' 
    assert norm('2-годинна екскурсія.') == 'двох годинна екскурсія.'
    # assert norm('2-мільярдний прибуток.')
    # assert norm('5-мільйонний житель.')
    # assert norm('4-річна сестричка.')
    # assert norm('4-кілометровий пробіг.')
    # assert norm('4-тисячний тираж.')
    # assert norm('5-відсотковий кредит.')
    # assert norm('40-тонний вагон.')
    # assert norm('40-річний чоловік.')
    # assert norm('40-мяльярдний борг.')
    # assert norm('30-градусний мороз.')
    # assert norm('30-тисячний випуск.')
    # assert norm('12-річнийй син.')
    # assert norm('5-метрова глибина.') 
    # assert norm('3-значне число.')
    # assert norm('3-сотий журнал.')
    # assert norm('150-літній ювілей.')
    # assert norm('150-тисячна армія.') == 'сто пя\'тдесяти тисячна армія.'
    # assert norm('5-копійкова монета.')
    # assert norm('5-сотий кілометр.')

# def test_dash_replacments():
#     assert norm('Гаразд, — мовила Мак-Класкі.') == 'Гаразд, мовила Мак Класкі.'

def test_number_sentances():
    assert norm('1-го квітня, на 1-му поверсі Яринка загубила 2грн але знайшла 5€. Але її 4-річна сестричка забрала 50% її знахідки.') == \
    'першого квітня, на першому поверсі Яринка загубила дві гривні але знайшла п\'ять євро. Але її чотирьох річна сестричка забрала п\'ятдесят відсотків її знахідки.'

    assert norm('Також 2003 року щось там сталося і 40-річний чоловік помер. Його знайшли через 3 години.') == \
    'Також дві тисячі третього року щось там сталося і сорока річний чоловік помер. Його знайшли через три години.'

    assert norm('20% від 200 буде 40.') == \
    'двадцять відсотків від двісті буде 40.'

    assert norm('В будинуку №52.') == \
    'В будинуку номер п\'ятдесят два.'
 
    assert norm('Кожен, хто стоятиме у цій уявній вартівні у 2025-му, стоятиме в ній також і в 1914-му.') == \
    'Кожен, хто стоятиме у цій уявній вартівні у дві тисячі двадцять п\'ятому стоятиме в ній також і в одна тисяча дев\'ятсот чотирнадцятому.'

    # assert norm('Вони з\'являться аж десь біля 1926-го, а може й пізніше.') == 'Вони з\'являться аж десь біля одна тисяча дев\'ятсот двадцять шостого, а може й пізніше.'

    assert norm('Кроссліт 2025.') == 'Кроссліт дві тисячі двадцять п\'ять.'

    assert norm('200 тисяч британок опинилися 2002 року в лікарні через зловживання алкоголем. Кількість таких пацієнток 2010 року зросла понад удвічі.') == \
    'двісті тисяч британок опинилися дві тисячі другого року в лікарні через зловживання алкоголем. Кількість таких пацієнток дві тисячі десятого року зросла понад удвічі.'

    #assert norm('Розділ 8') == 'Розділ восьмий'
    #assert norm('Ми трималися там два дні і дві ночі, 130 чоловік з 16 льюісами.') == 'Ми трималися там два дні і дві ночі, сто тридцять чоловік з шістнадцятьма льюісами.'

    #assert norm('Кожного 2-го дня, я прокидався о 6 ранку.') == 'Кожного другого дня, я прокидався о шостій ранку.'


    