# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/config.ipynb.

# %% auto 0
__all__ = ["ConfigNotFound", "Configuration"]

# %% ../notebooks/config.ipynb 4
import os

from decouple import AutoConfig, Config, Csv, RepositoryEnv, UndefinedValueError


class ConfigNotFound(Exception):
    pass


class Configuration:
    project_name = ""
    config = None
    env_filepath = None

    def __init__(
        self, project_folder="leximpact-common-python-libraries", env_filepath=None
    ):
        """
        ::project_folder:: The folder of your project, where the .env is.
        Does not work if your .env is in a subfolder of the place you launch Python
        """
        self.project_name = project_folder
        self.env_filepath = env_filepath
        self.get_project_module_path()
        self.load_config()

    def get_project_module_path(self):
        cur_path = os.getcwd()
        root_pos = cur_path.find(self.project_name) + len(self.project_name)
        self.project_module_path = cur_path[:root_pos]
        return self.project_module_path

    def load_config(self):
        try:
            if self.env_filepath:
                path = self.env_filepath
                self.config = Config(RepositoryEnv(path))
            else:
                path = os.path.join(self.project_module_path, ".env")
                self.config = Config(RepositoryEnv(path))
        except (OSError, FileNotFoundError) as e:
            print(
                f"DEBUG : Unable to read env from {path} but it could be OK. Error : {e}"
            )
            print("DEBUG : Using decouple.AutoConfig()")
            self.config = AutoConfig()
        return self.config

    def __str__(self):
        msg = f"Config loaded from {self.project_module_path}/.env OR/AND environement variables"
        # for env, value in self.config.items():
        #     msg += f"\n{env}={value}"
        return msg

    def print_config(self, logger):
        logger.info(
            f"Config loaded from {self.project_module_path}/.env OR/AND environement variables"
        )
        # for env, value in self.config.items():
        #     logger.info(f"{env}={value}")

    def get(self, param_name, fail_on_missing=True, **kwargs):
        try:
            return self.config(param_name, **kwargs)
        except UndefinedValueError:
            if fail_on_missing:
                raise ConfigNotFound(
                    f"Parameter {param_name} not found in {self.project_module_path + '/.env OR/AND environement variables'}"
                )
            else:
                return None

    def set(self, param_name, value):
        os.environ[param_name] = str(value)

    def Csv(self, **kwargs):
        return Csv(**kwargs)
