"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from ..shared import discount as shared_discount
from dataclasses_json import Undefined, dataclass_json
from orb import utils
from typing import Optional


@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class NewCoupon:
    r"""A coupon represents a reusable discount configuration, and have an attached redemption code that can be issued to your end users. Coupons are most often used in self-serve signup or upgrade flows in your checkout experience or billing portal.
    
    To redeem a coupon, pass the `redemption_code` property in the [create subscription](create-subscription.api.mdx) or [schedule plan change](schedule-plan-change.api.mdx) request.
    """
    discount: shared_discount.Discount = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('discount') }})
    redemption_code: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('redemption_code') }})
    r"""This string can be used to redeem this coupon for a given subscription."""
    duration_in_months: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('duration_in_months'), 'exclude': lambda f: f is None }})
    r"""This allows for a coupon's discount to apply for a limited time (determined in months); a `null` value here means \\"unlimited time\\"."""
    max_redemptions: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('max_redemptions'), 'exclude': lambda f: f is None }})
    r"""The maximum number of redemptions allowed for this coupon before it is exhausted; `null` here means \\"unlimited\\"."""
    

