import os
svg_by_type={
    'git':'<svg t="1595640565871" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2073" width="16" height="16"><path d="M110.933333 451.84L357.546667 204.8l72.106666 72.533333c-10.24 36.266667 6.4 75.946667 39.68 95.146667v236.373333c-25.6 14.506667-42.666667 42.24-42.666666 73.813334a85.333333 85.333333 0 0 0 85.333333 85.333333 85.333333 85.333333 0 0 0 85.333333-85.333333c0-31.573333-17.066667-59.306667-42.666666-73.813334V401.493333l88.32 89.173334c-2.986667 6.4-2.986667 13.653333-2.986667 21.333333a85.333333 85.333333 0 0 0 85.333333 85.333333 85.333333 85.333333 0 0 0 85.333334-85.333333 85.333333 85.333333 0 0 0-85.333334-85.333333c-7.68 0-14.933333 0-21.333333 2.986666L594.346667 320a84.48 84.48 0 0 0-49.066667-99.84c-18.346667-6.826667-37.546667-8.533333-54.613333-3.84L418.133333 144.213333l33.706667-33.28c33.28-33.706667 87.04-33.706667 120.32 0l340.906667 340.906667c33.706667 33.28 33.706667 87.04 0 120.32l-340.906667 340.906667c-33.28 33.706667-87.04 33.706667-120.32 0L110.933333 572.16c-33.706667-33.28-33.706667-87.04 0-120.32z" fill="#E64A19" p-id="2074"></path></svg>',
    'jquery':'<svg t="1595640977216" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="9448" width="16" height="16"><path d="M65.44 250.624c-90.592 130.144-79.36 299.392-10.112 437.6 1.568 3.36 3.328 6.56 5.024 9.76 0.992 2.208 2.08 4.256 3.296 6.368 0.544 1.184 1.312 2.432 2.016 3.552 1.12 2.208 2.304 4.352 3.456 6.496l6.688 11.296c1.248 2.08 2.432 4.128 3.84 6.24 2.336 4 5.12 7.968 7.552 12 1.12 1.664 2.144 3.328 3.36 4.992 4.736 7.424 9.088 13.6 13.696 19.584l-0.48-0.64c3.328 4.576 6.656 8.992 10.24 13.44 1.152 1.632 2.432 3.232 3.616 4.864l9.44 11.488c1.152 1.312 2.304 2.848 3.552 4.224 4.192 5.024 8.608 9.952 13.056 14.88 0 0.096 0.128 0.16 0.224 0.288 5.504 6.944 11.456 13.088 17.92 18.624l0.192 0.16c3.424 3.488 6.816 7.008 10.464 10.4l4.32 4.128c4.736 4.448 9.472 8.864 14.464 13.152 0.096 0 0.128 0.096 0.224 0.128l2.432 2.144c4.352 3.808 8.736 7.584 13.216 11.104l5.344 4.48c3.616 2.912 7.392 5.664 11.104 8.544l5.792 4.448c3.968 2.976 8.192 5.92 12.256 8.832 1.504 1.056 2.976 2.144 4.512 3.104l1.248 0.992 12 7.904 5.12 3.424c6.272 4 12.512 7.808 18.688 11.552 1.792 0.896 3.584 1.888 5.248 2.912 4.608 2.656 9.376 5.344 14.048 7.808 2.56 1.44 5.216 2.688 7.84 4 3.2 1.792 6.528 3.552 9.952 5.344a12.384 12.384 0 0 1 2.464 1.024l-0.064-0.032c1.408 0.64 2.72 1.312 4.096 2.016 5.12 2.56 10.464 4.992 16 7.424 1.024 0.416 2.144 0.864 3.232 1.44 6.144 2.688 12.288 5.248 18.656 7.776 1.44 0.416 2.976 1.152 4.48 1.696 5.76 2.176 11.68 4.384 17.536 6.496l2.144 0.768c6.528 2.208 12.96 4.352 19.584 6.4 1.536 0.416 3.104 0.992 4.736 1.408 6.784 2.048 13.344 4.48 20.192 5.792 437.76 79.776 564.992-263.2 564.992-263.2-106.88 139.168-296.544 175.872-476.16 135.04-6.656-1.536-13.312-3.68-20-5.632a468.48 468.48 0 0 1-28.224-8.96l4.032 1.248-2.656-1.024c-5.792-1.952-11.392-4.128-17.056-6.304a55.616 55.616 0 0 0-4.224-1.6l-0.48-0.128c-6.272-2.528-12.384-5.12-18.432-7.808-1.312-0.416-2.432-1.024-3.744-1.536a529.28 529.28 0 0 1-21.28-9.856l5.888 2.592c-1.568-0.672-2.976-1.408-4.512-2.208a320.704 320.704 0 0 1-11.936-6.048 135.2 135.2 0 0 1-8.832-4.544l0.864 0.448c-4.832-2.56-9.632-5.344-14.464-7.968-1.44-1.024-3.104-1.888-4.768-2.816a573.696 573.696 0 0 1-21.376-13.088l2.688 1.6a93.6 93.6 0 0 1-5.28-3.552l0.256 0.192a245.472 245.472 0 0 1-14.08-9.312l0.768 0.544c-1.504-0.992-2.848-2.048-4.384-3.104-5.44-3.776-9.536-6.752-13.568-9.792l1.024 0.736c-1.792-1.44-3.712-2.816-5.632-4.256-3.744-2.944-7.552-5.76-11.296-8.864l-5.024-4c-5.568-4.48-10.208-8.416-14.752-12.416l0.512 0.416A11.392 11.392 0 0 0 280.672 736l-0.032-0.032-14.816-13.472-4.256-4c-3.488-3.552-7.072-6.944-10.656-10.464l-4.128-4.256a394.56 394.56 0 0 1-12.928-13.472l-0.256-0.288-0.64-0.672a761.216 761.216 0 0 1-13.344-15.104c-1.152-1.312-2.208-2.72-3.424-4.128l-9.632-11.808a654.816 654.816 0 0 1-12.8-16.704l-1.728-2.4C92.416 503.168 56.352 315.456 136.096 161.472z" fill="#0769AD" p-id="9449"></path><path d="M346.496 141.024c-65.664 94.24-61.952 220.288-10.848 319.968 9.472 18.688 19.072 34.496 29.696 49.504l-0.8-1.216c9.824 14.08 20.64 30.72 33.792 42.08a284.8 284.8 0 0 0 14.688 15.328l3.84 3.84c4.864 4.704 9.856 9.312 14.944 13.856l0.64 0.544c5.12 4.512 10.88 9.28 16.768 13.92l0.896 0.672c1.44 0.992 2.688 2.144 4.096 3.104 5.984 4.608 12 9.056 18.208 13.44l0.64 0.384c2.656 1.92 5.472 3.68 8.448 5.536 1.184 0.768 2.56 1.792 3.84 2.56 4.512 2.912 8.96 5.632 13.536 8.416 0.736 0.288 1.376 0.672 2.048 0.992 3.84 2.336 8.032 4.608 12.032 6.688 1.408 0.864 2.784 1.504 4.224 2.304 2.848 1.408 5.664 2.912 8.416 4.352l1.376 0.608c5.76 2.816 11.648 5.472 17.408 8.096a448.192 448.192 0 0 0 18.24 7.488c2.144 0.736 4.128 1.568 6.144 2.208 4.352 1.632 8.928 3.104 13.216 4.608l5.984 1.92c6.24 1.92 12.544 4.448 19.104 5.504 337.92 56.032 416.16-204.256 416.16-204.256-70.432 101.376-206.752 149.664-352.032 111.968a315.2 315.2 0 0 1-21.536-6.24l2.432 0.704c-2.048-0.544-3.84-1.184-5.792-1.792-4.448-1.536-8.992-3.04-13.312-4.64l-6.144-2.304c-4.768-1.92-9.632-3.712-14.304-5.76-1.44-0.64-2.784-1.056-3.872-1.696-5.984-2.688-12-5.344-17.792-8.192l-8.8-4.576-5.088-2.56c-3.936-2.048-7.552-4.192-11.296-6.4a30.464 30.464 0 0 1-2.752-1.504l0.096 0.064c-4.512-2.816-9.216-5.536-13.536-8.448-1.44-0.8-2.784-1.792-4.128-2.656l-8.864-5.792c-6.144-4.256-12.16-8.864-18.208-13.312-1.376-1.248-2.688-2.272-4-3.36-63.872-50.208-114.272-118.88-138.144-196.608-25.184-80.8-19.616-171.424 23.84-244.992z" fill="#0769AD" p-id="9450"></path><path d="M582.816 59.04c-38.752 56.832-42.464 127.392-15.776 190.08 28.32 66.56 86.272 118.816 153.76 143.584 2.784 1.056 5.472 1.952 8.32 2.976l3.744 1.152c3.936 1.248 7.904 2.688 11.936 3.584 186.72 36 237.216-95.872 250.848-115.232-44.448 63.84-119.008 79.136-210.432 56.928a202.144 202.144 0 0 1-23.424-7.296l1.408 0.48a262.4 262.4 0 0 1-27.936-11.552l1.6 0.704a278.272 278.272 0 0 1-46.784-28.672l0.672 0.512c-81.92-62.048-132.64-180.48-79.232-276.96z" fill="#0769AD" p-id="9451"></path></svg>',
    'bootstrap':'<svg t="1595640997568" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="10272" width="16" height="16"><path d="M853.344 0H170.688A171.104 171.104 0 0 0 0.032 170.656v682.656c0 93.856 76.8 170.656 170.656 170.656h682.656c93.856 0 170.656-76.8 170.656-170.656V170.656C1024 76.8 947.2 0 853.344 0z m-93.312 719.136a132.896 132.896 0 0 1-39.392 52.64c-17.92 14.496-40.608 26.464-68.576 34.976-27.904 8.672-61.088 13.024-99.552 13.024H278.08V222.432h290.208c53.664 0 96.672 12.064 128.864 36.704 32.416 24.736 48.544 61.6 48.544 111.36 0 30.08-7.328 55.904-22.112 77.216-14.688 21.216-35.84 37.792-63.136 49.312v1.952c36.448 7.68 64.64 24.96 83.2 51.84s28.064 60.832 28.064 101.856c0 22.944-4.448 44.8-12.8 65.184z m-118.464-147.2c-17.504-16-42.08-23.808-73.824-23.808h-184.416v186.368h184.928c31.584 0 56.32-8.192 73.824-24.736 17.504-16.416 26.464-39.84 26.464-69.984-0.288-29.44-8.96-52.224-26.464-67.84z m-25.6-120.448c16.896-14.336 25.184-34.848 25.184-61.6 0-30.048-7.456-51.36-22.624-63.584-15.008-12.16-36.704-18.464-65.184-18.464h-170.656v164.832h170.656c24.864 0 46.08-7.264 62.624-21.152z" fill="#563D7C" p-id="10273"></path></svg>',
    'folder':'<svg t="1595640894534" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="8376" width="16" height="16"><path d="M817.7664 477.4912l0-90.624c0-16.10752-13.04576-29.16352-29.16352-29.16352L787.0464 357.70368l0-71.77216c0-24.77056-20.15232-44.92288-44.93312-44.92288L349.7472 241.00864l-29.11232-76.41088c-3.04128-7.936-10.63936-13.18912-19.13856-13.18912L141.80352 151.40864c-5.45792 0-10.68032 2.17088-14.53056 6.0416-3.84 3.87072-5.9904 9.10336-5.94944 14.56128l0.12288 113.92 0 385.65888c0 24.77056 20.16256 44.92288 44.92288 44.92288l277.58592 0L443.9552 532.45952c0-30.3104 24.65792-54.96832 54.96832-54.96832L817.7664 477.4912zM237.8752 357.71392c-16.10752 0-29.16352 13.04576-29.16352 29.16352l0 288.68608-42.36288 0c-2.18112 0-3.96288-1.78176-3.96288-3.96288L162.38592 285.81888l-0.26624-93.44 125.24544 0 29.12256 76.41088c3.0208 7.936 10.63936 13.18912 19.13856 13.18912l406.4768 0c2.19136 0 3.97312 1.78176 3.97312 3.96288l0 71.77216L237.8752 357.71392zM873.29792 500.5312 504.04352 500.5312c-16.18944 0-29.36832 13.17888-29.36832 29.36832l0 313.31328c0 16.19968 13.17888 29.37856 29.36832 29.37856l369.26464 0c16.18944 0 29.36832-13.17888 29.36832-29.37856L902.67648 529.89952C902.66624 513.71008 889.48736 500.5312 873.29792 500.5312zM839.02464 525.18912c8.3968 0 15.2064 6.8096 15.2064 15.2064 0 8.3968-6.8096 15.2064-15.2064 15.2064-8.38656 0-15.2064-6.8096-15.2064-15.2064C823.808 531.98848 830.62784 525.18912 839.02464 525.18912zM777.99424 524.34944c8.3968 0 15.2064 6.8096 15.2064 15.2064 0 8.40704-6.8096 15.2064-15.2064 15.2064-8.38656 0-15.2064-6.8096-15.2064-15.2064C762.7776 531.15904 769.59744 524.34944 777.99424 524.34944zM877.48608 843.2128c0 2.32448-1.88416 4.1984-4.18816 4.1984L504.04352 847.4112c-2.31424 0-4.18816-1.88416-4.18816-4.1984L499.85536 573.96224l377.64096 0L877.49632 843.2128z" p-id="8377"></path></svg>',
    'unknown':'<svg t="1595640705687" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="6054" width="16" height="16"><path d="M814.19168068 314.86668722L624.20658762 124.79122834A28.39978995 28.39978995 0 0 0 604.16685565 116.49295998H229.23170568c-15.62722204 0-28.25304033 12.62504661-28.25304034 28.25226785v734.51031604c0 15.62567708 12.62581907 28.25226863 28.25304034 28.25226863h565.01060883c15.62567708 0 28.24763378-12.62659155 28.24763454-28.25226863v-544.43871878c0-7.50505197-3.00063048-14.65713407-8.29826837-19.95013787z m-56.85364474 32.92892682H591.1911566V181.6448731l166.14687934 166.15074093z m1.59106768 496.14671894H264.54491735V180.05843951h266.61123086v190.68717041c0 20.4838409 16.59576505 37.08037765 37.08037843 37.08037765h190.69257698V843.94233298z m0 0" p-id="6055"></path><path d="M414.62587228 544.66477857c0 4.76779724 3.88421347 8.38786249 8.65046654 8.38786248h28.60137611c4.76856972 0 8.65201071-3.7112043 8.65201072-8.30212997 0-24.89403342 22.77775919-45.5508835 51.20689858-45.55088429 28.42527781 0 51.20226451 20.65685008 51.20226375 45.46515178 0 22.33365025-18.53980259 41.6713041-43.52497507 44.93453789-17.03601159 2.47465145-30.45582033 17.92422944-30.63191863 35.40357747v28.24763455c0 4.85816382 3.96917349 8.82888227 8.82888228 8.8288815h28.24763376c4.85816382 0 8.8281098-3.97071845 8.8281098-8.8288815v-10.76751325c0-5.29763789 3.53510599-10.1519401 8.56550651-11.74223609 39.37429594-12.71232328 66.21236767-47.6717926 65.59602205-87.3125542-0.7067122-48.99562292-43.43847086-88.99012685-95.78769413-89.69297667-54.20752908-0.62097971-98.43458228 40.25247313-98.43458227 90.9295303z m0 0M483.48435561 716.81600801c0 15.60018923 12.64744532 28.25149615 28.25226862 28.25149537 15.60018923 0 28.24763378-12.65130693 28.24763379-28.25149537s-12.64744532-28.25226863-28.24763379-28.25226864c-15.60482332 0-28.25226863 12.65207941-28.25226862 28.25226864z m0 0" p-id="6056"></path></svg>'
}
svg_by_suffix={
    'ppt':'<svg t="1595641277979" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="13840" width="16" height="16"><path d="M622.592 892.416v-89.6h290.816v-42.752H622.592V691.2h290.816v-44.032H622.592v-108.032a147.712 147.712 0 0 0 104.704 43.52 150.016 150.016 0 0 0 149.248-151.04h-149.248V281.6a147.712 147.712 0 0 0-104.704 43.52V131.584H1024v760.832zM748.8 256v151.04h149.248a150.016 150.016 0 0 0-149.248-151.04zM0 110.592L576 0v1024L0 913.408z m153.6 626.432h88.064v-153.6s185.088 14.08 200.192-156.672c0 0 7.424-119.296-104.96-138.496a1409.536 1409.536 0 0 0-183.808 0zM340.992 435.2c3.584 76.8-106.24 76.8-106.24 76.8v-153.6c74.496 6.656 103.424 15.36 106.24 76.8z" fill="#FF6A4D" p-id="13841"></path></svg>',
    'pptx':'<svg t="1595641277979" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="13840" width="16" height="16"><path d="M622.592 892.416v-89.6h290.816v-42.752H622.592V691.2h290.816v-44.032H622.592v-108.032a147.712 147.712 0 0 0 104.704 43.52 150.016 150.016 0 0 0 149.248-151.04h-149.248V281.6a147.712 147.712 0 0 0-104.704 43.52V131.584H1024v760.832zM748.8 256v151.04h149.248a150.016 150.016 0 0 0-149.248-151.04zM0 110.592L576 0v1024L0 913.408z m153.6 626.432h88.064v-153.6s185.088 14.08 200.192-156.672c0 0 7.424-119.296-104.96-138.496a1409.536 1409.536 0 0 0-183.808 0zM340.992 435.2c3.584 76.8-106.24 76.8-106.24 76.8v-153.6c74.496 6.656 103.424 15.36 106.24 76.8z" fill="#FF6A4D" p-id="13841"></path></svg>',
    'md':'<svg t="1595641304764" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="14626" width="16" height="16"><path d="M133.529661 0.00041A49.70492 49.70492 0 0 0 97.40297 15.360397 54.149077 54.149077 0 0 0 81.920102 51.200369v921.599262a48.926681 48.926681 0 0 0 15.482868 35.839972A51.199959 51.199959 0 0 0 133.529661 1023.99959h756.940195a49.70492 49.70492 0 0 0 36.126691-15.359987A50.3398 50.3398 0 0 0 942.079414 972.799631V290.140337L649.625248 0.00041z" fill="#2287E1" p-id="14627"></path><path d="M942.079414 293.785775H700.128888a53.247957 53.247957 0 0 1-51.834839-51.855319V0.00041z" fill="#85B7E4" p-id="14628"></path><path d="M291.491775 716.697436v-188.190569l77.823937 188.190569h36.597731l77.823938-188.190569v188.190569h45.752283V441.630776h-50.339799l-91.504567 217.087827-91.525047-217.087827h-50.38076v275.06666z" fill="#FFFFFF" p-id="14629"></path><path d="M711.884398 658.370443l27.463658-28.671977a21.463023 21.463023 0 0 1 32.030695 0 23.859181 23.859181 0 0 1 0 33.484773l-64.061389 66.969546a21.463023 21.463023 0 0 1-32.030694 0l-64.061389-66.969546a23.859181 23.859181 0 0 1 0-33.484773 21.463023 21.463023 0 0 1 32.030694 0l27.463658 28.671977V433.541183a22.896622 22.896622 0 1 1 45.752284 0v224.82926z" fill="#FFFFFF" p-id="14630"></path></svg>',
    'py':'<svg t="1595641322434" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="15458" width="16" height="16"><path d="M420.693333 85.333333C353.28 85.333333 298.666667 139.946667 298.666667 207.36v71.68h183.04c16.64 0 30.293333 24.32 30.293333 40.96H207.36C139.946667 320 85.333333 374.613333 85.333333 442.026667v161.322666c0 67.413333 54.613333 122.026667 122.026667 122.026667h50.346667v-114.346667c0-67.413333 54.186667-122.026667 121.6-122.026666h224c67.413333 0 122.026667-54.229333 122.026666-121.642667V207.36C725.333333 139.946667 670.72 85.333333 603.306667 85.333333z m-30.72 68.693334c17.066667 0 30.72 5.12 30.72 30.293333s-13.653333 38.016-30.72 38.016c-16.64 0-30.293333-12.8-30.293333-37.973333s13.653333-30.336 30.293333-30.336z" fill="#3C78AA" p-id="15459"></path><path d="M766.250667 298.666667v114.346666a121.6 121.6 0 0 1-121.6 121.984H420.693333A121.6 121.6 0 0 0 298.666667 656.597333v160a122.026667 122.026667 0 0 0 122.026666 122.026667h182.613334A122.026667 122.026667 0 0 0 725.333333 816.64v-71.68h-183.082666c-16.64 0-30.250667-24.32-30.250667-40.96h304.64A122.026667 122.026667 0 0 0 938.666667 581.973333v-161.28a122.026667 122.026667 0 0 0-122.026667-122.026666zM354.986667 491.221333l-0.170667 0.170667c0.512-0.085333 1.066667-0.042667 1.621333-0.170667z m279.04 310.442667c16.64 0 30.293333 12.8 30.293333 37.973333a30.293333 30.293333 0 0 1-30.293333 30.293334c-17.066667 0-30.72-5.12-30.72-30.293334s13.653333-37.973333 30.72-37.973333z" fill="#FDD835" p-id="15460"></path></svg>',
    'pyc':'<svg t="1595641322434" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="15458" width="16" height="16"><path d="M420.693333 85.333333C353.28 85.333333 298.666667 139.946667 298.666667 207.36v71.68h183.04c16.64 0 30.293333 24.32 30.293333 40.96H207.36C139.946667 320 85.333333 374.613333 85.333333 442.026667v161.322666c0 67.413333 54.613333 122.026667 122.026667 122.026667h50.346667v-114.346667c0-67.413333 54.186667-122.026667 121.6-122.026666h224c67.413333 0 122.026667-54.229333 122.026666-121.642667V207.36C725.333333 139.946667 670.72 85.333333 603.306667 85.333333z m-30.72 68.693334c17.066667 0 30.72 5.12 30.72 30.293333s-13.653333 38.016-30.72 38.016c-16.64 0-30.293333-12.8-30.293333-37.973333s13.653333-30.336 30.293333-30.336z" fill="#3C78AA" p-id="15459"></path><path d="M766.250667 298.666667v114.346666a121.6 121.6 0 0 1-121.6 121.984H420.693333A121.6 121.6 0 0 0 298.666667 656.597333v160a122.026667 122.026667 0 0 0 122.026666 122.026667h182.613334A122.026667 122.026667 0 0 0 725.333333 816.64v-71.68h-183.082666c-16.64 0-30.250667-24.32-30.250667-40.96h304.64A122.026667 122.026667 0 0 0 938.666667 581.973333v-161.28a122.026667 122.026667 0 0 0-122.026667-122.026666zM354.986667 491.221333l-0.170667 0.170667c0.512-0.085333 1.066667-0.042667 1.621333-0.170667z m279.04 310.442667c16.64 0 30.293333 12.8 30.293333 37.973333a30.293333 30.293333 0 0 1-30.293333 30.293334c-17.066667 0-30.72-5.12-30.72-30.293334s13.653333-37.973333 30.72-37.973333z" fill="#FDD835" p-id="15460"></path></svg>',
    'xls':'<svg t="1595641341618" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="16289" width="16" height="16"><path d="M921.18736592 338.03832889h-162.38364445v100.92544h162.38364445v-100.92544z m0 128.45056h-162.38364445v100.96184889h162.38364445V466.48888889z m0-256.90112h-162.38364445v100.92544h162.38364445V209.58776889z m0 509.21472h-162.38364445v100.96184889h162.38364445V718.80248889z m74.63822222-610.14016H605.34025481a33.86026667 33.86026667 0 0 0-13.18001778 2.69425778V2.27555555L12.89481481 117.83736889v788.32526222L592.16023703 1021.72444445v-103.61969778a33.86026667 33.86026667 0 0 0 13.18001778 2.69425778h390.48533333c19.40593778 0 35.13457778-16.49322667 35.13457778-36.70016V145.36248889c-0.03640889-20.24334222-15.72864-36.70016-35.13457778-36.70016z m-592.37262222 573.54922666l-70.19633778-4.58752-52.61084444-133.11089777-57.05272889 123.97226667-65.86368-4.58752 83.37635556-151.53379556-74.56540445-165.15072 65.79086222-4.58752 43.87271111 123.86304h8.73813334l48.27818666-133.07448889 70.19633778-4.55111111-87.74542222 174.32576 87.74542222 179.02250666z m583.59808 192.67584H592.08741925v-55.05024h131.61813334V718.80248889h-131.61813334v-22.86478222h131.61813334V595.01226667h-131.61813334v-27.52512h131.61813334V466.48888889h-131.61813334v-27.56152889h131.61813334v-100.92544h-131.61813334v-27.48871111h131.61813334V209.58776889h-131.61813334V154.53752889h394.96362667v720.34986666z m-65.86368-279.91153777h-162.38364445v100.92544h162.38364445V595.01226667z" fill="#377F52" p-id="16290"></path></svg>',
    'xlsx':'<svg t="1595641341618" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="16289" width="16" height="16"><path d="M921.18736592 338.03832889h-162.38364445v100.92544h162.38364445v-100.92544z m0 128.45056h-162.38364445v100.96184889h162.38364445V466.48888889z m0-256.90112h-162.38364445v100.92544h162.38364445V209.58776889z m0 509.21472h-162.38364445v100.96184889h162.38364445V718.80248889z m74.63822222-610.14016H605.34025481a33.86026667 33.86026667 0 0 0-13.18001778 2.69425778V2.27555555L12.89481481 117.83736889v788.32526222L592.16023703 1021.72444445v-103.61969778a33.86026667 33.86026667 0 0 0 13.18001778 2.69425778h390.48533333c19.40593778 0 35.13457778-16.49322667 35.13457778-36.70016V145.36248889c-0.03640889-20.24334222-15.72864-36.70016-35.13457778-36.70016z m-592.37262222 573.54922666l-70.19633778-4.58752-52.61084444-133.11089777-57.05272889 123.97226667-65.86368-4.58752 83.37635556-151.53379556-74.56540445-165.15072 65.79086222-4.58752 43.87271111 123.86304h8.73813334l48.27818666-133.07448889 70.19633778-4.55111111-87.74542222 174.32576 87.74542222 179.02250666z m583.59808 192.67584H592.08741925v-55.05024h131.61813334V718.80248889h-131.61813334v-22.86478222h131.61813334V595.01226667h-131.61813334v-27.52512h131.61813334V466.48888889h-131.61813334v-27.56152889h131.61813334v-100.92544h-131.61813334v-27.48871111h131.61813334V209.58776889h-131.61813334V154.53752889h394.96362667v720.34986666z m-65.86368-279.91153777h-162.38364445v100.92544h162.38364445V595.01226667z" fill="#377F52" p-id="16290"></path></svg>',
    'doc':'<svg t="1595641363166" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="17115" width="16" height="16"><path d="M534.3232 0.4096h69.4272v95.232c124.3136 1.024 248.6272-1.2288 372.736 1.024 12.4928-1.4336 24.7808 2.8672 33.5872 11.6736 8.8064 8.8064 12.9024 21.2992 11.264 33.792 2.048 234.2912 0 468.992 1.2288 703.0784-1.2288 23.9616 2.2528 50.5856-11.264 72.0896-16.9984 12.0832-38.912 10.8544-58.7776 12.0832H603.9552v93.3888h-72.0896C354.5088 990.208 177.3568 959.8976 0 928.1536V95.8464C177.9712 63.8976 356.1472 32.768 534.3232 0.4096z m0 0" fill="#2A528F" p-id="17116"></path><path d="M603.9552 131.2768h383.3856v761.0368H603.9552v-95.232h302.08v-48.128H603.9552V690.176h302.08v-48.128H603.9552v-58.9824h302.08v-48.128H603.9552v-60.2112h302.08v-46.2848H603.9552v-60.2112h302.08V321.536H603.9552v-59.5968h302.08v-47.5136H603.9552V131.2768zM240.4352 341.4016c22.1184-1.2288 44.2368-2.2528 66.3552-3.4816 15.5648 80.2816 31.3344 160.3584 48.128 240.64 13.1072-82.5344 27.648-164.864 41.7792-247.1936 23.1424-0.8192 46.4896-2.2528 69.632-3.6864-26.4192 115.3024-49.3568 231.6288-78.0288 346.112-19.456 10.4448-48.128 0-71.4752 1.2288-16.1792-78.848-33.9968-157.2864-47.9232-236.1344-13.5168 76.8-31.3344 152.9856-46.6944 229.1712-22.3232-1.2288-44.6464-2.4576-67.1744-4.096-19.456-104.8576-42.1888-208.896-60.416-313.7536 19.8656-1.024 39.7312-1.8432 60.2112-2.4576 12.0832 75.776 25.6 151.1424 36.0448 227.1232 16.1792-78.0288 32.768-155.648 49.5616-233.472z m0 0" fill="#FFFFFF" p-id="17117"></path></svg>',
    'docx':'<svg t="1595641363166" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="17115" width="16" height="16"><path d="M534.3232 0.4096h69.4272v95.232c124.3136 1.024 248.6272-1.2288 372.736 1.024 12.4928-1.4336 24.7808 2.8672 33.5872 11.6736 8.8064 8.8064 12.9024 21.2992 11.264 33.792 2.048 234.2912 0 468.992 1.2288 703.0784-1.2288 23.9616 2.2528 50.5856-11.264 72.0896-16.9984 12.0832-38.912 10.8544-58.7776 12.0832H603.9552v93.3888h-72.0896C354.5088 990.208 177.3568 959.8976 0 928.1536V95.8464C177.9712 63.8976 356.1472 32.768 534.3232 0.4096z m0 0" fill="#2A528F" p-id="17116"></path><path d="M603.9552 131.2768h383.3856v761.0368H603.9552v-95.232h302.08v-48.128H603.9552V690.176h302.08v-48.128H603.9552v-58.9824h302.08v-48.128H603.9552v-60.2112h302.08v-46.2848H603.9552v-60.2112h302.08V321.536H603.9552v-59.5968h302.08v-47.5136H603.9552V131.2768zM240.4352 341.4016c22.1184-1.2288 44.2368-2.2528 66.3552-3.4816 15.5648 80.2816 31.3344 160.3584 48.128 240.64 13.1072-82.5344 27.648-164.864 41.7792-247.1936 23.1424-0.8192 46.4896-2.2528 69.632-3.6864-26.4192 115.3024-49.3568 231.6288-78.0288 346.112-19.456 10.4448-48.128 0-71.4752 1.2288-16.1792-78.848-33.9968-157.2864-47.9232-236.1344-13.5168 76.8-31.3344 152.9856-46.6944 229.1712-22.3232-1.2288-44.6464-2.4576-67.1744-4.096-19.456-104.8576-42.1888-208.896-60.416-313.7536 19.8656-1.024 39.7312-1.8432 60.2112-2.4576 12.0832 75.776 25.6 151.1424 36.0448 227.1232 16.1792-78.0288 32.768-155.648 49.5616-233.472z m0 0" fill="#FFFFFF" p-id="17117"></path></svg>',
    'js':'<svg t="1595641386057" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="17889" width="16" height="16"><path d="M676.297 0H145.61c-14.775 0-26.752 11.977-26.752 35.218v970.496c0 6.309 11.977 18.286 26.752 18.286h732.782c14.775 0 26.752-11.977 26.752-18.286V237.312c0-12.727-1.7-16.823-4.7-19.84L687.671 4.699A16.165 16.165 0 0 0 676.297 0z" fill="#E9E9E0" p-id="17890"></path><path d="M685.714 2.761V219.43h216.668z" fill="#D9D7CA" p-id="17891"></path><path d="M878.39 1024H145.61a26.752 26.752 0 0 1-26.753-26.752V713.143h786.286v284.105c0 14.775-11.977 26.752-26.752 26.752z" fill="#EEAF4B" p-id="17892"></path><path d="M475.813 781.147v143.507c0 8.667-1.591 15.963-4.755 21.87a39.333 39.333 0 0 1-12.745 14.244c-5.34 3.584-11.465 6.09-18.377 7.497s-14.062 2.121-21.376 2.121c-3.675 0-7.973-0.384-12.873-1.133s-10.002-1.902-15.25-3.493-10.295-3.383-15.123-5.376a55.26 55.26 0 0 1-12.251-6.747l12.745-20.243c1.664 1.152 4.041 2.377 7.131 3.62s6.455 2.415 10.13 3.493c3.658 1.098 7.498 2.03 11.502 2.871s7.754 1.244 11.246 1.244c8.814 0 15.872-1.72 21.12-5.12s8.028-9.216 8.375-17.372v-141h30.5z m149.266 137.49c0 6.657-1.372 13.13-4.133 19.384s-6.62 11.757-11.63 16.493-11.172 8.54-18.505 11.374a68.955 68.955 0 0 1-24.996 4.242c-4.005 0-8.119-0.22-12.38-0.621s-8.557-1.134-12.873-2.122c-4.333-1.005-8.466-2.377-12.38-4.132s-7.295-3.877-10.13-6.382l5.249-21.504c2.322 1.335 5.284 2.633 8.868 3.877s7.278 2.413 11.118 3.492a112.158 112.158 0 0 0 11.502 2.633c3.821 0.659 7.405 1.006 10.752 1.006 10.166 0 17.956-2.377 23.369-7.131s8.119-11.795 8.119-21.12c0-5.669-1.92-10.496-5.742-14.5-3.84-4.005-8.631-7.626-14.373-10.88s-11.959-6.492-18.633-9.747a112.878 112.878 0 0 1-18.743-11.502 59.685 59.685 0 0 1-14.5-15.616c-3.84-5.998-5.742-13.495-5.742-22.491 0-8.156 1.5-15.415 4.498-21.742s7.04-11.721 12.124-16.128 11.008-7.79 17.755-10.13 13.879-3.493 21.376-3.493c7.662 0 15.415 0.713 23.241 2.121 7.827 1.408 14.153 3.712 19 6.876a243.383 243.383 0 0 1-3.493 7.131l-3.749 7.241a294.202 294.202 0 0 1-2.999 5.632 23.095 23.095 0 0 1-1.5 2.505c-1.005-0.493-2.12-1.152-3.382-1.993s-3.054-1.664-5.376-2.505a38.528 38.528 0 0 0-9.253-1.755 87.424 87.424 0 0 0-14.756 0.256c-3.347 0.347-6.492 1.28-9.509 2.87s-5.687 3.53-8.009 5.87a26.441 26.441 0 0 0-5.504 7.881 20.114 20.114 0 0 0-1.993 8.375c0 6.656 1.902 12.032 5.742 16.128 3.821 4.096 8.576 7.662 14.244 10.752 5.669 3.09 11.813 6.09 18.505 8.997 6.656 2.907 12.873 6.473 18.633 10.624s10.533 9.38 14.373 15.616c3.877 6.254 5.815 14.281 5.815 24.119z" fill="#FFFFFF" p-id="17893"></path><path d="M356.571 347.429v-73.143c0-10.076 8.192-18.286 18.286-18.286a18.286 18.286 0 1 0 0-36.571c-30.244 0-54.857 24.612-54.857 54.857v73.143C320 367.598 303.598 384 283.429 384a18.286 18.286 0 1 0 0 36.571c20.169 0 36.571 16.403 36.571 36.572v73.143c0 30.244 24.613 54.857 54.857 54.857a18.286 18.286 0 1 0 0-36.572c-10.094 0-18.286-8.21-18.286-18.285v-73.143c0-21.943-9.91-41.436-25.27-54.857a72.686 72.686 0 0 0 25.27-54.857zM475.429 338.286a27.429 27.429 0 1 0 54.857 0 27.429 27.429 0 1 0-54.857 0zM722.286 384c-20.17 0-36.572-16.402-36.572-36.571v-73.143c0-30.245-24.612-54.857-54.857-54.857a18.286 18.286 0 1 0 0 36.571c10.094 0 18.286 8.21 18.286 18.286v73.143c0 21.942 9.91 41.435 25.27 54.857a72.686 72.686 0 0 0-25.27 54.857v73.143c0 10.075-8.192 18.285-18.286 18.285a18.286 18.286 0 1 0 0 36.572c30.245 0 54.857-24.613 54.857-54.857v-73.143c0-20.17 16.403-36.572 36.572-36.572a18.286 18.286 0 1 0 0-36.571z m-219.429 54.857a18.286 18.286 0 0 0-18.286 18.286V512a18.286 18.286 0 1 0 36.572 0v-54.857a18.286 18.286 0 0 0-18.286-18.286z" fill="#EEAF4B" p-id="17894"></path></svg>',
    'html':'<svg t="1595641411708" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="18832" width="16" height="16"><path d="M919.415066 901.492615l-81.669546 0 0 20.418409c0 56.367563-45.69075 102.088976-102.086932 102.088976L102.713477 1024c-56.366541 0-102.086932-45.720391-102.086932-102.088976L0.626545 105.208413c0-56.397204 45.720391-102.087954 102.086932-102.087954l408.351817 0 37.693872 0 0-3.120459 2.873111 3.120459 0.268811 0 0 0.308673 282.763835 305.954167 3.081619 0 0 3.349408 1.405382 1.505547-1.405382 0 0 240.154704 81.669546 0c56.398226 0 102.088976 45.691772 102.088976 102.089998l0 142.922727C1021.504042 855.774269 975.813292 901.492615 919.415066 901.492615M551.900066 76.396553l0 130.898792c0 56.367563 45.719369 102.087954 102.088976 102.087954l117.728065 0L551.900066 76.396553zM796.911769 350.220116 613.153247 350.220116c-56.367563 0-102.087954-45.720391-102.087954-102.087954L511.065293 43.956253 143.549272 43.956253c-56.367563 0-102.086932 45.69075-102.086932 102.087954l0 735.031021c0 56.366541 45.719369 102.088976 102.086932 102.088976l551.273521 0c49.370295 0 90.574045-35.061976 100.023321-81.670568L245.636204 901.493637c-56.367563 0-102.087954-45.718347-102.087954-102.08591L143.54825 656.483978c0-56.398226 45.720391-102.089998 102.087954-102.089998l551.274544 0L796.910747 350.220116zM661.255122 827.988593l34.095073 0 34.81565-138.057551 0 138.057551 32.899221 0L763.065066 652.605125l-53.1081 0L678.49379 772.247575l-31.834197-119.64245-53.006912 0 0 175.383469 32.918641 0L626.571322 689.931042 661.255122 827.988593zM565.189356 682.274523l0-29.668376L425.825567 652.606147l0 29.668376 52.02059 0 0 145.714071 35.402333 0L513.24849 682.274523 565.189356 682.274523zM290.81795 721.634411l0-69.029286-35.402333 0 0 175.383469 35.402333 0 0-76.684784 69.397241 0 0 76.684784 35.411532 0L395.626723 652.605125l-35.411532 0L360.215191 721.634411 290.81795 721.634411zM928.786662 798.437758l-88.041291 0L840.745371 654.048324l-35.420731 0 0 173.940269 123.462022 0L928.786662 798.437758zM288.225915 125.765826l29.061251 0-50.516065 384.873253-28.502164 0L288.225915 125.765826zM475.62412 350.967268 337.127068 462.147787l0-71.850271 96.644272-70.075913-96.644272-69.268457 0-71.341267L475.62412 290.023782 475.62412 350.967268zM80.073032 289.514778l138.326362-110.422124 0 72.337811-96.495046 68.031721 96.495046 70.584916 0 71.810409L80.073032 350.967268 80.073032 289.514778z" p-id="18833"></path></svg>',
    'htm':'<svg t="1595641411708" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="18832" width="16" height="16"><path d="M919.415066 901.492615l-81.669546 0 0 20.418409c0 56.367563-45.69075 102.088976-102.086932 102.088976L102.713477 1024c-56.366541 0-102.086932-45.720391-102.086932-102.088976L0.626545 105.208413c0-56.397204 45.720391-102.087954 102.086932-102.087954l408.351817 0 37.693872 0 0-3.120459 2.873111 3.120459 0.268811 0 0 0.308673 282.763835 305.954167 3.081619 0 0 3.349408 1.405382 1.505547-1.405382 0 0 240.154704 81.669546 0c56.398226 0 102.088976 45.691772 102.088976 102.089998l0 142.922727C1021.504042 855.774269 975.813292 901.492615 919.415066 901.492615M551.900066 76.396553l0 130.898792c0 56.367563 45.719369 102.087954 102.088976 102.087954l117.728065 0L551.900066 76.396553zM796.911769 350.220116 613.153247 350.220116c-56.367563 0-102.087954-45.720391-102.087954-102.087954L511.065293 43.956253 143.549272 43.956253c-56.367563 0-102.086932 45.69075-102.086932 102.087954l0 735.031021c0 56.366541 45.719369 102.088976 102.086932 102.088976l551.273521 0c49.370295 0 90.574045-35.061976 100.023321-81.670568L245.636204 901.493637c-56.367563 0-102.087954-45.718347-102.087954-102.08591L143.54825 656.483978c0-56.398226 45.720391-102.089998 102.087954-102.089998l551.274544 0L796.910747 350.220116zM661.255122 827.988593l34.095073 0 34.81565-138.057551 0 138.057551 32.899221 0L763.065066 652.605125l-53.1081 0L678.49379 772.247575l-31.834197-119.64245-53.006912 0 0 175.383469 32.918641 0L626.571322 689.931042 661.255122 827.988593zM565.189356 682.274523l0-29.668376L425.825567 652.606147l0 29.668376 52.02059 0 0 145.714071 35.402333 0L513.24849 682.274523 565.189356 682.274523zM290.81795 721.634411l0-69.029286-35.402333 0 0 175.383469 35.402333 0 0-76.684784 69.397241 0 0 76.684784 35.411532 0L395.626723 652.605125l-35.411532 0L360.215191 721.634411 290.81795 721.634411zM928.786662 798.437758l-88.041291 0L840.745371 654.048324l-35.420731 0 0 173.940269 123.462022 0L928.786662 798.437758zM288.225915 125.765826l29.061251 0-50.516065 384.873253-28.502164 0L288.225915 125.765826zM475.62412 350.967268 337.127068 462.147787l0-71.850271 96.644272-70.075913-96.644272-69.268457 0-71.341267L475.62412 290.023782 475.62412 350.967268zM80.073032 289.514778l138.326362-110.422124 0 72.337811-96.495046 68.031721 96.495046 70.584916 0 71.810409L80.073032 350.967268 80.073032 289.514778z" p-id="18833"></path></svg>',
    'png':'<svg t="1595641547206" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="22023" width="16" height="16"><path d="M832.2 127.9v766H192.7v-766h639.5m0-64H192.7c-35.3 0-64 28.7-64 64v766c0 35.3 28.7 64 64 64h639.5c35.3 0 64-28.7 64-64v-766c0-35.4-28.7-64-64-64z" fill="#A3D1C1" p-id="22024"></path><path d="M733.039 824.168v-32h97.9v32z" fill="#8C98A6" p-id="22025"></path><path d="M906.4 958.3h-483v-176c0-35.3 24.1-64 53.8-64h429.2c29.7 0 53.8 28.7 53.8 64v112c0 35.4-24.1 64-53.8 64z" fill="#83B29E" p-id="22026"></path><path d="M684.3 597.6c-6.1 0-12.1-0.3-18.1-0.8-66-5.9-109-41.5-150.5-75.9-36.7-30.4-71.4-59.2-119.3-62.7-64.9-4.7-136.2 39.2-212 130.5l-24.6-20.4c46.3-55.8 92.2-95.7 136.4-118.6 34.7-17.9 69.2-25.8 102.6-23.4 58.1 4.2 98.4 37.6 137.4 69.9 39.5 32.7 76.8 63.7 132.9 68.6 57.4 5.1 118.3-18.9 180.9-71.5l20.6 24.5c-63.1 53.1-125.7 79.8-186.3 79.8z" fill="#A3D1C1" p-id="22027"></path><path d="M687.6 372m-80.1 0a80.1 80.1 0 1 0 160.2 0 80.1 80.1 0 1 0-160.2 0Z" fill="#A3D1C1" p-id="22028"></path><path d="M555.3 770.8c34.4 0 51.8 14.6 51.8 43.8 0 29.4-17.4 44.2-52.2 44.2h-35.4v54.8h-23.4V770.8h59.2z m-35.8 68h34c10.4 0 18-2 22.8-5.6 4.8-3.8 7.2-10 7.2-18.6 0-8.6-2.6-14.6-7.4-18.2-4.8-3.8-12.4-5.6-22.6-5.6h-34v48zM650.5 770.8l70.6 103h0.8v-103h23.6v142.8h-22.8l-71.4-104.4h-0.8v104.4h-23.4V770.8h23.4zM878.9 780.2c10.2 8 16.6 19.8 19.2 35.8h-23.6c-2-9.2-6.4-16-12.8-20.6-6.6-4.6-15.4-6.8-26.2-6.8-13.4 0-24 4.4-31.8 13.6-8.6 9.6-12.8 23-12.8 40.6 0 16.8 3.8 29.8 11.4 38.8 8.2 9.6 21 14.4 38.4 14.4 6.8 0 13.2-0.8 19.2-2.4 5.6-1.6 10.6-3.8 15.4-6.6v-29.4h-37.8v-20h61.2V898c-7.6 6-16.2 10.4-26 13.6-10.4 3.2-21.8 4.8-34.6 4.8-22.8 0-40.4-7.2-53-21.6-11.8-13.4-17.6-30.8-17.6-52 0-21.4 5.8-39 17.6-52.8 12.4-14.8 29.2-22 50.4-22 18.4 0 32.8 4 43.4 12.2z" fill="#FFFFFF" p-id="22029"></path></svg>',
    'svg':'<svg t="1595641629014" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="25608" width="16" height="16"><path d="M332.799002 686.081014m-332.799002 0a332.799002 332.799002 0 1 0 665.598003 0 332.799002 332.799002 0 1 0-665.598003 0Z" fill="#DFDFF2" p-id="25609"></path><path d="M290.559128 595.969284l20.991937-25.599923a87.551737 87.551737 0 0 0 60.15982 25.599923c27.391918 0 42.751872-12.799962 42.751872-31.999904s-15.359954-27.135919-36.351891-36.351891l-31.231907-13.567959a65.023805 65.023805 0 0 1-46.079861-59.135823 67.071799 67.071799 0 0 1 74.239777-62.207813 96.76771 96.76771 0 0 1 68.351795 28.671914l-18.687944 22.783932a71.935784 71.935784 0 0 0-49.663851-20.22394c-23.039931 0-38.143886 11.007967-38.143886 29.183913s18.175945 25.599923 36.60789 34.047897l30.975908 13.311961A62.975811 62.975811 0 0 1 450.302649 563.201382c0 36.351891-29.95191 65.791803-79.615761 65.791803a112.639662 112.639662 0 0 1-80.12776-33.023901zM462.846611 399.105875h37.887887l33.535899 116.991649c7.679977 25.599923 12.543962 47.871856 20.479939 73.983778h1.535995c7.679977-25.599923 13.31196-48.127856 20.479939-73.983778l33.535899-116.991649h36.351891l-70.655788 226.047322h-42.239873zM659.96602 512.001536c0-73.727779 45.567863-118.015646 105.215684-118.015646a90.11173 90.11173 0 0 1 67.327798 28.671914l-19.455941 22.783932a61.183816 61.183816 0 0 0-46.59186-20.22394c-41.983874 0-70.14379 32.511902-70.14379 85.759743s25.599923 86.52774 71.423786 86.52774a56.063832 56.063832 0 0 0 35.583893-11.007966v-52.479843h-44.543866v-29.183913h76.799769v98.047706a102.399693 102.399693 0 0 1-71.423785 25.599924c-60.15982 0.767998-104.191687-41.727875-104.191688-116.479651z" fill="#434260" p-id="25610"></path><path d="M883.19735 1024h-639.99808A141.055577 141.055577 0 0 1 102.399693 883.200422v-742.397772A141.055577 141.055577 0 0 1 243.19927 0.003072h516.350451a89.087733 89.087733 0 0 1 63.231811 25.599923l189.695431 189.695431A38.399885 38.399885 0 0 1 1023.996928 243.202342v639.99808a141.055577 141.055577 0 0 1-140.799578 140.799578zM243.19927 76.802842A63.999808 63.999808 0 0 0 179.199462 140.80265v742.397772A63.999808 63.999808 0 0 0 243.19927 947.20023h639.99808a63.999808 63.999808 0 0 0 63.999808-63.999808V259.074295l-179.199462-179.199463a12.799962 12.799962 0 0 0-8.447975-3.07199z" fill="#434260" p-id="25611"></path></svg>',
    'jpg':'<svg t="1595641578570" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="23185" width="16" height="16"><path d="M675.82396 0H146.67196C131.94396 0 119.99996 11.984 119.99996 35.216v970.496C119.99996 1012.024 131.94396 1024 146.67196 1024h730.648c14.736 0 26.68-11.976 26.68-18.288v-768.4c0-12.728-1.688-16.824-4.68-19.84L687.16796 4.696A16.112 16.112 0 0 0 675.82396 0z" fill="#E9E9E0" p-id="23186"></path><path d="M685.20796 2.76v216.672h216.04z" fill="#D9D7CA" p-id="23187"></path><path d="M263.35196 263.88a83.552 83.304 90 1 0 166.608 0 83.552 83.304 90 1 0-166.608 0Z" fill="#F3D55B" p-id="23188"></path><path d="M119.99996 713.144h784V512L721.67196 338.288l-191.44 210.28-99.968-100.256z" fill="#26B99A" p-id="23189"></path><path d="M877.31996 1024H146.67196A26.72 26.72 0 0 1 119.99996 997.24V713.144h784v284.104A26.72 26.72 0 0 1 877.31996 1024z" fill="#14A085" p-id="23190"></path><path d="M392.14396 779.888v143.504c0 8.672-1.584 15.968-4.744 21.872a39.184 39.184 0 0 1-12.704 14.24 50.584 50.584 0 0 1-18.328 7.496c-6.912 1.432-14 2.144-21.32 2.144-3.664 0-7.944-0.384-12.832-1.136a106.736 106.736 0 0 1-15.2-3.504 163.104 163.104 0 0 1-15.08-5.368c-4.832-2-8.896-4.24-12.216-6.752l12.704-20.232c1.664 1.152 4.024 2.376 7.112 3.616 3.064 1.248 6.432 2.416 10.096 3.496 3.648 1.104 7.48 2.032 11.472 2.864 3.992 0.84 7.728 1.24 11.208 1.24 8.808 0 15.824-1.72 21.056-5.112 5.232-3.408 8.008-9.224 8.352-17.376V779.888h30.424zM466.67196 967.896h-29.92V783.632h52.832c7.808 0 15.536 1.24 23.176 3.76 7.64 2.504 14.488 6.24 20.56 11.24a58.456 58.456 0 0 1 14.72 18.128c3.736 7.072 5.608 15.016 5.608 23.872 0 9.344-1.576 17.8-4.736 25.376-3.16 7.592-7.568 13.968-13.216 19.136-5.656 5.16-12.472 9.168-20.44 11.992-7.976 2.832-16.792 4.24-26.424 4.24h-22.184v66.52h0.024z m0-161.496v73h27.424c3.648 0 7.256-0.624 10.848-1.888 3.568-1.24 6.856-3.28 9.84-6.12 2.992-2.832 5.392-6.792 7.216-11.864 1.832-5.088 2.736-11.384 2.736-18.864 0-3-0.416-6.488-1.24-10.368a29.52 29.52 0 0 0-5.104-11.248c-2.592-3.592-6.2-6.592-10.848-9-4.664-2.432-10.808-3.64-18.448-3.64h-22.424zM721.67196 872.888v71.232a53.792 53.792 0 0 1-12.832 11.872 77.216 77.216 0 0 1-31.152 11.856c-5.576 0.872-11.088 1.28-16.568 1.28-10.984 0-21.064-2-30.288-6a67.84 67.84 0 0 1-24.176-17.752c-6.88-7.832-12.312-17.664-16.2-29.496-3.896-11.832-5.848-25.504-5.848-41s1.952-29.128 5.848-40.864c3.888-11.768 9.296-21.536 16.2-29.368a69.056 69.056 0 0 1 24.304-17.888c9.304-4.088 19.368-6.12 30.168-6.12 9.968 0 19.264 1.656 27.904 5a67.8 67.8 0 0 1 23.176 14.976l-20.696 18.504c-3.992-4.832-8.568-8.336-13.72-10.488a40.736 40.736 0 0 0-15.952-3.264c-6.152 0-12.008 1.168-17.568 3.504-5.576 2.336-10.552 6.296-14.944 11.864-4.416 5.584-7.856 12.776-10.336 21.632-2.488 8.84-3.832 19.648-4 32.488 0.168 12.512 1.456 23.336 3.864 32.496 2.408 9.168 5.728 16.664 9.976 22.504 4.24 5.832 9.056 10.168 14.456 13a36.256 36.256 0 0 0 17.096 4.232c1.808 0 4.256-0.128 7.344-0.376 3.048-0.256 6.144-0.664 9.216-1.248a58.184 58.184 0 0 0 8.848-2.376c2.832-1 4.896-2.408 6.224-4.24v-45.496h-31.16v-20.504h60.824v0.04z" fill="#FFFFFF" p-id="23191"></path></svg>',
    'jpeg':'<svg t="1595641597589" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="24196" width="16" height="16"><path d="M295.594667 946.517333h-146.773334V75.093333h727.722667v671.744h72.704V75.093333c0-40.277333-32.768-72.704-72.704-72.704H148.821333C108.544 2.389333 76.117333 35.157333 76.117333 75.093333v871.424c0 40.277333 32.768 72.704 72.704 72.704h147.114667v-72.704z" fill="#A3D1C1" p-id="24197"></path><path d="M707.925333 609.28c-6.826667 0-13.653333-0.341333-20.48-1.024-75.093333-6.826667-123.904-47.104-171.349333-86.357333-41.642667-34.474667-81.237333-67.242667-135.850667-71.338667-73.728-5.461333-154.965333 44.714667-241.322666 148.48l-27.989334-23.210667c52.565333-63.488 104.789333-108.885333 155.306667-134.826666 39.594667-20.48 78.848-29.354667 116.736-26.624 66.218667 4.778667 111.957333 42.666667 156.330667 79.530666 45.056 37.205333 87.381333 72.362667 151.210666 78.165334 65.194667 5.802667 134.485333-21.504 205.824-81.237334l23.552 27.989334c-71.68 60.074667-143.018667 90.453333-211.968 90.453333zM620.544 352.597333c0 50.176 40.96 91.136 91.136 91.136s91.136-40.96 91.136-91.136-40.618667-91.136-91.136-91.136c-50.176 0-91.136 40.96-91.136 91.136z" fill="#A3D1C1" p-id="24198"></path><path d="M596.650667 835.925333c-5.461333-4.437333-13.994667-6.485333-25.6-6.485333H532.48v54.613333h38.570667c11.946667 0 20.48-2.389333 25.941333-6.485333 5.461333-4.437333 8.192-11.264 8.192-21.162667-0.341333-9.557333-3.072-16.384-8.533333-20.48z" fill="#83B29E" p-id="24199"></path><path d="M949.248 746.837333H368.64c-40.277333 0-72.704 32.768-72.704 72.704v200.362667h653.312c40.277333 0 72.704-32.426667 72.704-72.704v-127.317333c0-40.618667-32.768-73.045333-72.704-73.045334z m-475.477333 169.642667c0 18.773333-3.754667 32.426667-11.605334 41.301333-8.533333 9.557333-22.186667 14.336-41.301333 14.336-16.384 0-29.013333-4.437333-37.205333-13.653333-8.533333-9.216-12.970667-21.504-12.970667-37.546667v-5.12h26.624v5.12c0 18.773333 7.850667 27.989333 24.234667 27.989334 8.874667 0 15.36-2.730667 19.456-7.850667 4.096-5.12 6.144-13.653333 6.144-25.258667v-108.885333h26.624v109.568z m98.645333-9.557333h-40.277333V969.386667h-26.624v-162.474667h67.242666c39.253333 0 59.050667 16.725333 59.050667 49.834667s-19.797333 50.176-59.392 50.176z m203.093333 62.122666h-121.173333v-162.474666H771.413333v22.869333h-90.453333v45.056h84.992v22.869333h-84.992v49.152h94.549333v22.528z m167.594667-17.749333c-8.533333 6.826667-18.432 11.946667-29.696 15.36-11.946667 3.754667-24.917333 5.461333-39.253333 5.461333-25.941333 0-46.08-8.192-60.416-24.576-13.312-15.36-20.138667-35.157333-20.138667-59.050666 0-24.234667 6.485333-44.373333 20.138667-60.074667 13.994667-16.725333 33.109333-24.917333 57.344-24.917333 20.821333 0 37.205333 4.437333 49.493333 13.994666 11.605333 9.216 18.773333 22.528 21.845333 40.618667h-26.965333c-2.389333-10.581333-7.168-18.090667-14.677333-23.552-7.509333-5.12-17.408-7.850667-29.696-7.850667-15.36 0-27.306667 5.12-36.181334 15.36-9.898667 10.922667-14.677333 26.282667-14.677333 46.08 0 19.114667 4.437333 33.792 12.970667 44.032 9.216 10.922667 23.893333 16.384 43.690666 16.384 7.850667 0 15.018667-1.024 21.845334-2.730666 6.485333-1.706667 11.946667-4.437333 17.408-7.509334v-33.450666h-43.008v-22.869334h69.632v69.290667z" fill="#83B29E" p-id="24200"></path></svg>',
    'mp3':'<svg t="1595648353192" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="27501" width="16" height="16"><path d="M160 32c-12 0-24.8 4.8-33.6 14.4S112 68 112 80v864c0 12 4.8 24.8 14.4 33.6 9.6 9.6 21.6 14.4 33.6 14.4h704c12 0 24.8-4.8 33.6-14.4 9.6-9.6 14.4-21.6 14.4-33.6V304L640 32H160z" fill="#FF5562" p-id="27502"></path><path d="M912 304H688c-12 0-24.8-4.8-33.6-14.4-9.6-8.8-14.4-21.6-14.4-33.6V32l272 272z" fill="#FFBBC0" p-id="27503"></path><path d="M669.6 491.2c0-1.6 0.8-4 0-6.4V369.6c0-4.8-2.4-8.8-5.6-12-4-3.2-8-4-12.8-3.2l-250.4 70.4c-7.2 1.6-12 7.2-12 14.4v275.2c-9.6-4-20.8-6.4-32.8-6.4-8.8 0-17.6 0.8-26.4 3.2-40.8 11.2-66.4 43.2-58.4 72.8 6.4 23.2 30.4 37.6 60.8 37.6 8.8 0 17.6-1.6 26.4-3.2 36.8-10.4 60.8-36.8 60-63.2 0.8-1.6 0.8-3.2 0.8-5.6V570.4l220-61.6v136c-9.6-4-20.8-6.4-32.8-6.4-8.8 0-17.6 0.8-26.4 3.2-40.8 11.2-66.4 43.2-58.4 72.8 6.4 23.2 30.4 37.6 60.8 37.6 8.8 0 17.6-0.8 26.4-3.2 36-9.6 60-36 60-62.4 0.8-1.6 0.8-3.2 0.8-5.6V491.2z m-250.4 48v-53.6L639.2 424v53.6l-220 61.6z" fill="#FFFFFF" p-id="27504"></path></svg>',
    'avi':'<svg t="1595664419454" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1197" width="16" height="16"><path d="M432 356.16A32 32 0 0 0 384 384v256a32 32 0 0 0 48 27.84l224-128a32 32 0 0 0 0-55.68z m16 228.48v-145.6L576 512z" fill="#231815" p-id="1198"></path><path d="M864 32H160a128 128 0 0 0-128 128v704a128 128 0 0 0 128 128h704a128 128 0 0 0 128-128v-128H96V288h896V160a128 128 0 0 0-128-128z m-96 768h160v64a64 64 0 0 1-64 64h-96z m-224 0h160v128h-160z m-224 0h160v128h-160z m-64 0v128H160a64 64 0 0 1-64-64v-64zM256 224H96V160a64 64 0 0 1 64-64h96z m224 0h-160V96h160z m224 0h-160V96h160z m224 0h-160V96h96a64 64 0 0 1 64 64z" fill="#231815" p-id="1199"></path><path d="M960 384m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#231815" p-id="1200"></path><path d="M960 480a32 32 0 0 0-32 32v128a32 32 0 0 0 64 0v-128a32 32 0 0 0-32-32z" fill="#231815" p-id="1201"></path></svg>',
    'mp4':'<svg t="1595664419454" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1197" width="16" height="16"><path d="M432 356.16A32 32 0 0 0 384 384v256a32 32 0 0 0 48 27.84l224-128a32 32 0 0 0 0-55.68z m16 228.48v-145.6L576 512z" fill="#231815" p-id="1198"></path><path d="M864 32H160a128 128 0 0 0-128 128v704a128 128 0 0 0 128 128h704a128 128 0 0 0 128-128v-128H96V288h896V160a128 128 0 0 0-128-128z m-96 768h160v64a64 64 0 0 1-64 64h-96z m-224 0h160v128h-160z m-224 0h160v128h-160z m-64 0v128H160a64 64 0 0 1-64-64v-64zM256 224H96V160a64 64 0 0 1 64-64h96z m224 0h-160V96h160z m224 0h-160V96h160z m224 0h-160V96h96a64 64 0 0 1 64 64z" fill="#231815" p-id="1199"></path><path d="M960 384m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#231815" p-id="1200"></path><path d="M960 480a32 32 0 0 0-32 32v128a32 32 0 0 0 64 0v-128a32 32 0 0 0-32-32z" fill="#231815" p-id="1201"></path></svg>',
    'wmv':'<svg t="1595664419454" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1197" width="16" height="16"><path d="M432 356.16A32 32 0 0 0 384 384v256a32 32 0 0 0 48 27.84l224-128a32 32 0 0 0 0-55.68z m16 228.48v-145.6L576 512z" fill="#231815" p-id="1198"></path><path d="M864 32H160a128 128 0 0 0-128 128v704a128 128 0 0 0 128 128h704a128 128 0 0 0 128-128v-128H96V288h896V160a128 128 0 0 0-128-128z m-96 768h160v64a64 64 0 0 1-64 64h-96z m-224 0h160v128h-160z m-224 0h160v128h-160z m-64 0v128H160a64 64 0 0 1-64-64v-64zM256 224H96V160a64 64 0 0 1 64-64h96z m224 0h-160V96h160z m224 0h-160V96h160z m224 0h-160V96h96a64 64 0 0 1 64 64z" fill="#231815" p-id="1199"></path><path d="M960 384m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#231815" p-id="1200"></path><path d="M960 480a32 32 0 0 0-32 32v128a32 32 0 0 0 64 0v-128a32 32 0 0 0-32-32z" fill="#231815" p-id="1201"></path></svg>',
    'css':'<svg t="1595648386628" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="28352" width="16" height="16"><path d="M88.064 27.648l77.824 871.424L512 996.352l346.112-97.28 77.824-871.424z" fill="#2196F3" p-id="28353"></path><path d="M771.072 312.32l-10.24 109.568-29.696 328.704L512 811.008l-220.16-60.416-14.336-172.032h107.52l7.168 89.088L512 700.416l119.808-32.768 16.384-148.48-375.808 1.024-11.264-101.376 395.264-4.096 8.192-108.544-413.696 1.024-7.168-101.376h536.576z" fill="#FAFAFA" p-id="28354"></path></svg>',
    'txt':'<svg t="1595648320965" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="26590" width="16" height="16"><path d="M832.2 127.9v766H192.7v-766h639.5m0-64H192.7c-35.3 0-64 28.7-64 64v766c0 35.3 28.7 64 64 64h639.5c35.3 0 64-28.7 64-64v-766c0-35.4-28.7-64-64-64z" fill="#A3BDD3" p-id="26591"></path><path d="M261.437 510.503v-32h503.9v32zM261.44 605.397v-32h503.9v32zM400.527 305.69v-32h364.8v32zM261.391 410.546v-32h503.9v32z" fill="#A3BDD3" p-id="26592"></path><path d="M733.039 824.168v-32h97.9v32z" fill="#8C98A6" p-id="26593"></path><path d="M896.2 958.3H456.7v-176c0-35.3 28.7-64 64-64h375.5c35.3 0 64 28.7 64 64v112c0 35.4-28.7 64-64 64z" fill="#8AA9BF" p-id="26594"></path><path d="M640.6 771v20h-46.8v122.8h-23.4V791h-46.8v-20h117zM676.4 771l33.6 50.4 33.6-50.4h28.6L724 840l51.4 73.8h-28.6L710 858.6l-36.8 55.2h-28.6l51-73.8-47.8-69h28.6zM896.4 771v20h-46.8v122.8h-23.4V791h-46.8v-20h117z" fill="#FFFFFF" p-id="26595"></path></svg>'
}
def get_suffix(name):
    if not '.' in name:
        return ""
    return name.split(".")[-1]

def get_svg(path):
    path_split=path.replace("\\","/").split("/")
    last_name=path_split[-1]
    if not last_name:#应对path后面还加了一个斜杠的情况。
        if len(path_split)<2:
            return svg_by_type["unknown"]
        else:
            last_name=path_split[-2]
    del path_split
    if not os.path.exists("./%s"%path):
        return svg_by_type["unknown"]
    if os.path.isdir("./%s"%path):
        if last_name==".git":
            return svg_by_type["git"]
        return svg_by_type["folder"]
    elif os.path.isfile("./%s"%path):
        if last_name.find(".git")==0:
            return svg_by_type["git"]
        if last_name.find("jquery")==0:
            return svg_by_type["jquery"]
        if last_name.find("bootstrap")==0:
            return svg_by_type["bootstrap"]
        suffix=get_suffix(last_name)
        return svg_by_suffix.get(suffix,svg_by_type["unknown"])
