# coding: utf-8

"""
    perceptic-core-server API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1-SNAPSHOT
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AzureBlobConnectionSettingsApiDto(BaseModel):
    """
    AzureBlobConnectionSettingsApiDto
    """ # noqa: E501
    container: Annotated[str, Field(strict=True)]
    credential_name: Annotated[str, Field(strict=True)] = Field(alias="credentialName")
    credential_key: Annotated[str, Field(strict=True)] = Field(alias="credentialKey")
    url: Annotated[str, Field(strict=True)]
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["container", "credentialName", "credentialKey", "url", "type"]

    @field_validator('container')
    def container_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\S", value):
            raise ValueError(r"must validate the regular expression /\S/")
        return value

    @field_validator('credential_name')
    def credential_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\S", value):
            raise ValueError(r"must validate the regular expression /\S/")
        return value

    @field_validator('credential_key')
    def credential_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\S", value):
            raise ValueError(r"must validate the regular expression /\S/")
        return value

    @field_validator('url')
    def url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\S", value):
            raise ValueError(r"must validate the regular expression /\S/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureBlobConnectionSettingsApiDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureBlobConnectionSettingsApiDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "container": obj.get("container"),
            "credentialName": obj.get("credentialName"),
            "credentialKey": obj.get("credentialKey"),
            "url": obj.get("url"),
            "type": obj.get("type")
        })
        return _obj


