import * as route53 from '@aws-cdk/aws-route53';
/**
 * Use another Route 53 record as an alias record target.
 *
 * @stability stable
 */
export declare class Route53RecordTarget implements route53.IAliasRecordTarget {
    private readonly record;
    /**
     * @stability stable
     */
    constructor(record: route53.IRecordSet);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record: route53.IRecordSet, zone?: route53.IHostedZone): route53.AliasRecordTargetConfig;
}
