/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class ExtractExpression
extends Expression {
    private final Object _datePart;
    private final SqlObject _dateExpression;

    public ExtractExpression(DatePart datePart, Object dateExpression) {
        this((Object)datePart, dateExpression);
    }

    public ExtractExpression(Object datePart, Object dateExpression) {
        this._datePart = datePart;
        this._dateExpression = Converter.toColumnSqlObject(dateExpression);
    }

    public boolean hasParens() {
        return false;
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this._dateExpression.collectSchemaObjects(vContext);
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append("EXTRACT(").append(this._datePart).append(" FROM ").append(this._dateExpression).append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatePart {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        TIMEZONE_HOUR,
        TIMEZONE_MINUTE;

    }
}

