/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Function;
import java.io.IOException;

public class FunctionCall
extends Expression {
    private boolean _isDistinct;
    private SqlObject _functionName;
    private SqlObjectList<SqlObject> _params = SqlObjectList.create();
    private SqlObject _window;

    public FunctionCall(Function function) {
        this((Object)function);
    }

    public FunctionCall(Object functionNameStr) {
        this._functionName = Converter.toCustomFunctionSqlObject(functionNameStr);
    }

    public boolean hasParens() {
        return false;
    }

    public FunctionCall setIsDistinct(boolean isDistinct) {
        this._isDistinct = isDistinct;
        return this;
    }

    public FunctionCall addCustomParams(Object ... params) {
        this._params.addObjects(Converter.COLUMN_VALUE_TO_OBJ, params);
        return this;
    }

    public FunctionCall addColumnParams(Column ... columns) {
        return this.addCustomParams(columns);
    }

    public FunctionCall addNumericValueParam(Object obj) {
        return this.addCustomParams(obj);
    }

    public FunctionCall setWindow(Object window) {
        this._window = Converter.toCustomColumnSqlObject(window);
        return this;
    }

    public FunctionCall setWindowByName(String windowName) {
        this._window = new CustomSql(windowName);
        return this;
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this._functionName.collectSchemaObjects(vContext);
        this._params.collectSchemaObjects(vContext);
        FunctionCall.collectSchemaObjects(this._window, vContext);
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append(this._functionName).append("(");
        if (this._isDistinct) {
            app.append("DISTINCT ");
        }
        app.append(this._params).append(")");
        if (this._window != null) {
            app.append(" OVER ").append(this._window);
        }
    }

    public static FunctionCall avg() {
        return new FunctionCall(new CustomSql("AVG"));
    }

    public static FunctionCall min() {
        return new FunctionCall(new CustomSql("MIN"));
    }

    public static FunctionCall max() {
        return new FunctionCall(new CustomSql("MAX"));
    }

    public static FunctionCall sum() {
        return new FunctionCall(new CustomSql("SUM"));
    }

    public static FunctionCall count() {
        return new FunctionCall(new CustomSql("COUNT"));
    }

    public static FunctionCall countAll() {
        return new FunctionCall(new CustomSql("COUNT")).addCustomParams(ALL_SYMBOL);
    }

    public static FunctionCall rowNumber() {
        return new FunctionCall(new CustomSql("ROW_NUMBER"));
    }

    public static FunctionCall rank() {
        return new FunctionCall(new CustomSql("RANK"));
    }

    public static FunctionCall denseRank() {
        return new FunctionCall(new CustomSql("DENSE_RANK"));
    }
}

