/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms.driver;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.TableStats;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.ListUtils;
import org.linqs.psl.util.Parallel;
import org.linqs.psl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DatabaseDriver
implements DatabaseDriver {
    private static final Logger log = LoggerFactory.getLogger(H2DatabaseDriver.class);
    private final HikariDataSource dataSource;

    public H2DatabaseDriver(Type dbType, String path, boolean clearDB) {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not find H2 driver. Please check classpath", ex);
        }
        log.debug("Connecting to H2 database: " + path);
        String connectionString = null;
        switch (dbType) {
            case Disk: {
                connectionString = "jdbc:h2:" + path;
                break;
            }
            case Memory: {
                connectionString = "jdbc:h2:mem:" + path;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown database type: " + (Object)((Object)dbType));
            }
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(connectionString);
        config.setMaximumPoolSize(Math.max(8, Parallel.getNumThreads() * 2));
        config.setMaxLifetime(0L);
        this.dataSource = new HikariDataSource(config);
        if (clearDB) {
            this.clearDB();
        }
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get connection from pool.", ex);
        }
    }

    private void clearDB() {
        this.executeUpdate("DROP ALL OBJECTS");
    }

    private void executeUpdate(String sql) {
        try (Connection connection = this.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to execute a general update: [" + sql + "].", ex);
        }
    }

    @Override
    public boolean supportsBulkCopy() {
        return false;
    }

    @Override
    public void bulkCopy(String path, String delimiter, boolean hasTruth, PredicateInfo predicateInfo, Partition partition) {
        throw new UnsupportedOperationException("H2 does not support bulk copy.");
    }

    @Override
    public String getTypeName(ConstantType type) {
        switch (type) {
            case Double: {
                return "DOUBLE";
            }
            case Integer: {
                return "INT";
            }
            case String: {
                return "VARCHAR";
            }
            case Long: {
                return "BIGINT";
            }
            case UniqueIntID: {
                return "INT";
            }
            case UniqueStringID: {
                return "VARCHAR(255)";
            }
        }
        throw new IllegalStateException("Unknown ConstantType: " + (Object)((Object)type));
    }

    @Override
    public String getSurrogateKeyColumnDefinition(String columnName) {
        return columnName + " BIGINT IDENTITY PRIMARY KEY";
    }

    @Override
    public String getDoubleTypeName() {
        return "DOUBLE";
    }

    @Override
    public String getUpsert(String tableName, String[] columns, String[] keyColumns) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("MERGE INTO " + tableName + "");
        sql.add("    (" + StringUtils.join(", ", (Object[])columns) + ")");
        sql.add("KEY");
        sql.add("    (" + StringUtils.join(", ", (Object[])keyColumns) + ")");
        sql.add("VALUES");
        sql.add("    (" + StringUtils.repeat("?", ", ", columns.length) + ")");
        return ListUtils.join("\n", sql);
    }

    @Override
    public String finalizeCreateTable(CreateTableQuery createTable) {
        return ((CreateTableQuery)createTable.validate()).toString();
    }

    @Override
    public String getStringAggregate(String columnName, String delimiter, boolean distinct) {
        if (delimiter.contains("'")) {
            throw new IllegalArgumentException("Delimiter (" + delimiter + ") may not contain a single quote.");
        }
        return String.format("GROUP_CONCAT(DISTINCT CAST(%s AS TEXT) SEPARATOR '%s')", columnName, delimiter);
    }

    @Override
    public TableStats getTableStats(PredicateInfo predicate) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("SELECT");
        sql.add("    UPPER(COLUMN_NAME) AS col,");
        sql.add("    (SELECT COUNT(*) FROM " + predicate.tableName() + ") AS tableCount,");
        sql.add("    SELECTIVITY / 100.0 AS selectivity");
        sql.add("FROM INFORMATION_SCHEMA.COLUMNS");
        sql.add("WHERE");
        sql.add("    UPPER(TABLE_NAME) = '" + predicate.tableName().toUpperCase() + "'");
        sql.add("    AND UPPER(COLUMN_NAME) NOT IN ('PARTITION_ID', 'VALUE')");
        TableStats stats = null;
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(ListUtils.join("\n", sql));
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                if (stats == null) {
                    stats = new TableStats(result.getInt(2));
                }
                stats.addColumnSelectivity(result.getString(1), result.getDouble(3));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get stats from table: " + predicate.tableName(), ex);
        }
        return stats;
    }

    @Override
    public void updateDBStats() {
        this.executeUpdate("ANALYZE");
    }

    @Override
    public void updateTableStats(PredicateInfo predicate) {
    }

    public static enum Type {
        Disk,
        Memory;

    }
}

