/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.linqs.psl.model.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model {
    private static final Logger log = LoggerFactory.getLogger(Model.class);
    protected final List<Rule> rules = new LinkedList<Rule>();

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void addRule(Rule rule) {
        if (this.rules.contains(rule)) {
            log.warn("Rule already added to this model, skipping add: " + rule);
            return;
        }
        if (!rule.requiresSplit()) {
            this.rules.add(rule);
            return;
        }
        log.info("Rule is being split into multiple rules: {}", (Object)rule);
        for (Rule splitRule : rule.split()) {
            this.rules.add(splitRule);
        }
    }

    public void removeRule(Rule rule) {
        if (!this.rules.contains(rule)) {
            throw new IllegalArgumentException("Rule (" + rule + ") not in this model.");
        }
        this.rules.remove(rule);
    }

    public void clear() {
        this.rules.clear();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Model:\n");
        s.append(this.asString());
        return s.toString();
    }

    public String asString() {
        StringBuilder s = new StringBuilder();
        if (this.rules.size() > 0) {
            s.append(this.rules.get(0));
        }
        for (int i = 1; i < this.rules.size(); ++i) {
            s.append("\n").append(this.rules.get(i));
        }
        return s.toString();
    }
}

