/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;

public abstract class ADMMObjectiveTerm
implements ReasonerTerm {
    protected final GroundRule groundRule;
    protected final LocalVariable[] variables;
    protected final int size;

    public ADMMObjectiveTerm(Hyperplane<LocalVariable> hyperplane, GroundRule groundRule) {
        this.variables = (LocalVariable[])hyperplane.getVariables();
        this.size = hyperplane.size();
        this.groundRule = groundRule;
    }

    public void updateLagrange(float stepSize, float[] consensusValues) {
        for (int i = 0; i < this.size; ++i) {
            LocalVariable variable = this.variables[i];
            variable.setLagrange(variable.getLagrange() + stepSize * (variable.getValue() - consensusValues[variable.getGlobalId()]));
        }
    }

    public abstract void minimize(float var1, float[] var2);

    public abstract float evaluate();

    public abstract float evaluate(float[] var1);

    public LocalVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public int size() {
        return this.size;
    }

    public GroundRule getGroundRule() {
        return this.groundRule;
    }
}

