/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.linqs.psl.config.Config;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.admm.ADMMReasoner;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.term.MemoryTermStore;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.RandUtils;

public class ADMMTermStore
implements TermStore<ADMMObjectiveTerm, LocalVariable> {
    public static final String CONFIG_PREFIX = "admmmemorytermstore";
    public static final String INTERNAL_STORE_KEY = "admmmemorytermstore.internalstore";
    public static final String INTERNAL_STORE_DEFAULT = MemoryTermStore.class.getName();
    private TermStore<ADMMObjectiveTerm, ?> store;
    private Map<RandomVariableAtom, Integer> variableIndexes;
    private List<List<LocalVariable>> localVariables;
    private int numLocalVariables;

    public ADMMTermStore() {
        this((TermStore)Config.getNewObject(INTERNAL_STORE_KEY, INTERNAL_STORE_DEFAULT));
    }

    public ADMMTermStore(TermStore<ADMMObjectiveTerm, ?> store) {
        this.store = store;
        this.variableIndexes = new HashMap<RandomVariableAtom, Integer>();
        this.localVariables = new ArrayList<List<LocalVariable>>();
        this.numLocalVariables = 0;
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
        if (capacity == 0) {
            return;
        }
        ((ArrayList)this.localVariables).ensureCapacity(capacity);
        if (this.variableIndexes.size() == 0) {
            this.variableIndexes = new HashMap<RandomVariableAtom, Integer>((int)Math.ceil((double)capacity / 0.75));
        }
    }

    @Override
    public synchronized LocalVariable createLocalVariable(RandomVariableAtom atom) {
        int globalId;
        ++this.numLocalVariables;
        if (this.variableIndexes.containsKey(atom)) {
            globalId = this.variableIndexes.get(atom);
        } else {
            globalId = this.variableIndexes.size();
            this.variableIndexes.put(atom, globalId);
            this.localVariables.add(new ArrayList());
        }
        LocalVariable localVariable = new LocalVariable(globalId, atom.getValue());
        this.localVariables.get(globalId).add(localVariable);
        return localVariable;
    }

    public int getNumLocalVariables() {
        return this.numLocalVariables;
    }

    public int getNumGlobalVariables() {
        return this.variableIndexes.size();
    }

    public List<LocalVariable> getLocalVariables(int globalId) {
        return this.localVariables.get(globalId);
    }

    public Map<RandomVariableAtom, Integer> getGlobalVariables() {
        return Collections.unmodifiableMap(this.variableIndexes);
    }

    public void updateVariables(float[] values) {
        for (Map.Entry<RandomVariableAtom, Integer> entry : this.variableIndexes.entrySet()) {
            entry.getKey().setValue(values[entry.getValue()]);
        }
    }

    public void getAtomValues(float[] values) {
        for (Map.Entry<RandomVariableAtom, Integer> entry : this.variableIndexes.entrySet()) {
            values[entry.getValue().intValue()] = entry.getKey().getValue();
        }
    }

    public void resetLocalVairables() {
        this.resetLocalVairables(ADMMReasoner.InitialValue.RANDOM);
    }

    public void resetLocalVairables(ADMMReasoner.InitialValue initialValue) {
        for (Map.Entry<RandomVariableAtom, Integer> entry : this.variableIndexes.entrySet()) {
            for (LocalVariable local : this.localVariables.get(entry.getValue())) {
                if (initialValue == ADMMReasoner.InitialValue.ZERO) {
                    local.setValue(0.0f);
                } else if (initialValue == ADMMReasoner.InitialValue.RANDOM) {
                    local.setValue(RandUtils.nextFloat());
                } else if (initialValue == ADMMReasoner.InitialValue.ATOM) {
                    local.setValue(entry.getKey().getValue());
                } else {
                    throw new IllegalStateException("Unknown initial consensus value: " + (Object)((Object)initialValue));
                }
                local.setLagrange(0.0f);
            }
        }
    }

    @Override
    public void add(GroundRule rule, ADMMObjectiveTerm term) {
        this.store.add(rule, term);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
        if (this.variableIndexes != null) {
            this.variableIndexes.clear();
        }
        if (this.localVariables != null) {
            this.localVariables.clear();
        }
        this.numLocalVariables = 0;
    }

    @Override
    public void close() {
        this.clear();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.variableIndexes = null;
        this.localVariables = null;
    }

    @Override
    public ADMMObjectiveTerm get(int index) {
        return this.store.get(index);
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(int capacity) {
        this.store.ensureCapacity(capacity);
    }

    @Override
    public Iterator<ADMMObjectiveTerm> iterator() {
        return this.store.iterator();
    }

    @Override
    public Iterator<ADMMObjectiveTerm> noWriteIterator() {
        return this.iterator();
    }

    public Iterable<ADMMObjectiveTerm> getTerms(GroundRule groundRule) {
        final GroundRule finalGroundRule = groundRule;
        return IteratorUtils.filter(this.store, new IteratorUtils.FilterFunction<ADMMObjectiveTerm>(){

            @Override
            public boolean keep(ADMMObjectiveTerm term) {
                return finalGroundRule.equals(term.getGroundRule());
            }
        });
    }
}

