/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd;

import java.util.Iterator;
import org.linqs.psl.config.Config;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCDReasoner
implements Reasoner {
    private static final Logger log = LoggerFactory.getLogger(DCDReasoner.class);
    public static final String CONFIG_PREFIX = "dcd";
    public static final String MAX_ITER_KEY = "dcd.maxiterations";
    public static final int MAX_ITER_DEFAULT = 200;
    public static final String OBJECTIVE_BREAK_KEY = "dcd.objectivebreak";
    public static final boolean OBJECTIVE_BREAK_DEFAULT = true;
    public static final String OBJ_TOL_KEY = "dcd.tolerance";
    public static final float OBJ_TOL_DEFAULT = 1.0E-6f;
    public static final String C_KEY = "dcd.C";
    public static final float C_DEFAULT = 10.0f;
    public static final String TRUNCATE_EVERY_STEP_KEY = "dcd.truncateeverystep";
    public static final boolean TRUNCATE_EVERY_STEP_DEFAULT = false;
    public static final String PRINT_OBJECTIVE_KEY = "dcd.printobj";
    public static final boolean PRINT_OBJECTIVE_DEFAULT = true;
    public static final String PRINT_INITIAL_OBJECTIVE_KEY = "dcd.printinitialobj";
    public static final boolean PRINT_INITIAL_OBJECTIVE_DEFAULT = false;
    private int maxIter = Config.getInt("dcd.maxiterations", 200);
    private float tolerance;
    private boolean printObj;
    private boolean printInitialObj;
    private boolean objectiveBreak = Config.getBoolean("dcd.objectivebreak", true);
    private float c;
    private boolean truncateEveryStep;

    public DCDReasoner() {
        this.printObj = Config.getBoolean(PRINT_OBJECTIVE_KEY, true);
        this.printInitialObj = Config.getBoolean(PRINT_INITIAL_OBJECTIVE_KEY, false);
        this.tolerance = Config.getFloat(OBJ_TOL_KEY, 1.0E-6f);
        this.c = Config.getFloat(C_KEY, 10.0f);
        this.truncateEveryStep = Config.getBoolean(TRUNCATE_EVERY_STEP_KEY, false);
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    @Override
    public void optimize(TermStore baseTermStore) {
        if (!(baseTermStore instanceof VariableTermStore)) {
            throw new IllegalArgumentException("DCDReasoner requires an VariableTermStore (found " + baseTermStore.getClass().getName() + ").");
        }
        VariableTermStore termStore = (VariableTermStore)baseTermStore;
        float[] variableValues = termStore.getVariableValues();
        float objective = -1.0f;
        float oldObjective = Float.POSITIVE_INFINITY;
        int iteration = 1;
        if (this.printObj) {
            log.trace("objective:Iterations,Time(ms),Objective");
            if (this.printInitialObj) {
                objective = this.computeObjective(termStore, variableValues);
                log.trace("objective:{},{},{}", 0, 0, Float.valueOf(objective));
            }
        }
        long time = 0L;
        while (!(iteration > this.maxIter || this.objectiveBreak && iteration != 1 && MathUtils.equals(objective, oldObjective, this.tolerance))) {
            long start = System.currentTimeMillis();
            for (DCDObjectiveTerm term : termStore) {
                term.minimize(this.truncateEveryStep, variableValues);
            }
            if (!this.truncateEveryStep) {
                for (RandomVariableAtom variable : termStore.getVariables()) {
                    variable.setValue(Math.max(Math.min(variable.getValue(), 1.0f), 0.0f));
                }
            }
            long end = System.currentTimeMillis();
            oldObjective = objective;
            objective = this.computeObjective(termStore, variableValues);
            time += end - start;
            if (this.printObj) {
                log.trace("objective:{},{},{}", iteration, time, Float.valueOf(objective));
            }
            ++iteration;
        }
        termStore.syncAtoms();
        log.info("Optimization completed in {} iterations. Objective.: {}", (Object)(iteration - 1), (Object)Float.valueOf(objective));
        log.debug("Optimized with {} variables and {} terms.", (Object)termStore.getNumVariables(), (Object)termStore.size());
    }

    private float computeObjective(VariableTermStore<DCDObjectiveTerm, RandomVariableAtom> termStore, float[] variableValues) {
        float objective = 0.0f;
        int termCount = 0;
        Iterator termIterator = null;
        termIterator = termStore.isLoaded() ? termStore.noWriteIterator() : termStore.iterator();
        for (DCDObjectiveTerm term : IteratorUtils.newIterable(termIterator)) {
            objective += term.evaluate(variableValues) / this.c;
            ++termCount;
        }
        return objective / (float)termCount;
    }

    @Override
    public void close() {
    }
}

