/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.sgd.term;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.sgd.term.SGDObjectiveTerm;
import org.linqs.psl.reasoner.sgd.term.SGDStreamingTermStore;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.streaming.StreamingInitialRoundIterator;
import org.linqs.psl.util.RuntimeStats;

public class SGDStreamingInitialRoundIterator
extends StreamingInitialRoundIterator<SGDObjectiveTerm> {
    public SGDStreamingInitialRoundIterator(SGDStreamingTermStore parentStore, List<WeightedRule> rules, AtomManager atomManager, HyperplaneTermGenerator<SGDObjectiveTerm, RandomVariableAtom> termGenerator, List<SGDObjectiveTerm> termCache, List<SGDObjectiveTerm> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize) {
        super(parentStore, rules, atomManager, termGenerator, termCache, termPool, termBuffer, volatileBuffer, pageSize);
    }

    @Override
    protected void writeFullPage(String termPagePath, String volatilePagePath) {
        this.flushTermCache(termPagePath);
        this.termCache.clear();
        if (this.volatileBuffer == null) {
            this.volatileBuffer = ByteBuffer.allocate(0);
        }
    }

    private void flushTermCache(String termPagePath) {
        int termsSize = 0;
        for (Object term : this.termCache) {
            termsSize += ((SGDObjectiveTerm)term).fixedByteSize();
        }
        int termBufferSize = termsSize + 8;
        if (this.termBuffer == null || this.termBuffer.capacity() < termBufferSize) {
            this.termBuffer = ByteBuffer.allocate((int)((double)termBufferSize * 1.25));
        }
        this.termBuffer.clear();
        this.termBuffer.putInt(termsSize);
        this.termBuffer.putInt(this.termCache.size());
        for (SGDObjectiveTerm term : this.termCache) {
            term.writeFixedValues(this.termBuffer);
        }
        try (FileOutputStream stream = new FileOutputStream(termPagePath);){
            stream.write(this.termBuffer.array(), 0, termBufferSize);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write term cache page: " + termPagePath, ex);
        }
        RuntimeStats.logDiskWrite(termBufferSize);
    }
}

