/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.linqs.psl.config.Config;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.term.MemoryTermStore;
import org.linqs.psl.reasoner.term.ReasonerLocalVariable;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.util.RandUtils;

public abstract class MemoryVariableTermStore<T extends ReasonerTerm, V extends ReasonerLocalVariable>
implements VariableTermStore<T, V> {
    public static final String CONFIG_PREFIX = "memoryvariabletermstore";
    public static final String SHUFFLE_KEY = "memoryvariabletermstore.shuffle";
    public static final boolean SHUFFLE_DEFAULT = true;
    public static final String DEFAULT_SIZE_KEY = "memoryvariabletermstore.defaultsize";
    public static final int DEFAULT_SIZE_DEFAULT = 1000;
    private MemoryTermStore<T> store;
    private Map<V, Integer> variables;
    private float[] variableValues;
    private RandomVariableAtom[] variableAtoms;
    private boolean shuffle = Config.getBoolean("memoryvariabletermstore.shuffle", true);
    private int defaultSize = Config.getInt("memoryvariabletermstore.defaultsize", 1000);

    public MemoryVariableTermStore() {
        this.store = new MemoryTermStore();
        this.ensureVariableCapacity(this.defaultSize);
    }

    @Override
    public int getVariableIndex(V variable) {
        return this.variables.get(variable);
    }

    @Override
    public float[] getVariableValues() {
        return this.variableValues;
    }

    @Override
    public void syncAtoms() {
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variableAtoms[i].setValue(this.variableValues[i]);
        }
    }

    @Override
    public int getNumVariables() {
        return this.variables.size();
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public synchronized V createLocalVariable(RandomVariableAtom atom) {
        V variable = this.convertAtomToVariable(atom);
        if (this.variables.containsKey(variable)) {
            return variable;
        }
        if (this.variables.size() >= this.variableAtoms.length) {
            this.ensureVariableCapacity(this.variables.size() * 2);
        }
        int index = this.variables.size();
        this.variables.put((Integer)variable, index);
        this.variableValues[index] = RandUtils.nextFloat();
        this.variableAtoms[index] = atom;
        return variable;
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Variable capacity must be non-negative. Got: " + capacity);
        }
        if (this.variables == null || this.variables.size() == 0) {
            this.variables = new HashMap<V, Integer>((int)Math.ceil((double)capacity / 0.75));
            this.variableValues = new float[capacity];
            this.variableAtoms = new RandomVariableAtom[capacity];
        } else if (this.variables.size() < capacity) {
            if (capacity < this.variables.size() * 2) {
                capacity = this.variables.size() * 2;
            }
            HashMap<Integer, Integer> newVariables = new HashMap<Integer, Integer>((int)Math.ceil((double)capacity / 0.75));
            newVariables.putAll(this.variables);
            this.variables = newVariables;
            this.variableValues = Arrays.copyOf(this.variableValues, capacity);
            this.variableAtoms = Arrays.copyOf(this.variableAtoms, capacity);
        }
    }

    @Override
    public Iterable<V> getVariables() {
        return this.variables.keySet();
    }

    @Override
    public void add(GroundRule rule, T term) {
        this.store.add(rule, term);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
        if (this.variables != null) {
            this.variables.clear();
        }
    }

    @Override
    public void close() {
        this.clear();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.variables = null;
    }

    @Override
    public T get(int index) {
        return this.store.get(index);
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(int capacity) {
        this.store.ensureCapacity(capacity);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.shuffle) {
            this.store.shuffle();
        }
        return this.store.iterator();
    }

    @Override
    public Iterator<T> noWriteIterator() {
        return this.iterator();
    }

    protected abstract V convertAtomToVariable(RandomVariableAtom var1);
}

