/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTermStore;
import org.linqs.psl.util.RandUtils;

public abstract class StreamingCacheIterator<T extends ReasonerTerm>
implements StreamingIterator<T> {
    protected StreamingTermStore<T> parentStore;
    protected int[] shuffleMap;
    protected boolean readonly;
    protected List<T> termCache;
    protected List<T> termPool;
    protected ByteBuffer termBuffer;
    protected ByteBuffer volatileBuffer;
    protected int currentPage;
    protected int nextCachedTermIndex;
    protected T nextTerm;
    protected boolean shufflePage;
    protected List<Integer> pageAccessOrder;
    protected boolean closed;
    protected int numPages;

    public StreamingCacheIterator(StreamingTermStore<T> parentStore, boolean readonly, List<T> termCache, List<T> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, boolean shufflePage, int[] shuffleMap, boolean randomizePageAccess, int numPages) {
        this.parentStore = parentStore;
        this.shuffleMap = shuffleMap;
        this.readonly = readonly;
        this.termCache = termCache;
        this.termCache.clear();
        this.termPool = termPool;
        this.termBuffer = termBuffer;
        this.volatileBuffer = volatileBuffer;
        this.nextCachedTermIndex = 0;
        this.currentPage = -1;
        this.numPages = numPages;
        this.shufflePage = shufflePage;
        this.pageAccessOrder = new ArrayList<Integer>(numPages);
        for (int i = 0; i < numPages; ++i) {
            this.pageAccessOrder.add(i);
        }
        if (randomizePageAccess) {
            RandUtils.shuffle(this.pageAccessOrder);
        }
        this.closed = false;
        this.nextTerm = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTerm != null) {
            throw new IllegalStateException("hasNext() was called twice in a row. Call next() directly after hasNext() == true.");
        }
        if (this.closed) {
            return false;
        }
        this.nextTerm = this.fetchNextTerm();
        if (this.nextTerm == null) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.nextTerm == null) {
            throw new IllegalStateException("Called next() when hasNext() == false (or before the first hasNext() call).");
        }
        T term = this.nextTerm;
        this.nextTerm = null;
        return term;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private T fetchNextTerm() {
        if (this.nextCachedTermIndex >= this.termCache.size()) {
            this.flushCache();
            if (!this.fetchPage()) {
                return null;
            }
        }
        ReasonerTerm term = (ReasonerTerm)this.termCache.get(this.nextCachedTermIndex);
        ++this.nextCachedTermIndex;
        return (T)term;
    }

    private boolean fetchPage() {
        this.termCache.clear();
        ++this.currentPage;
        this.nextCachedTermIndex = 0;
        if (this.currentPage >= this.numPages) {
            return false;
        }
        int pageIndex = this.pageAccessOrder.get(this.currentPage);
        String termPagePath = this.parentStore.getTermPagePath(pageIndex);
        String volatilePagePath = this.parentStore.getVolatilePagePath(pageIndex);
        this.termBuffer.clear();
        this.volatileBuffer.clear();
        this.readPage(termPagePath, volatilePagePath);
        if (this.shufflePage) {
            for (int i = 0; i < this.termCache.size(); ++i) {
                this.shuffleMap[i] = i;
            }
            RandUtils.pairedShuffleIndexes(this.termCache, this.shuffleMap);
        }
        return true;
    }

    private void flushCache() {
        if (this.readonly) {
            return;
        }
        if (this.termCache.size() == 0) {
            return;
        }
        this.flushVolatileCache();
    }

    private void flushVolatileCache() {
        this.volatileBuffer.clear();
        int pageIndex = this.pageAccessOrder.get(this.currentPage);
        String volatilePagePath = this.parentStore.getVolatilePagePath(pageIndex);
        this.writeVolatilePage(volatilePagePath);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flushCache();
        this.parentStore.cacheIterationComplete();
    }

    protected abstract void readPage(String var1, String var2);

    protected abstract void writeVolatilePage(String var1);
}

