/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.linqs.psl.config.Config;

public final class Reflection {
    private Reflection() {
    }

    public static String resolveClassName(String name) {
        try {
            Class.forName(name);
            return name;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String longName = null;
            for (String knownClass : Config.getList("classlist.classes", true)) {
                if (!knownClass.endsWith("." + name)) continue;
                if (longName != null) {
                    throw new IllegalArgumentException(String.format("Ambiguous short class name supplied: '%s'. Matched: [%s, %s].", name, longName, knownClass));
                }
                longName = knownClass;
            }
            return longName;
        }
    }

    public static Object newObject(String name) {
        String className = Reflection.resolveClassName(name);
        if (className == null) {
            throw new IllegalArgumentException("Could not find class: " + name);
        }
        Class<?> classObject = null;
        try {
            classObject = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class: " + className, ex);
        }
        return Reflection.newObject(classObject);
    }

    public static Object newObject(Class<?> classObject) {
        Constructor<?> constructor = null;
        try {
            constructor = classObject.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex2) {
            throw new IllegalArgumentException("Could not find a default constructor for " + classObject.getName());
        }
        Object rtn = null;
        try {
            rtn = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate object (" + classObject.getName() + ")", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Insufficient access to constructor for " + classObject.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error thrown while constructing " + classObject.getName(), ex);
        }
        return rtn;
    }
}

