# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppliancePrefixesDelegatedStaticsArgs', 'AppliancePrefixesDelegatedStatics']

@pulumi.input_type
class AppliancePrefixesDelegatedStaticsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs']] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 static_delegated_prefix_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppliancePrefixesDelegatedStatics resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] description: Identifying description for the prefix.
        :param pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs'] origin: WAN1/WAN2/Independent prefix.
        :param pulumi.Input[builtins.str] prefix: IPv6 prefix/prefix length.
        :param pulumi.Input[builtins.str] static_delegated_prefix_id: Static delegated prefix id.
        """
        pulumi.set(__self__, "network_id", network_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if static_delegated_prefix_id is not None:
            pulumi.set(__self__, "static_delegated_prefix_id", static_delegated_prefix_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifying description for the prefix.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs']]:
        """
        WAN1/WAN2/Independent prefix.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs']]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 prefix/prefix length.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="staticDelegatedPrefixId")
    def static_delegated_prefix_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Static delegated prefix id.
        """
        return pulumi.get(self, "static_delegated_prefix_id")

    @static_delegated_prefix_id.setter
    def static_delegated_prefix_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "static_delegated_prefix_id", value)


@pulumi.input_type
class _AppliancePrefixesDelegatedStaticsState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs']] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 static_delegated_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppliancePrefixesDelegatedStatics resources.
        :param pulumi.Input[builtins.str] created_at: Prefix creation time.
        :param pulumi.Input[builtins.str] description: Identifying description for the prefix.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs'] origin: WAN1/WAN2/Independent prefix.
        :param pulumi.Input[builtins.str] prefix: IPv6 prefix/prefix length.
        :param pulumi.Input[builtins.str] static_delegated_prefix_id: Static delegated prefix id.
        :param pulumi.Input[builtins.str] updated_at: Prefix Updated time.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if static_delegated_prefix_id is not None:
            pulumi.set(__self__, "static_delegated_prefix_id", static_delegated_prefix_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefix creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifying description for the prefix.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs']]:
        """
        WAN1/WAN2/Independent prefix.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input['AppliancePrefixesDelegatedStaticsOriginArgs']]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 prefix/prefix length.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="staticDelegatedPrefixId")
    def static_delegated_prefix_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Static delegated prefix id.
        """
        return pulumi.get(self, "static_delegated_prefix_id")

    @static_delegated_prefix_id.setter
    def static_delegated_prefix_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "static_delegated_prefix_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefix Updated time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("meraki:networks/appliancePrefixesDelegatedStatics:AppliancePrefixesDelegatedStatics")
class AppliancePrefixesDelegatedStatics(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[Union['AppliancePrefixesDelegatedStaticsOriginArgs', 'AppliancePrefixesDelegatedStaticsOriginArgsDict']]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 static_delegated_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.AppliancePrefixesDelegatedStatics("example",
            description="Prefix on WAN 1 of Long Island Office network",
            network_id="string",
            origin={
                "interfaces": ["wan1"],
                "type": "internet",
            },
            prefix="2001:db8:3c4d:15::/64")
        pulumi.export("merakiNetworksAppliancePrefixesDelegatedStaticsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/appliancePrefixesDelegatedStatics:AppliancePrefixesDelegatedStatics example "network_id,static_delegated_prefix_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Identifying description for the prefix.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['AppliancePrefixesDelegatedStaticsOriginArgs', 'AppliancePrefixesDelegatedStaticsOriginArgsDict']] origin: WAN1/WAN2/Independent prefix.
        :param pulumi.Input[builtins.str] prefix: IPv6 prefix/prefix length.
        :param pulumi.Input[builtins.str] static_delegated_prefix_id: Static delegated prefix id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppliancePrefixesDelegatedStaticsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.AppliancePrefixesDelegatedStatics("example",
            description="Prefix on WAN 1 of Long Island Office network",
            network_id="string",
            origin={
                "interfaces": ["wan1"],
                "type": "internet",
            },
            prefix="2001:db8:3c4d:15::/64")
        pulumi.export("merakiNetworksAppliancePrefixesDelegatedStaticsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/appliancePrefixesDelegatedStatics:AppliancePrefixesDelegatedStatics example "network_id,static_delegated_prefix_id"
        ```

        :param str resource_name: The name of the resource.
        :param AppliancePrefixesDelegatedStaticsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppliancePrefixesDelegatedStaticsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[Union['AppliancePrefixesDelegatedStaticsOriginArgs', 'AppliancePrefixesDelegatedStaticsOriginArgsDict']]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 static_delegated_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppliancePrefixesDelegatedStaticsArgs.__new__(AppliancePrefixesDelegatedStaticsArgs)

            __props__.__dict__["description"] = description
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["origin"] = origin
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["static_delegated_prefix_id"] = static_delegated_prefix_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(AppliancePrefixesDelegatedStatics, __self__).__init__(
            'meraki:networks/appliancePrefixesDelegatedStatics:AppliancePrefixesDelegatedStatics',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            origin: Optional[pulumi.Input[Union['AppliancePrefixesDelegatedStaticsOriginArgs', 'AppliancePrefixesDelegatedStaticsOriginArgsDict']]] = None,
            prefix: Optional[pulumi.Input[builtins.str]] = None,
            static_delegated_prefix_id: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'AppliancePrefixesDelegatedStatics':
        """
        Get an existing AppliancePrefixesDelegatedStatics resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Prefix creation time.
        :param pulumi.Input[builtins.str] description: Identifying description for the prefix.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['AppliancePrefixesDelegatedStaticsOriginArgs', 'AppliancePrefixesDelegatedStaticsOriginArgsDict']] origin: WAN1/WAN2/Independent prefix.
        :param pulumi.Input[builtins.str] prefix: IPv6 prefix/prefix length.
        :param pulumi.Input[builtins.str] static_delegated_prefix_id: Static delegated prefix id.
        :param pulumi.Input[builtins.str] updated_at: Prefix Updated time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppliancePrefixesDelegatedStaticsState.__new__(_AppliancePrefixesDelegatedStaticsState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["origin"] = origin
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["static_delegated_prefix_id"] = static_delegated_prefix_id
        __props__.__dict__["updated_at"] = updated_at
        return AppliancePrefixesDelegatedStatics(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Prefix creation time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Identifying description for the prefix.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output['outputs.AppliancePrefixesDelegatedStaticsOrigin']:
        """
        WAN1/WAN2/Independent prefix.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[builtins.str]:
        """
        IPv6 prefix/prefix length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="staticDelegatedPrefixId")
    def static_delegated_prefix_id(self) -> pulumi.Output[builtins.str]:
        """
        Static delegated prefix id.
        """
        return pulumi.get(self, "static_delegated_prefix_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Prefix Updated time.
        """
        return pulumi.get(self, "updated_at")

