# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraQualityRetentionProfilesArgs', 'CameraQualityRetentionProfiles']

@pulumi.input_type
class CameraQualityRetentionProfilesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 audio_recording_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_archive_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 motion_based_retention_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 motion_detector_version: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 quality_retention_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_bandwidth_mode_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 video_settings: Optional[pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs']] = None):
        """
        The set of arguments for constructing a CameraQualityRetentionProfiles resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.bool] audio_recording_enabled: Whether or not to record audio. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.bool] cloud_archive_enabled: Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.int] max_retention_days: The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        :param pulumi.Input[builtins.bool] motion_based_retention_enabled: Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.int] motion_detector_version: The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] quality_retention_profile_id: qualityRetentionProfileId path parameter. Quality retention profile ID
        :param pulumi.Input[builtins.bool] restricted_bandwidth_mode_enabled: Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.str] schedule_id: Schedule for which this camera will record video, or 'null' to always record.
        :param pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs'] video_settings: Video quality and resolution settings for all the camera models.
        """
        pulumi.set(__self__, "network_id", network_id)
        if audio_recording_enabled is not None:
            pulumi.set(__self__, "audio_recording_enabled", audio_recording_enabled)
        if cloud_archive_enabled is not None:
            pulumi.set(__self__, "cloud_archive_enabled", cloud_archive_enabled)
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)
        if motion_based_retention_enabled is not None:
            pulumi.set(__self__, "motion_based_retention_enabled", motion_based_retention_enabled)
        if motion_detector_version is not None:
            pulumi.set(__self__, "motion_detector_version", motion_detector_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quality_retention_profile_id is not None:
            pulumi.set(__self__, "quality_retention_profile_id", quality_retention_profile_id)
        if restricted_bandwidth_mode_enabled is not None:
            pulumi.set(__self__, "restricted_bandwidth_mode_enabled", restricted_bandwidth_mode_enabled)
        if schedule_id is not None:
            pulumi.set(__self__, "schedule_id", schedule_id)
        if video_settings is not None:
            pulumi.set(__self__, "video_settings", video_settings)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="audioRecordingEnabled")
    def audio_recording_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to record audio. Can be either true or false. Defaults to false.
        """
        return pulumi.get(self, "audio_recording_enabled")

    @audio_recording_enabled.setter
    def audio_recording_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "audio_recording_enabled", value)

    @property
    @pulumi.getter(name="cloudArchiveEnabled")
    def cloud_archive_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        """
        return pulumi.get(self, "cloud_archive_enabled")

    @cloud_archive_enabled.setter
    def cloud_archive_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cloud_archive_enabled", value)

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_retention_days", value)

    @property
    @pulumi.getter(name="motionBasedRetentionEnabled")
    def motion_based_retention_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        """
        return pulumi.get(self, "motion_based_retention_enabled")

    @motion_based_retention_enabled.setter
    def motion_based_retention_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "motion_based_retention_enabled", value)

    @property
    @pulumi.getter(name="motionDetectorVersion")
    def motion_detector_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        """
        return pulumi.get(self, "motion_detector_version")

    @motion_detector_version.setter
    def motion_detector_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "motion_detector_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new profile. Must be unique. This parameter is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="qualityRetentionProfileId")
    def quality_retention_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        qualityRetentionProfileId path parameter. Quality retention profile ID
        """
        return pulumi.get(self, "quality_retention_profile_id")

    @quality_retention_profile_id.setter
    def quality_retention_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quality_retention_profile_id", value)

    @property
    @pulumi.getter(name="restrictedBandwidthModeEnabled")
    def restricted_bandwidth_mode_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        """
        return pulumi.get(self, "restricted_bandwidth_mode_enabled")

    @restricted_bandwidth_mode_enabled.setter
    def restricted_bandwidth_mode_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restricted_bandwidth_mode_enabled", value)

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Schedule for which this camera will record video, or 'null' to always record.
        """
        return pulumi.get(self, "schedule_id")

    @schedule_id.setter
    def schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_id", value)

    @property
    @pulumi.getter(name="videoSettings")
    def video_settings(self) -> Optional[pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs']]:
        """
        Video quality and resolution settings for all the camera models.
        """
        return pulumi.get(self, "video_settings")

    @video_settings.setter
    def video_settings(self, value: Optional[pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs']]):
        pulumi.set(self, "video_settings", value)


@pulumi.input_type
class _CameraQualityRetentionProfilesState:
    def __init__(__self__, *,
                 audio_recording_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_archive_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 motion_based_retention_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 motion_detector_version: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 quality_retention_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_bandwidth_mode_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 video_settings: Optional[pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering CameraQualityRetentionProfiles resources.
        :param pulumi.Input[builtins.bool] audio_recording_enabled: Whether or not to record audio. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.bool] cloud_archive_enabled: Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.int] max_retention_days: The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        :param pulumi.Input[builtins.bool] motion_based_retention_enabled: Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.int] motion_detector_version: The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] quality_retention_profile_id: qualityRetentionProfileId path parameter. Quality retention profile ID
        :param pulumi.Input[builtins.bool] restricted_bandwidth_mode_enabled: Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.str] schedule_id: Schedule for which this camera will record video, or 'null' to always record.
        :param pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs'] video_settings: Video quality and resolution settings for all the camera models.
        """
        if audio_recording_enabled is not None:
            pulumi.set(__self__, "audio_recording_enabled", audio_recording_enabled)
        if cloud_archive_enabled is not None:
            pulumi.set(__self__, "cloud_archive_enabled", cloud_archive_enabled)
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)
        if motion_based_retention_enabled is not None:
            pulumi.set(__self__, "motion_based_retention_enabled", motion_based_retention_enabled)
        if motion_detector_version is not None:
            pulumi.set(__self__, "motion_detector_version", motion_detector_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if quality_retention_profile_id is not None:
            pulumi.set(__self__, "quality_retention_profile_id", quality_retention_profile_id)
        if restricted_bandwidth_mode_enabled is not None:
            pulumi.set(__self__, "restricted_bandwidth_mode_enabled", restricted_bandwidth_mode_enabled)
        if schedule_id is not None:
            pulumi.set(__self__, "schedule_id", schedule_id)
        if video_settings is not None:
            pulumi.set(__self__, "video_settings", video_settings)

    @property
    @pulumi.getter(name="audioRecordingEnabled")
    def audio_recording_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to record audio. Can be either true or false. Defaults to false.
        """
        return pulumi.get(self, "audio_recording_enabled")

    @audio_recording_enabled.setter
    def audio_recording_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "audio_recording_enabled", value)

    @property
    @pulumi.getter(name="cloudArchiveEnabled")
    def cloud_archive_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        """
        return pulumi.get(self, "cloud_archive_enabled")

    @cloud_archive_enabled.setter
    def cloud_archive_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cloud_archive_enabled", value)

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_retention_days", value)

    @property
    @pulumi.getter(name="motionBasedRetentionEnabled")
    def motion_based_retention_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        """
        return pulumi.get(self, "motion_based_retention_enabled")

    @motion_based_retention_enabled.setter
    def motion_based_retention_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "motion_based_retention_enabled", value)

    @property
    @pulumi.getter(name="motionDetectorVersion")
    def motion_detector_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        """
        return pulumi.get(self, "motion_detector_version")

    @motion_detector_version.setter
    def motion_detector_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "motion_detector_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new profile. Must be unique. This parameter is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="qualityRetentionProfileId")
    def quality_retention_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        qualityRetentionProfileId path parameter. Quality retention profile ID
        """
        return pulumi.get(self, "quality_retention_profile_id")

    @quality_retention_profile_id.setter
    def quality_retention_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quality_retention_profile_id", value)

    @property
    @pulumi.getter(name="restrictedBandwidthModeEnabled")
    def restricted_bandwidth_mode_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        """
        return pulumi.get(self, "restricted_bandwidth_mode_enabled")

    @restricted_bandwidth_mode_enabled.setter
    def restricted_bandwidth_mode_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restricted_bandwidth_mode_enabled", value)

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Schedule for which this camera will record video, or 'null' to always record.
        """
        return pulumi.get(self, "schedule_id")

    @schedule_id.setter
    def schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_id", value)

    @property
    @pulumi.getter(name="videoSettings")
    def video_settings(self) -> Optional[pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs']]:
        """
        Video quality and resolution settings for all the camera models.
        """
        return pulumi.get(self, "video_settings")

    @video_settings.setter
    def video_settings(self, value: Optional[pulumi.Input['CameraQualityRetentionProfilesVideoSettingsArgs']]):
        pulumi.set(self, "video_settings", value)


@pulumi.type_token("meraki:networks/cameraQualityRetentionProfiles:CameraQualityRetentionProfiles")
class CameraQualityRetentionProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_recording_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_archive_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 motion_based_retention_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 motion_detector_version: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 quality_retention_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_bandwidth_mode_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 video_settings: Optional[pulumi.Input[Union['CameraQualityRetentionProfilesVideoSettingsArgs', 'CameraQualityRetentionProfilesVideoSettingsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.CameraQualityRetentionProfiles("example",
            name="Sample quality retention profile",
            network_id="string")
        pulumi.export("merakiNetworksCameraQualityRetentionProfilesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/cameraQualityRetentionProfiles:CameraQualityRetentionProfiles example "network_id,quality_retention_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] audio_recording_enabled: Whether or not to record audio. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.bool] cloud_archive_enabled: Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.int] max_retention_days: The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        :param pulumi.Input[builtins.bool] motion_based_retention_enabled: Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.int] motion_detector_version: The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] quality_retention_profile_id: qualityRetentionProfileId path parameter. Quality retention profile ID
        :param pulumi.Input[builtins.bool] restricted_bandwidth_mode_enabled: Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.str] schedule_id: Schedule for which this camera will record video, or 'null' to always record.
        :param pulumi.Input[Union['CameraQualityRetentionProfilesVideoSettingsArgs', 'CameraQualityRetentionProfilesVideoSettingsArgsDict']] video_settings: Video quality and resolution settings for all the camera models.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraQualityRetentionProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.CameraQualityRetentionProfiles("example",
            name="Sample quality retention profile",
            network_id="string")
        pulumi.export("merakiNetworksCameraQualityRetentionProfilesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/cameraQualityRetentionProfiles:CameraQualityRetentionProfiles example "network_id,quality_retention_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param CameraQualityRetentionProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraQualityRetentionProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_recording_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cloud_archive_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 motion_based_retention_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 motion_detector_version: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 quality_retention_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 restricted_bandwidth_mode_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 video_settings: Optional[pulumi.Input[Union['CameraQualityRetentionProfilesVideoSettingsArgs', 'CameraQualityRetentionProfilesVideoSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraQualityRetentionProfilesArgs.__new__(CameraQualityRetentionProfilesArgs)

            __props__.__dict__["audio_recording_enabled"] = audio_recording_enabled
            __props__.__dict__["cloud_archive_enabled"] = cloud_archive_enabled
            __props__.__dict__["max_retention_days"] = max_retention_days
            __props__.__dict__["motion_based_retention_enabled"] = motion_based_retention_enabled
            __props__.__dict__["motion_detector_version"] = motion_detector_version
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["quality_retention_profile_id"] = quality_retention_profile_id
            __props__.__dict__["restricted_bandwidth_mode_enabled"] = restricted_bandwidth_mode_enabled
            __props__.__dict__["schedule_id"] = schedule_id
            __props__.__dict__["video_settings"] = video_settings
        super(CameraQualityRetentionProfiles, __self__).__init__(
            'meraki:networks/cameraQualityRetentionProfiles:CameraQualityRetentionProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audio_recording_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            cloud_archive_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            max_retention_days: Optional[pulumi.Input[builtins.int]] = None,
            motion_based_retention_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            motion_detector_version: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            quality_retention_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            restricted_bandwidth_mode_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            schedule_id: Optional[pulumi.Input[builtins.str]] = None,
            video_settings: Optional[pulumi.Input[Union['CameraQualityRetentionProfilesVideoSettingsArgs', 'CameraQualityRetentionProfilesVideoSettingsArgsDict']]] = None) -> 'CameraQualityRetentionProfiles':
        """
        Get an existing CameraQualityRetentionProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] audio_recording_enabled: Whether or not to record audio. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.bool] cloud_archive_enabled: Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        :param pulumi.Input[builtins.int] max_retention_days: The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        :param pulumi.Input[builtins.bool] motion_based_retention_enabled: Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.int] motion_detector_version: The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This parameter is required.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] quality_retention_profile_id: qualityRetentionProfileId path parameter. Quality retention profile ID
        :param pulumi.Input[builtins.bool] restricted_bandwidth_mode_enabled: Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        :param pulumi.Input[builtins.str] schedule_id: Schedule for which this camera will record video, or 'null' to always record.
        :param pulumi.Input[Union['CameraQualityRetentionProfilesVideoSettingsArgs', 'CameraQualityRetentionProfilesVideoSettingsArgsDict']] video_settings: Video quality and resolution settings for all the camera models.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraQualityRetentionProfilesState.__new__(_CameraQualityRetentionProfilesState)

        __props__.__dict__["audio_recording_enabled"] = audio_recording_enabled
        __props__.__dict__["cloud_archive_enabled"] = cloud_archive_enabled
        __props__.__dict__["max_retention_days"] = max_retention_days
        __props__.__dict__["motion_based_retention_enabled"] = motion_based_retention_enabled
        __props__.__dict__["motion_detector_version"] = motion_detector_version
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["quality_retention_profile_id"] = quality_retention_profile_id
        __props__.__dict__["restricted_bandwidth_mode_enabled"] = restricted_bandwidth_mode_enabled
        __props__.__dict__["schedule_id"] = schedule_id
        __props__.__dict__["video_settings"] = video_settings
        return CameraQualityRetentionProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="audioRecordingEnabled")
    def audio_recording_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not to record audio. Can be either true or false. Defaults to false.
        """
        return pulumi.get(self, "audio_recording_enabled")

    @property
    @pulumi.getter(name="cloudArchiveEnabled")
    def cloud_archive_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Create redundant video backup using Cloud Archive. Can be either true or false. Defaults to false.
        """
        return pulumi.get(self, "cloud_archive_enabled")

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of days for which the data will be stored, or 'null' to keep data until storage space runs out. If the former, it can be one of [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 30, 60, 90] days.
        """
        return pulumi.get(self, "max_retention_days")

    @property
    @pulumi.getter(name="motionBasedRetentionEnabled")
    def motion_based_retention_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Deletes footage older than 3 days in which no motion was detected. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        """
        return pulumi.get(self, "motion_based_retention_enabled")

    @property
    @pulumi.getter(name="motionDetectorVersion")
    def motion_detector_version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the motion detector that will be used by the camera. Only applies to Gen 2 cameras. Defaults to v2.
        """
        return pulumi.get(self, "motion_detector_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the new profile. Must be unique. This parameter is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="qualityRetentionProfileId")
    def quality_retention_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        qualityRetentionProfileId path parameter. Quality retention profile ID
        """
        return pulumi.get(self, "quality_retention_profile_id")

    @property
    @pulumi.getter(name="restrictedBandwidthModeEnabled")
    def restricted_bandwidth_mode_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Disable features that require additional bandwidth such as Motion Recap. Can be either true or false. Defaults to false. This setting does not apply to MV2 cameras.
        """
        return pulumi.get(self, "restricted_bandwidth_mode_enabled")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> pulumi.Output[builtins.str]:
        """
        Schedule for which this camera will record video, or 'null' to always record.
        """
        return pulumi.get(self, "schedule_id")

    @property
    @pulumi.getter(name="videoSettings")
    def video_settings(self) -> pulumi.Output['outputs.CameraQualityRetentionProfilesVideoSettings']:
        """
        Video quality and resolution settings for all the camera models.
        """
        return pulumi.get(self, "video_settings")

