# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchLinkAggregationsArgs', 'SwitchLinkAggregations']

@pulumi.input_type
class SwitchLinkAggregationsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 link_aggregation_id: Optional[pulumi.Input[builtins.str]] = None,
                 switch_ports: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]]] = None,
                 switch_profile_ports: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]]] = None):
        """
        The set of arguments for constructing a SwitchLinkAggregations resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] link_aggregation_id: linkAggregationId path parameter. Link aggregation ID
        :param pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]] switch_ports: Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        :param pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]] switch_profile_ports: Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        pulumi.set(__self__, "network_id", network_id)
        if link_aggregation_id is not None:
            pulumi.set(__self__, "link_aggregation_id", link_aggregation_id)
        if switch_ports is not None:
            pulumi.set(__self__, "switch_ports", switch_ports)
        if switch_profile_ports is not None:
            pulumi.set(__self__, "switch_profile_ports", switch_profile_ports)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="linkAggregationId")
    def link_aggregation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        linkAggregationId path parameter. Link aggregation ID
        """
        return pulumi.get(self, "link_aggregation_id")

    @link_aggregation_id.setter
    def link_aggregation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "link_aggregation_id", value)

    @property
    @pulumi.getter(name="switchPorts")
    def switch_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]]]:
        """
        Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        return pulumi.get(self, "switch_ports")

    @switch_ports.setter
    def switch_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]]]):
        pulumi.set(self, "switch_ports", value)

    @property
    @pulumi.getter(name="switchProfilePorts")
    def switch_profile_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]]]:
        """
        Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        return pulumi.get(self, "switch_profile_ports")

    @switch_profile_ports.setter
    def switch_profile_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]]]):
        pulumi.set(self, "switch_profile_ports", value)


@pulumi.input_type
class _SwitchLinkAggregationsState:
    def __init__(__self__, *,
                 link_aggregation_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 switch_ports: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]]] = None,
                 switch_profile_ports: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwitchLinkAggregations resources.
        :param pulumi.Input[builtins.str] link_aggregation_id: linkAggregationId path parameter. Link aggregation ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]] switch_ports: Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        :param pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]] switch_profile_ports: Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        if link_aggregation_id is not None:
            pulumi.set(__self__, "link_aggregation_id", link_aggregation_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if switch_ports is not None:
            pulumi.set(__self__, "switch_ports", switch_ports)
        if switch_profile_ports is not None:
            pulumi.set(__self__, "switch_profile_ports", switch_profile_ports)

    @property
    @pulumi.getter(name="linkAggregationId")
    def link_aggregation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        linkAggregationId path parameter. Link aggregation ID
        """
        return pulumi.get(self, "link_aggregation_id")

    @link_aggregation_id.setter
    def link_aggregation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "link_aggregation_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="switchPorts")
    def switch_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]]]:
        """
        Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        return pulumi.get(self, "switch_ports")

    @switch_ports.setter
    def switch_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchPortArgs']]]]):
        pulumi.set(self, "switch_ports", value)

    @property
    @pulumi.getter(name="switchProfilePorts")
    def switch_profile_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]]]:
        """
        Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        return pulumi.get(self, "switch_profile_ports")

    @switch_profile_ports.setter
    def switch_profile_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchLinkAggregationsSwitchProfilePortArgs']]]]):
        pulumi.set(self, "switch_profile_ports", value)


@pulumi.type_token("meraki:networks/switchLinkAggregations:SwitchLinkAggregations")
class SwitchLinkAggregations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 link_aggregation_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 switch_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchPortArgs', 'SwitchLinkAggregationsSwitchPortArgsDict']]]]] = None,
                 switch_profile_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchProfilePortArgs', 'SwitchLinkAggregationsSwitchProfilePortArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchLinkAggregations:SwitchLinkAggregations example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] link_aggregation_id: linkAggregationId path parameter. Link aggregation ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchPortArgs', 'SwitchLinkAggregationsSwitchPortArgsDict']]]] switch_ports: Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchProfilePortArgs', 'SwitchLinkAggregationsSwitchProfilePortArgsDict']]]] switch_profile_ports: Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchLinkAggregationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchLinkAggregations:SwitchLinkAggregations example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchLinkAggregationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchLinkAggregationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 link_aggregation_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 switch_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchPortArgs', 'SwitchLinkAggregationsSwitchPortArgsDict']]]]] = None,
                 switch_profile_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchProfilePortArgs', 'SwitchLinkAggregationsSwitchProfilePortArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchLinkAggregationsArgs.__new__(SwitchLinkAggregationsArgs)

            __props__.__dict__["link_aggregation_id"] = link_aggregation_id
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["switch_ports"] = switch_ports
            __props__.__dict__["switch_profile_ports"] = switch_profile_ports
        super(SwitchLinkAggregations, __self__).__init__(
            'meraki:networks/switchLinkAggregations:SwitchLinkAggregations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            link_aggregation_id: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            switch_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchPortArgs', 'SwitchLinkAggregationsSwitchPortArgsDict']]]]] = None,
            switch_profile_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchProfilePortArgs', 'SwitchLinkAggregationsSwitchProfilePortArgsDict']]]]] = None) -> 'SwitchLinkAggregations':
        """
        Get an existing SwitchLinkAggregations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] link_aggregation_id: linkAggregationId path parameter. Link aggregation ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchPortArgs', 'SwitchLinkAggregationsSwitchPortArgsDict']]]] switch_ports: Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchLinkAggregationsSwitchProfilePortArgs', 'SwitchLinkAggregationsSwitchProfilePortArgsDict']]]] switch_profile_ports: Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchLinkAggregationsState.__new__(_SwitchLinkAggregationsState)

        __props__.__dict__["link_aggregation_id"] = link_aggregation_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["switch_ports"] = switch_ports
        __props__.__dict__["switch_profile_ports"] = switch_profile_ports
        return SwitchLinkAggregations(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="linkAggregationId")
    def link_aggregation_id(self) -> pulumi.Output[builtins.str]:
        """
        linkAggregationId path parameter. Link aggregation ID
        """
        return pulumi.get(self, "link_aggregation_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="switchPorts")
    def switch_ports(self) -> pulumi.Output[Sequence['outputs.SwitchLinkAggregationsSwitchPort']]:
        """
        Array of switch or stack ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        return pulumi.get(self, "switch_ports")

    @property
    @pulumi.getter(name="switchProfilePorts")
    def switch_profile_ports(self) -> pulumi.Output[Sequence['outputs.SwitchLinkAggregationsSwitchProfilePort']]:
        """
        Array of switch profile ports for creating aggregation group. Minimum 2 and maximum 8 ports are supported.
        """
        return pulumi.get(self, "switch_profile_ports")

