"use strict";
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const alias_1 = require("../lib/alias");
module.exports = {
    'default alias'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.Key(stack, 'Key');
        new alias_1.EncryptionKeyAlias(stack, 'Alias', { key, alias: 'alias/foo' });
        test.deepEqual(app.synthesizeStack(stack.name).template.Resources.Alias325C5727, {
            Type: 'AWS::KMS::Alias',
            Properties: {
                AliasName: 'alias/foo',
                TargetKeyId: { 'Fn::GetAtt': ['Key961B73FD', 'Arn'] }
            }
        });
        test.done();
    },
    'fails if alias name does\'t start with "alias/"'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.Key(stack, 'MyKey', {
            enableKeyRotation: true,
            enabled: false
        });
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'foo',
            key
        }));
        test.done();
    },
    'fails if alias is "alias/" (and nothing more)'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.Key(stack, 'MyKey', {
            enableKeyRotation: true,
            enabled: false
        });
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/',
            key
        }));
        test.done();
    },
    'fails if alias starts with "alias/AWS"'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.Key(stack, 'MyKey', {
            enableKeyRotation: true,
            enabled: false
        });
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/AWS',
            key
        }));
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/AWSAwesome',
            key
        }));
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/AWS/awesome',
            key
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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