# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/dataStrcuture/01_game_features.ipynb.

# %% auto 0
__all__ = ['GameFeatures']

# %% ../../nbs/dataStrcuture/01_game_features.ipynb 3
import pandas as pd
import datetime
import mongoengine

# %% ../../nbs/dataStrcuture/01_game_features.ipynb 5
class GameFeatures(mongoengine.Document):
    "Store the game-features for a given game identified by its id"

    # Game-id.
    game_id = mongoengine.StringField(db_field="gameId", required=True)
    game_opta_id = mongoengine.IntField(db_field="game_optaId", required=False)

    # Game-date/time.
    game_date = mongoengine.DateTimeField(db_field="gameDate", required=True)
    season_id = mongoengine.IntField(db_field="seasonId", required=True)

    # Competition.
    competition_id = mongoengine.StringField(db_field="competitionId", required=True)

    # Team-ids.
    # Home.
    home_team_id = mongoengine.StringField(db_field="homeTeamId", required=True)
    ht_opta_id = mongoengine.IntField(db_field="homeTeam_optaId", required=False)

    # Away.
    away_team_id = mongoengine.StringField(db_field="awayTeamId", required=True)
    at_opta_id = mongoengine.IntField(db_field="awayTeam_optaId", required=False)

    # Stadium.
    venue_id = mongoengine.StringField(db_field="venueId", required=True)
    city = mongoengine.StringField(db_field="city", required=False)
    country = mongoengine.StringField(db_field="country", required=False)
    field_surface = mongoengine.StringField(db_field="surface", required=True)
    field_length_m = mongoengine.IntField(db_field="field_length_m", required=False)
    field_width_m = mongoengine.IntField(db_field="field_width_m", required=False)
    venue_capacity = mongoengine.IntField(db_field="capacity", required=False)
    venue_latitude = mongoengine.FloatField(db_field="lat", required=False)
    venuelongitude = mongoengine.FloatField(db_field="long", required=False)

    # Condition.
    is_closed_doors = mongoengine.BooleanField(
        db_field="is_behind_closed_doors", required=False
    )

    # Head to head.
    home_dominance = mongoengine.FloatField(
        db_field="homeTeamDominance", min_value=0, max_value=1, required=True
    )
    away_dominance = mongoengine.FloatField(
        db_field="awayTeamDominance", min_value=0, max_value=1, required=True
    )

    # Targets.
    tgt_half_gd = mongoengine.IntField(db_field="tgt_half_gd", required=False)
    tgt_gd = mongoengine.IntField(db_field="tgt_gd", required=False)
    tgt_htg = mongoengine.IntField(db_field="tgt_homeTeamGoals", required=False)
    tgt_atg = mongoengine.IntField(db_field="tgt_awayTeamGoals", required=False)
    tgt_half_htg = mongoengine.IntField(
        db_field="tgt_half_homeTeamGoals", required=False
    )
    tgt_half_atg = mongoengine.IntField(
        db_field="tgt_half_awayTeamGoals", required=False
    )
    tgt_outcome = mongoengine.FloatField(db_field="tgt_outcome", required=False)
    tgt_half_outcome = mongoengine.FloatField(
        db_field="tgt_half_outcome", required=False
    )

    meta = {
        "db_alias": "features",
        "collection": "gameFeatures_test",
    }

    @classmethod
    def get_all_games(
        cls,
        limit: int = None,  # Number of rows.
    ):  # GamesFeatures output.
        "Extract all games."
        return cls.objects().order_by("gameDate").limit(limit)

    @classmethod
    def get_game(
        cls,
        ra_game_id: str,  # Real-analytics game identifier.
    ):  # GamesFeatures output.
        "Extract a single game by its gameId."
        return cls.objects(game_id=ra_game_id).first()
