# AUTOGENERATED! DO NOT EDIT! File to edit: product-sdk.ipynb (unless otherwise specified).

__all__ = ['FunctionNames', 'ProductSdk', 'querySingleProduct', 'ProductsFromList', 'queryList']

# Cell
from botocore.config import Config
from s3bz.s3bz import S3, Requests
from lambdasdk.lambdasdk import Lambda, InvocationType
from .schema import Event, Response
from typing import Optional, List
import json
from nicHelper.wrappers import add_method
from nicHelper.exception import errorString
from awsSchema.apigateway import Event, Response
from dataclasses_json import dataclass_json
from dataclasses import dataclass
import pandas as pd
import bz2,  boto3, base64, logging, requests

# Cell
class FunctionNames:
  '''determine function and resources name based on branchName'''
  def __init__(self, branchName:str = 'dev-manual'):
    self.branchName = branchName
  dumpToS3 = lambda self: f'product-dump-s3-{self.branchName}'
  updateProduct = lambda self: f'product-update-{self.branchName}'
  updateS3 = lambda self: f'product-update-s3-{self.branchName}'
  singleQuery = lambda self: f'product-get-{self.branchName}'
  allQuery = lambda self: f'product-get-all-feather-{self.branchName}'
  inputBucket = lambda self: f'input-product-bucket-{self.branchName}'
  inventoryBucket = lambda self: f'product-bucket-{self.branchName}'
  listQuery = lambda self: f'product-get-list-{self.branchName}'


# Cell
class ProductSdk:
  '''
    the main class for interacting with product endpoint
    user/pw are optional
  '''
  def __init__(self,
               branch:str = 'dev-manual',
               user:Optional[str] = None,
               pw:Optional[str] = None,
               region:str = 'ap-southeast-1'):
    self.branchName = branch
    self.functionNames = FunctionNames(branchName = branch)
    self.lambdaClient = Lambda(user =user, pw=pw, region = region)
    self.user = user; self.pw = pw; self.region = region

  @staticmethod
  def returnLambdaResponse(lambdaResponse:dict):
    try:
      return Response.fromDict(lambdaResponse).body
    except:
      logging.exception(f'error parsing body, perhaps there is no body in response\
      response is {lambdaResponse}')
      logging.error(lambdaResponse)

  @staticmethod
  def printFirst(inputDict:dict):
    return next(iter(inputDict.items()))

  def generalInvoke(self, functionName, payload):
    lambdaResponse = self.lambdaClient.invoke(
      functionName = functionName, input = payload
    )
    try:
      response:Response = Response.fromDict(lambdaResponse)
    except:
      print('unable to parse response')
      print(lambdaResponse)
      raise Exception(errorString())
    if response.statusCode == 200:
      return response.body
    else:
      print('error')
      return response.body
    return self.returnLambdaResponse(lambdaResponse)

  def updateWithS3(self, data,
                   inputKeyName = 'input-data-name',
                   invocationType = InvocationType.event,
                   user= None, pw= None):
    # put users if not specified
    user = user or self.user; pw = pw or self.pw

    # extract function name and inputbucket name
    inputBucketName = self.functionNames.inputBucket()
    functionName = self.functionNames.updateS3()
    logging.info(f'bucket is {inputBucketName}')

    # save data to s3
    S3.save(key = inputKeyName,
            objectToSave = data ,
            bucket = inputBucketName,
            user=user, pw=pw)
    logging.info(f'data is saved to s3, invoking ingestion function')

    # call lambda function
    inputValue = Event(body = json.dumps({ 'key': inputKeyName })).to_dict()
    logging.info(f'input to lambda is {inputValue}')
    lambdaResponse = self.lambdaClient.invoke(
      functionName= functionName ,
      input=inputValue,
      invocationType= invocationType )
    logging.info(f'lambdaResponse is {lambdaResponse}')
    if invocationType == 'Event': return "successfully sent event, please watch your slack"
    if lambdaResponse: return self.returnLambdaResponse(lambdaResponse)


  def allQuery(self):
    functionName = self.functionNames.allQuery()
    lambdaResponse = self.lambdaClient.invoke(
      functionName = functionName, input = {}
    )
    url = Response.fromDict(lambdaResponse).body['url']
#     result = Requests.getContentFromUrl(url)
#     result = requests.get(url)
    result = pd.read_feather(url)

    return result



# Cell
@add_method(ProductSdk)
def querySingleProduct(self, iprcode = '0171670', user=None, pw=None):
  '''query a single product'''
  #extract function name
  functionName = self.functionNames.singleQuery()
  query = {'iprcode': iprcode}
  try:
    inputValue = Event.getInput(query)
    lambdaResponse = self.lambdaClient.invoke( functionName = functionName , input = inputValue )
    return self.returnLambdaResponse(lambdaResponse)
  except:
    print('calling lambda failed')


# Cell
@dataclass_json
@dataclass
class ProductsFromList:
  iprcodes: List[str]

# Cell
@add_method(ProductSdk)
def queryList(self,iprcodes:List[str])->List[dict]:
  return self.generalInvoke(functionName=self.functionNames.listQuery() ,payload=Event.getInput({'iprcodes': iprcodes}))
