"use strict";
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const FILE_TYPES = [
    { label: 'KFP static configuration file (YAML formatted)', key: 'yaml' },
    { label: 'KFP domain-specific language Python code', key: 'py' }
];
class PipelineExportDialog extends React.Component {
    render() {
        const { runtimes } = this.props;
        return (React.createElement("form", null,
            React.createElement("label", { htmlFor: "runtime_config" }, "Runtime Config:"),
            React.createElement("br", null),
            React.createElement("select", { id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config", "data-form-required": true }, runtimes.map((runtime) => (React.createElement("option", { key: runtime.name, value: runtime.name }, runtime.display_name)))),
            React.createElement("label", { htmlFor: "pipeline_filetype" }, "Export Pipeline as:"),
            React.createElement("br", null),
            React.createElement("select", { id: "pipeline_filetype", name: "pipeline_filetype", className: "elyra-form-export-filetype", "data-form-required": true }, FILE_TYPES.map(filetype => (React.createElement("option", { key: filetype['key'], value: filetype['key'] }, filetype['label'])))),
            React.createElement("input", { type: "checkbox", id: "overwrite", name: "overwrite" }),
            React.createElement("label", { htmlFor: "overwrite" }, "Replace if file already exists"),
            React.createElement("br", null)));
    }
}
exports.PipelineExportDialog = PipelineExportDialog;
//# sourceMappingURL=PipelineExportDialog.js.map