"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
require("jest");
const application_1 = require("@jupyterlab/application");
const apputils_1 = require("@jupyterlab/apputils");
const docmanager_1 = require("@jupyterlab/docmanager");
const docregistry_1 = require("@jupyterlab/docregistry");
const filebrowser_1 = require("@jupyterlab/filebrowser");
const services_1 = require("@jupyterlab/services");
const commands_1 = require("@lumino/commands");
const coreutils_1 = require("@lumino/coreutils");
const enzyme_1 = require("enzyme");
const enzyme_adapter_react_16_1 = __importDefault(require("enzyme-adapter-react-16"));
const React = __importStar(require("react"));
const PipelineEditorWidget_1 = require("../PipelineEditorWidget");
const PIPELINE_FACTORY = 'Pipeline Editor';
const PIPELINE = 'pipeline';
enzyme_1.configure({ adapter: new enzyme_adapter_react_16_1.default() });
jest.mock('../PipelineService');
describe('@elyra/pipeline-editor', () => {
    let pipelineEditorFactory;
    let manager;
    let textModelFactory;
    let services;
    let pipelineEditorWidget;
    describe('PipelineEditorFactory', () => {
        it('should create a PipelineEditorFactory', () => __awaiter(void 0, void 0, void 0, function* () {
            const tracker = new apputils_1.WidgetTracker({
                namespace: 'filebrowser'
            });
            textModelFactory = new docregistry_1.TextModelFactory();
            const registry = new docregistry_1.DocumentRegistry({
                textModelFactory
            });
            const opener = {
                open: widget => {
                    // no-op
                }
            };
            services = new services_1.ServiceManager();
            yield services.ready;
            manager = new docmanager_1.DocumentManager({
                registry,
                opener,
                manager: services
            });
            const createFileBrowser = (id, options = {}) => {
                var _a;
                const model = new filebrowser_1.FilterFileBrowserModel({
                    auto: (_a = options.auto, (_a !== null && _a !== void 0 ? _a : true)),
                    manager: manager,
                    driveName: options.driveName || '',
                    refreshInterval: options.refreshInterval,
                    state: options.state === null ? undefined : options.state || undefined
                });
                const restore = options.restore;
                const widget = new filebrowser_1.FileBrowser({ id, model, restore });
                // Track the newly created file browser.
                void tracker.add(widget);
                return widget;
            };
            // Manually restore and load the default file browser.
            const defaultBrowser = createFileBrowser('filebrowser', {
                auto: false,
                restore: false
            });
            const browserFactory = { createFileBrowser, defaultBrowser, tracker };
            pipelineEditorFactory = new PipelineEditorWidget_1.PipelineEditorFactory({
                name: PIPELINE_FACTORY,
                fileTypes: [PIPELINE],
                defaultFor: [PIPELINE],
                shell: new application_1.LabShell(),
                commands: new commands_1.CommandRegistry(),
                browserFactory: browserFactory,
                serviceManager: services
            });
            expect(pipelineEditorFactory).toBeInstanceOf(PipelineEditorWidget_1.PipelineEditorFactory);
        }));
        it('should create a PipelineEditorWidget', () => __awaiter(void 0, void 0, void 0, function* () {
            const context = new docregistry_1.Context({
                manager: services,
                factory: textModelFactory,
                path: coreutils_1.UUID.uuid4() + '.pipeline'
            });
            const documentWidget = pipelineEditorFactory.createNew(context);
            expect(documentWidget).toBeInstanceOf(docregistry_1.DocumentWidget);
            expect(documentWidget.content).toBeInstanceOf(PipelineEditorWidget_1.PipelineEditorWidget);
            pipelineEditorWidget = documentWidget.content;
        }));
    });
    describe('PipelineEditor', () => {
        it('should create a PipelineEditor', () => {
            const pipelineEditor = enzyme_1.mount(React.createElement(PipelineEditorWidget_1.PipelineEditor, { shell: pipelineEditorWidget.shell, commands: pipelineEditorWidget.commands, browserFactory: pipelineEditorWidget.browserFactory, widgetContext: pipelineEditorWidget.context, widgetId: pipelineEditorWidget.id, serviceManager: pipelineEditorWidget.serviceManager, addFileToPipelineSignal: pipelineEditorWidget.addFileToPipelineSignal }));
            expect(pipelineEditor.state()).toEqual({
                showPropertiesDialog: false,
                propertiesInfo: {},
                showValidationError: false,
                validationError: { errorMessage: '', errorSeverity: 'error' },
                emptyPipeline: true
            });
        });
    });
});
//# sourceMappingURL=pipeline.spec.js.map