/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.meta.DrbDefaultMetadata;
import fr.gael.drb.meta.DrbMetadata;
import fr.gael.drb.meta.DrbMetadataResolver;
import fr.gael.drb.value.String;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DrbDefaultMetadataResolver
implements DrbMetadataResolver {
    private static Logger logger = Logger.getLogger(DrbDefaultMetadataResolver.class);
    private static Hashtable<java.lang.String, java.lang.String> extensionHash = new Hashtable();
    private static Hashtable<java.lang.String, java.lang.String> schemaHash;

    public static Hashtable<java.lang.String, java.lang.String> getExtensionHash() {
        return (Hashtable)extensionHash.clone();
    }

    public static Hashtable<java.lang.String, java.lang.String> getSchemaHash() {
        return (Hashtable)schemaHash.clone();
    }

    @Override
    public DrbMetadata resolveMetadata(java.lang.String item_name) throws NullPointerException {
        if (item_name == null) {
            throw new NullPointerException("Cannot get metadata object from a null item name.");
        }
        logger.debug("Resolving metadata for item: " + item_name);
        java.lang.String extension = null;
        if (item_name.lastIndexOf(".") < 0) {
            logger.debug("No extension found for item name \"" + item_name + "\"");
            return null;
        }
        extension = item_name.substring(item_name.lastIndexOf(".") + 1);
        extension = extension.toLowerCase();
        logger.debug("Found extension \"" + extension + "\" for item name \"" + item_name + "\"");
        java.lang.String implementation_identifier = extensionHash.get(extension);
        java.lang.String schema_location = schemaHash.get(extension);
        if (implementation_identifier == null && schema_location == null) {
            logger.debug("No implementation nor schema location for item name \"" + item_name + "\"");
            return null;
        }
        DrbDefaultMetadata metadata = new DrbDefaultMetadata("", "");
        if (implementation_identifier != null) {
            logger.debug("Adding \"implementationIdentifier\" property: \"" + implementation_identifier + "\"");
            metadata.setProperty("implementationIdentifier", new String(implementation_identifier));
        }
        if (schema_location != null) {
            logger.debug("Adding \"schemaLocation\" property: \"" + schema_location + "\"");
            metadata.setProperty("schemaLocation", new String(schema_location));
        }
        return metadata;
    }

    @Override
    public DrbMetadata resolveMetadata(DrbItem item) {
        DrbNode node;
        DrbAttributeList attrs;
        if (item == null) {
            return null;
        }
        DrbDefaultMetadata meta = (DrbDefaultMetadata)this.resolveMetadata(item.getName());
        if (item instanceof DrbNode && (attrs = (node = (DrbNode)item).getAttributes()) != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                DrbAttribute attr = attrs.item(i);
                if (meta == null) {
                    meta = new DrbDefaultMetadata("", "");
                }
                meta.setProperty(attr.getName(), attr.getValue());
            }
        }
        return meta;
    }

    @Override
    public DrbMetadata resolveMetadata(DrbSequence sequence) {
        if (sequence == null || sequence.getLength() != 1) {
            return null;
        }
        DrbItem item = sequence.getItem(0);
        if (item == null) {
            return null;
        }
        return this.resolveMetadata(item.getName());
    }

    public static void registerItemNameExtension(java.lang.String extension, java.lang.String implementation_identifier) throws NullPointerException {
        if (extension == null) {
            throw new NullPointerException("Cannot register a null extension.");
        }
        if (implementation_identifier == null) {
            throw new NullPointerException("Cannot register a null imeplementation identifier.");
        }
        extensionHash.put(extension, implementation_identifier);
    }

    public static void registerSchemaLocation(java.lang.String extension, java.lang.String schema_location) {
        schemaHash.put(extension, schema_location);
    }

    static {
        extensionHash.put("xsl", "xml");
        extensionHash.put("rdf", "xml");
        extensionHash.put("owl", "xml");
        extensionHash.put("gml", "xml");
        extensionHash.put("xml", "xml");
        extensionHash.put("xsd", "xml");
        schemaHash = new Hashtable();
    }
}

