/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.file;

import fr.gael.drb.DrbAbstractAttribute;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.file.FileNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Value;
import org.apache.log4j.Logger;

class FileAttribute
extends DrbAbstractAttribute {
    private static Logger logger = Logger.getLogger(FileAttribute.class);
    String name;
    protected FileNode owner;

    protected FileAttribute(String name, FileNode owner) {
        this.name = name;
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot rename a file attribute");
    }

    @Override
    public DrbNode getOwner() {
        return this.owner;
    }

    @Override
    public int getValueType() {
        if (this.name.equals("size")) {
            return 4;
        }
        if (this.name.equals("modified")) {
            return 8;
        }
        if (this.name.equals("readable")) {
            return 0;
        }
        if (this.name.equals("writable")) {
            return 0;
        }
        if (this.name.equals("hidden")) {
            return 0;
        }
        if (this.name.equals("directory")) {
            return 0;
        }
        return -1;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        if (namespace_uri != null) {
            throw new UnsupportedOperationException("Cannot rename a file attribute");
        }
    }

    @Override
    public Value getValue() {
        if (this.name.equals("size")) {
            return new Long(this.owner.file.length());
        }
        if (this.name.equals("modified")) {
            return new DateTime(this.owner.file.lastModified());
        }
        if (this.name.equals("readable")) {
            return new Boolean(this.owner.file.canRead());
        }
        if (this.name.equals("writable")) {
            return new Boolean(this.owner.file.canWrite());
        }
        if (this.name.equals("hidden")) {
            return new Boolean(this.owner.file.isHidden());
        }
        if (this.name.equals("directory")) {
            return new Boolean(this.owner.file.isDirectory());
        }
        return null;
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (this.name.equals("modified")) {
            DateTime last_modified = (DateTime)value.convertTo(8);
            if (this.owner.file.setLastModified(last_modified.getTime())) {
                return new DateTime(this.owner.file.lastModified());
            }
            throw new UnsupportedOperationException("Cannot change the last modified time.");
        }
        throw new UnsupportedOperationException("Cannot change the '" + this.name + "' attribute.");
    }
}

