/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.impl.sdf.RandomAccessData;
import java.io.IOException;
import java.nio.ByteBuffer;

class RandomAccessByteArrayData
extends RandomAccessData {
    ByteBuffer buffer;
    long offset = 0L;

    public RandomAccessByteArrayData(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buffer.get() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buffer.get();
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.buffer.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.get(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException();
    }

    @Override
    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.buffer.getShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        try {
            this.buffer.position(this.buffer.position() + n);
            return n;
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    @Override
    public String readUTF() throws IOException {
        throw new IOException();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.buffer.put(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.buffer.put((byte)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.buffer.put(s.getBytes());
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.buffer.put(s.getBytes());
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buffer.putDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buffer.putFloat(v);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.put(b, off, len);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buffer.putInt(v);
    }

    @Override
    public void write(int v) throws IOException {
        this.buffer.put((byte)(v & 0xFF));
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buffer.putLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buffer.putShort((short)v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new IOException();
    }

    @Override
    void close() throws IOException {
    }

    @Override
    public long available() throws IOException {
        return this.buffer.capacity() - this.buffer.position();
    }

    @Override
    void seek(long pos) throws IOException {
        this.buffer.position((int)pos);
    }

    @Override
    long length() throws IOException {
        return this.buffer.capacity();
    }
}

