/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.DrbFactory;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sdf.RandomAccessData;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RandomAccessStreamData
extends RandomAccessData {
    DrbNodeImpl node;
    DataInput input;
    InputStream streamIn;
    DataOutput output;
    OutputStream streamOut;
    long position;
    long length = -1L;

    protected RandomAccessStreamData(DrbNodeImpl node) {
        this.node = node;
        this.reset();
    }

    private void reset() {
        this.position = 0L;
        this.streamIn = (InputStream)this.node.getImpl(InputStream.class);
        if (this.streamIn != null) {
            this.input = new DataInputStream(this.streamIn);
        }
        if (this.streamOut != null) {
            this.output = new DataOutputStream(this.streamOut);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        ++this.position;
        return this.input.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        ++this.position;
        return this.input.readByte();
    }

    @Override
    public char readChar() throws IOException {
        this.position += 2L;
        return this.input.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.position += 8L;
        return this.input.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.position += 4L;
        return this.input.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        if (b != null) {
            this.position += (long)b.length;
        }
        this.input.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            this.position += (long)len;
        }
        this.input.readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        this.position += 4L;
        return this.input.readInt();
    }

    @Override
    public String readLine() throws IOException {
        String line = this.input.readLine();
        if (line != null) {
            this.position += (long)line.length();
        }
        return line;
    }

    @Override
    public long readLong() throws IOException {
        this.position += 8L;
        return this.input.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.position += 2L;
        return this.input.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        ++this.position;
        return this.input.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.position += 2L;
        return this.input.readUnsignedShort();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.position += (long)n;
        return this.input.skipBytes(n);
    }

    @Override
    public String readUTF() throws IOException {
        String str = this.input.readUTF();
        if (str != null) {
            this.position += (long)str.length();
        }
        return str;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.output.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.output.writeByte(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.output.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.output.writeChars(s);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.output.writeBytes(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.output.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.output.writeFloat(v);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.output.writeInt(v);
    }

    @Override
    public void write(int v) throws IOException {
        this.output.write(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.output.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.output.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.output.writeUTF(str);
    }

    @Override
    void close() throws IOException {
        if (this.streamIn != null) {
            this.streamIn.close();
        }
        if (this.streamOut != null) {
            this.streamOut.close();
        }
    }

    @Override
    public long available() throws IOException {
        if (this.streamIn == null) {
            return 0L;
        }
        return this.streamIn.available();
    }

    @Override
    void seek(long pos) throws IOException {
        if (this.position > pos) {
            this.reset();
        }
        this.streamIn.skip(pos - this.position);
        this.position = pos;
    }

    @Override
    long length() throws IOException {
        if (this.length < 0L) {
            this.length = 0L;
            long skiped = 0L;
            this.reset();
            while ((skiped = (long)this.streamIn.available()) > 0L) {
                skiped = this.streamIn.skip(skiped);
                this.length += skiped;
            }
            this.reset();
        }
        return this.length;
    }

    public static void main(String[] args) {
        DrbNodeImpl nodeImpl = (DrbNodeImpl)DrbFactory.open(args[0]);
        RandomAccessStreamData data = new RandomAccessStreamData(nodeImpl);
        byte[] buf = new byte[10];
        try {
            System.err.println("length=" + data.length());
            data.seek(14L);
            data.readFully(buf);
            System.err.println("buf=" + new String(buf));
            data.seek(5L);
            data.readFully(buf);
            System.err.println("buf=" + new String(buf));
            data.seek(1L);
            data.readFully(buf);
            System.err.println("buf=" + new String(buf));
            data.seek(14L);
            data.readFully(buf);
            System.err.println("buf=" + new String(buf));
            data.seek(2L);
            data.readFully(buf);
            System.err.println("buf=" + new String(buf));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

