/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.impl.sds.IntMap;
import org.apache.log4j.Logger;

final class LongMapEntry {
    private static Logger logger = Logger.getLogger(LongMapEntry.class);
    private int[] key;
    private long value;

    protected LongMapEntry(int[] key, long value) {
        if (key == null) {
            logger.error("LongMapEntry.LongMapEntry() ERROR: Invalid parameter.");
            logger.error("   key = null");
        }
        this.key = key;
        this.value = value;
    }

    protected final int[] getKey() {
        return this.key;
    }

    protected final long getValue() {
        return this.value;
    }

    protected final void setValue(long value) {
        this.value = value;
    }

    public final String toString() {
        if (this.key == null) {
            return null;
        }
        String info = "[" + IntMap.keyToString(this.key) + " ";
        info = info + this.value + "]";
        return info;
    }

    public static void main(String[] args) {
        LongMapEntry e1 = new LongMapEntry(new int[0], 0x100000000L);
        LongMapEntry e2 = new LongMapEntry(new int[]{1, 4}, 3L);
        LongMapEntry e3 = new LongMapEntry(new int[]{1, 4, 2}, 7L);
        System.out.println("e1 = " + e1);
        System.out.println("e2 = " + e2);
        System.out.println("e3 = " + e3);
        System.out.println("e3.getKey().length = " + e3.getKey().length);
        System.out.println("e3.getValue() = " + e3.getValue());
        System.out.println("e1.getValue() = " + e1.getValue());
        System.out.println("e2.getValue() = " + e2.getValue());
    }
}

