/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.SaxNode;
import fr.gael.drb.value.Value;
import org.apache.log4j.Logger;

class SaxDocument
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(SaxDocument.class);
    private DrbNode baseNode;
    private SaxNode rootNode;

    protected SaxDocument(DrbNode base) {
        if (base == null) {
            throw new NullPointerException("The base node shall not be null.");
        }
        this.baseNode = base;
        this.rootNode = new SaxNode(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SaxDocument) {
            SaxDocument sax_doc = (SaxDocument)obj;
            return this.rootNode == sax_doc.rootNode;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.baseNode.getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.baseNode.getNamespaceURI();
    }

    @Override
    public String getPath() {
        if (this.baseNode == null) {
            return "";
        }
        return this.baseNode.getPath();
    }

    @Override
    public int getIndex() {
        return this.baseNode.getIndex();
    }

    @Override
    public int getValueType() {
        return -1;
    }

    @Override
    public Value getValue() {
        return null;
    }

    @Override
    public DrbAttributeList getAttributes() {
        DrbAttributeList attributes = this.baseNode.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return null;
        }
        DrbDefaultAttributeList list = new DrbDefaultAttributeList();
        for (int i = 0; i < attributes.getLength(); ++i) {
            DrbAttribute attrib = attributes.item(i);
            if (attrib == null) continue;
            list.add(new DrbDefaultAttribute(attrib.getName(), attrib.getValue(), this));
        }
        return list;
    }

    @Override
    public DrbNode getParent() {
        return this.baseNode.getParent();
    }

    @Override
    public final boolean hasChild() {
        return true;
    }

    @Override
    public DrbNodeList getChildren() {
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        list.add(this.rootNode);
        return list;
    }

    @Override
    public boolean hasImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).hasImpl(api);
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).getImpl(api);
        }
        return super.getImpl(api);
    }
}

