/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.XmlDocument;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.impl.xml.XmlItem;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlNode
extends DrbNodeImpl {
    public static final java.lang.String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final java.lang.String XML_PREFIX = "xml";
    public static final java.lang.String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final java.lang.String XMLNS_PREFIX = "xmlns";
    private Element node;
    private XmlDocument document;
    private static Logger logger = Logger.getLogger(XmlNode.class);

    public XmlNode(Node node) {
        this(node, null);
    }

    public XmlNode(InputStream input_stream, DrbNode base_node) {
        if (input_stream == null) {
            throw new NullPointerException();
        }
        InputSource source = new InputSource(input_stream);
        this.document = new XmlDocument(source);
        this.document.baseNode = base_node;
        this.node = this.document.document.getDocumentElement();
        if (this.node == null) {
            throw new IllegalArgumentException("The document has no root element.");
        }
    }

    public XmlNode(Reader reader, DrbNode base_node) {
        if (reader == null) {
            throw new NullPointerException();
        }
        InputSource source = new InputSource(reader);
        this.document = new XmlDocument(source);
        this.document.baseNode = base_node;
        this.node = this.document.document.getDocumentElement();
        if (this.node == null) {
            throw new IllegalArgumentException("The document has no root element.");
        }
    }

    public XmlNode(java.lang.String xml_string) {
        this(new StringReader(xml_string), null);
    }

    public XmlNode(Node node, DrbNode base_node) {
        Document doc_node = node.getOwnerDocument();
        if (doc_node != null) {
            this.document = new XmlDocument(doc_node);
            this.document.baseNode = base_node;
        }
        this.node = (Element)node;
    }

    private XmlNode(Element node, XmlDocument document) {
        this.node = node;
        this.document = document;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XmlNode) {
            XmlNode xml_node = (XmlNode)obj;
            if (this.node == null) {
                return false;
            }
            return this.node == xml_node.node;
        }
        return false;
    }

    @Override
    public java.lang.String getName() {
        return this.node.getLocalName();
    }

    @Override
    public int getIndex() {
        int index = 0;
        for (Node current_node = this.node.getPreviousSibling(); current_node != null; current_node = current_node.getPreviousSibling()) {
            if (current_node.getNodeType() != 1) continue;
            ++index;
        }
        return index;
    }

    @Override
    public DrbNode getRoot() {
        if (this.document != null) {
            return this.document.getRoot();
        }
        return null;
    }

    @Override
    public int getOccurrence() {
        java.lang.String name = this.node.getLocalName();
        if (name == null) {
            return 1;
        }
        int occurence = 1;
        for (Node current_node = this.node.getPreviousSibling(); current_node != null; current_node = current_node.getPreviousSibling()) {
            try {
                if (current_node.getNodeType() != this.node.getNodeType() || name.compareTo(current_node.getLocalName()) != 0) continue;
                ++occurence;
                continue;
            }
            catch (NullPointerException e) {
                return -1;
            }
        }
        return occurence;
    }

    @Override
    public boolean allowsMultiOccurrence() {
        Node current_node;
        java.lang.String name = this.node.getLocalName();
        if (name == null) {
            return false;
        }
        for (current_node = this.node.getNextSibling(); current_node != null; current_node = current_node.getNextSibling()) {
            if (current_node.getNodeType() != this.node.getNodeType() || name.compareTo(current_node.getLocalName()) != 0) continue;
            return true;
        }
        for (current_node = this.node.getPreviousSibling(); current_node != null; current_node = current_node.getPreviousSibling()) {
            if (current_node.getNodeType() != this.node.getNodeType() || name.compareTo(current_node.getLocalName()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public java.lang.String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public int getValueType() {
        return 7;
    }

    @Override
    public Value getValue() {
        java.lang.String string = null;
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            try {
                java.lang.String text = null;
                short node_type = child.getNodeType();
                if (child.getNodeType() == 3) {
                    text = child.getNodeValue();
                    if (text != null && (text = text.trim()).length() == 0) {
                        text = null;
                    }
                } else if (node_type == 4) {
                    text = child.getNodeValue();
                }
                if (string == null) {
                    string = text;
                    continue;
                }
                if (text == null) continue;
                string = string.concat(text);
                continue;
            }
            catch (DOMException e) {
                logger.error("fr.gael.drb.impl.xml.XmlNode.getValue() : Cannot get node value.");
                logger.error("fr.gael.drb.impl.xml.XmlNode.getValue() : " + e);
            }
        }
        if (string != null) {
            return new String(string);
        }
        return null;
    }

    @Override
    public Namespace getNamespaceBindings() {
        Namespace namespace = new Namespace();
        namespace.bind(XML_PREFIX, XML_NAMESPACE);
        namespace.bind(XMLNS_PREFIX, XMLNS_NAMESPACE);
        NamedNodeMap dom_attr_list = this.node.getAttributes();
        Attr dom_attr = null;
        java.lang.String dom_attr_value = null;
        java.lang.String dom_attr_name = null;
        if (dom_attr_list != null && dom_attr_list.getLength() > 0) {
            int dom_attr_count = dom_attr_list.getLength();
            for (int iattr = 0; iattr < dom_attr_count; ++iattr) {
                try {
                    dom_attr = (Attr)dom_attr_list.item(iattr);
                    if (dom_attr == null) {
                        logger.error("XmlNode.getNamespaceBindings() : Warning : cannot get attribute #" + (iattr + 1) + ".");
                        continue;
                    }
                    dom_attr_value = dom_attr.getNodeValue();
                    if (dom_attr_value == null) {
                        logger.error("XmlNode.getNamespaceBindings : Warning : cannot get value of attribute #" + (iattr + 1) + ".");
                        continue;
                    }
                    dom_attr_name = dom_attr.getLocalName();
                    if (dom_attr_name == null) {
                        logger.error("XmlNode.getNamespaceBindings() : Warning : cannot get name of attribute #" + (iattr + 1) + ".");
                        continue;
                    }
                    java.lang.String attr_prefix = Namespace.toPrefix(dom_attr.getNodeName());
                    if (attr_prefix == null) {
                        attr_prefix = dom_attr.getPrefix();
                    }
                    if (XMLNS_PREFIX.equals(dom_attr.getNodeName())) {
                        namespace.setDefaultNamespaceURI(dom_attr_value);
                        continue;
                    }
                    if (!XMLNS_PREFIX.equals(attr_prefix)) continue;
                    namespace.bind(dom_attr_name, dom_attr_value);
                    continue;
                }
                catch (DOMException e) {
                    logger.error("fr.gael.drb.impl.xml.XmlNode.getValue() : Cannot get attribute #" + iattr + "value.");
                    logger.error("fr.gael.drb.impl.xml.XmlNode.getValue() : " + e);
                }
            }
        }
        return namespace;
    }

    @Override
    public final DrbAttributeList getAttributes() {
        NamedNodeMap dom_attr_list = this.node.getAttributes();
        Attr dom_attr = null;
        java.lang.String dom_attr_value = null;
        java.lang.String dom_attr_name = null;
        ArrayList attr_list = null;
        DrbDefaultAttribute attr = null;
        String attr_value = null;
        if (dom_attr_list != null && dom_attr_list.getLength() > 0) {
            int dom_attr_count = dom_attr_list.getLength();
            for (int iattr = 0; iattr < dom_attr_count; ++iattr) {
                try {
                    dom_attr = (Attr)dom_attr_list.item(iattr);
                    if (dom_attr == null) {
                        logger.error("XmlNode.getAttributes() : Warning : cannot get attribute #" + (iattr + 1) + ".");
                        continue;
                    }
                    dom_attr_value = dom_attr.getNodeValue();
                    if (dom_attr_value == null) {
                        logger.error("XmlNode.getAttributes() : Warning : cannot get value of attribute #" + (iattr + 1) + ".");
                        continue;
                    }
                    dom_attr_name = dom_attr.getLocalName();
                    if (dom_attr_name == null) {
                        logger.error("XmlNode.getAttributes() : Warning : cannot get name of attribute #" + (iattr + 1) + ".");
                        continue;
                    }
                    attr_value = new String(dom_attr_value);
                    if (attr_value == null) {
                        logger.error("XmlNode.getAttributes() : Warning : cannot build attribute #" + (iattr + 1) + " value string.");
                        continue;
                    }
                    java.lang.String attr_prefix = Namespace.toPrefix(dom_attr.getNodeName());
                    if (attr_prefix == null) {
                        attr_prefix = dom_attr.getPrefix();
                    }
                    if (XMLNS_PREFIX.equals(attr_prefix) || XMLNS_PREFIX.equals(dom_attr_name)) continue;
                    attr = new DrbDefaultAttribute(dom_attr_name, attr_value, dom_attr.getSpecified(), this);
                    java.lang.String attr_uri = dom_attr.getNamespaceURI();
                    attr.setNamespaceURI(attr_uri);
                    if (attr_list == null) {
                        attr_list = new DrbDefaultAttributeList();
                    }
                    attr_list.add(attr);
                    continue;
                }
                catch (DOMException e) {
                    logger.error("fr.gael.drb.impl.xml.XmlNode.getValue() : Cannot get attribute #" + iattr + "value.");
                    logger.error("fr.gael.drb.impl.xml.XmlNode.getValue() : " + e);
                }
            }
            return attr_list;
        }
        return null;
    }

    @Override
    public DrbNode getParent() {
        Node parent = this.node.getParentNode();
        if (parent != null && parent.getNodeType() == 1) {
            return new XmlNode((Element)parent, this.document);
        }
        return this.document;
    }

    @Override
    public DrbNodeList getChildren() {
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            list.add(new XmlNode((Element)child, this.document));
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public DrbSequence getContent() {
        DrbDefaultSequence list = new DrbDefaultSequence();
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                list.addItem(new XmlNode((Element)child, this.document));
                continue;
            }
            if (child.getNodeType() == 3) {
                java.lang.String text = child.getNodeValue();
                if (text == null || text.trim().length() <= 0) continue;
                list.addItem(new String(text.trim()));
                continue;
            }
            list.addItem(new XmlItem(child));
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public boolean hasChild() {
        return this.getFirstChild() != null;
    }

    @Override
    public DrbNode getNamedChild(java.lang.String name, int occurence) {
        if (name == null || occurence <= 0) {
            logger.error("XmlNode.getNamedChild(): Invalid parameters.");
            return null;
        }
        int current_occurence = 0;
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getLocalName()) || ++current_occurence != occurence) continue;
            return new XmlNode((Element)child, this.document);
        }
        return null;
    }

    @Override
    public DrbNode getFirstChild() {
        return this.getChildAt(0);
    }

    @Override
    public DrbNode getLastChild() {
        for (Node child = this.node.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            return new XmlNode((Element)child, this.document);
        }
        return null;
    }

    @Override
    public DrbNode getChildAt(int index) {
        int counter = 0;
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (counter == index) {
                return new XmlNode((Element)child, this.document);
            }
            ++counter;
        }
        return null;
    }

    @Override
    public int getChildrenCount() {
        int counter = 0;
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public DrbNode getPreviousSibling() {
        for (Node sibling = this.node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return new XmlNode((Element)sibling, this.document);
        }
        return null;
    }

    @Override
    public DrbNode getNextSibling() {
        for (Node sibling = this.node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return new XmlNode((Element)sibling, this.document);
        }
        return null;
    }

    @Override
    public void flush() {
        if (this.document != null) {
            DrbNode root_node = this.document.getFirstChild();
            OutputStream output_stream = (OutputStream)this.document.getImpl(OutputStream.class);
            if (output_stream != null && root_node != null) {
                XmlWriter.writeXML(root_node, output_stream);
            }
        }
    }

    @Override
    public java.lang.String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XmlFactory.writeXML(this, stream);
        return stream.toString();
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        NodeList list_child = this.node.getChildNodes();
        if (list_child != null) {
            for (int ichild = 0; ichild < list_child.getLength(); ++ichild) {
                Node nodeChild = list_child.item(ichild);
                if (nodeChild.getNodeType() != 3 && nodeChild.getNodeType() != 4) continue;
                this.node.removeChild(nodeChild);
            }
        }
        if (value != null) {
            Document doc = this.node.getOwnerDocument();
            Text text = null;
            java.lang.String val = value.toString();
            text = !val.trim().equals(val) || val.startsWith(" ") ? doc.createCDATASection(val) : doc.createTextNode(val);
            this.node.appendChild(text);
        }
        this.flush();
        this.nodesChanged(new DrbNodesChangeEvent(this));
        return value;
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        if (attributes == null) {
            throw new NullPointerException("XmlNode.setAttributes: null attribute list!");
        }
        if (!(this.node instanceof Element)) {
            throw new UnsupportedOperationException("XmlNode.setAttributes : not an element");
        }
        NamedNodeMap dom_attr_list = this.node.getAttributes();
        Attr dom_attr = null;
        DrbAttribute new_attr = null;
        java.lang.String new_attr_value = null;
        Element element = this.node;
        if (dom_attr_list != null) {
            int dom_attr_count = dom_attr_list.getLength();
            for (int iattr = 0; iattr < dom_attr_count; ++iattr) {
                dom_attr = (Attr)dom_attr_list.item(0);
                element.removeAttributeNode(dom_attr);
            }
        }
        for (int iattr = 0; iattr < attributes.getLength(); ++iattr) {
            new_attr = attributes.item(iattr);
            new_attr_value = new_attr.getValue().toString();
            if (new_attr_value == null) {
                logger.error("XmlNode.getAttributes() : Warning : cannot get value of attribute #" + (iattr + 1) + ".");
                continue;
            }
            java.lang.String new_attr_qualifiedName = new_attr.getName();
            if (new_attr_qualifiedName == null) {
                logger.error("XmlNode.getAttributes() : Warning : cannot get qualified name of attribute #" + (iattr + 1) + ".");
                continue;
            }
            java.lang.String new_attr_name_space = new_attr.getNamespaceURI();
            element.setAttributeNS(new_attr_name_space, new_attr_qualifiedName, new_attr_value);
        }
        this.flush();
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public void rename(java.lang.String name) throws NullPointerException, UnsupportedOperationException {
        if (name == null) {
            throw new NullPointerException("XmlNode.rename() : The reference to the new name is null.");
        }
        NodeList list_child = this.node.getChildNodes();
        Document myDoc = this.node.getOwnerDocument();
        Element newNode = myDoc.createElementNS(this.node.getNamespaceURI(), name);
        NamedNodeMap dom_attr_list = this.node.getAttributes();
        Node parent = this.node.getParentNode();
        parent.replaceChild(newNode, this.node);
        int num_child = list_child.getLength();
        for (int ichild = 0; ichild < num_child; ++ichild) {
            Node nodeChild = list_child.item(0);
            newNode.appendChild(nodeChild);
        }
        this.node = newNode;
        if (dom_attr_list != null && dom_attr_list.getLength() > 0) {
            int dom_attr_count = dom_attr_list.getLength();
            for (int iattr = 0; iattr < dom_attr_count; ++iattr) {
                Attr dom_attr = (Attr)dom_attr_list.item(iattr);
                newNode.setAttributeNS(dom_attr.getNamespaceURI(), dom_attr.getNodeName(), dom_attr.getNodeValue());
            }
        }
        this.flush();
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public void setNamespaceURI(java.lang.String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        NodeList list_child = this.node.getChildNodes();
        Document myDoc = this.node.getOwnerDocument();
        Element newNode = myDoc.createElementNS(namespace_uri, this.node.getNodeName());
        NamedNodeMap dom_attr_list = this.node.getAttributes();
        Node parent = this.node.getParentNode();
        parent.replaceChild(newNode, this.node);
        int num_child = list_child.getLength();
        for (int ichild = 0; ichild < num_child; ++ichild) {
            Node nodeChild = list_child.item(0);
            newNode.appendChild(nodeChild);
        }
        this.node = newNode;
        if (dom_attr_list != null && dom_attr_list.getLength() > 0) {
            int dom_attr_count = dom_attr_list.getLength();
            for (int iattr = 0; iattr < dom_attr_count; ++iattr) {
                Attr dom_attr = (Attr)dom_attr_list.item(iattr);
                newNode.setAttributeNS(dom_attr.getNamespaceURI(), dom_attr.getNodeName(), dom_attr.getNodeValue());
            }
        }
        this.flush();
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (new_node == null) {
            throw new NullPointerException("XmlNode.replaceChild() : Reference to the node is null.");
        }
        if (index < 0 || index > this.getChildrenCount()) {
            throw new IndexOutOfBoundsException("XmlNode.replaceChild() : Index #" + index);
        }
        this.removeChild(index);
        DrbNode replacing_node = this.insertChild(new_node, index);
        return replacing_node;
    }

    public static java.lang.String toXML(java.lang.String str) {
        if (str == null) {
            return null;
        }
        char[] str_array = str.toCharArray();
        java.lang.String xml_str = "";
        for (int index = 0; index < str_array.length; ++index) {
            xml_str = str_array[index] == '&' ? xml_str + "&amp;" : (str_array[index] == '\"' ? xml_str + "&quot;" : (str_array[index] == '\'' ? xml_str + "&apos;" : (str_array[index] == '<' ? xml_str + "&lt;" : (str_array[index] == '>' ? xml_str + "&gt;" : (str_array[index] == '\n' ? xml_str + "&#10;" : xml_str + java.lang.String.valueOf(str_array[index]))))));
        }
        return xml_str;
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        int children_count = this.getChildrenCount();
        if (index < 0 || index > children_count) {
            throw new IndexOutOfBoundsException("XmlNode.removeChild(" + index + ") : Index #" + index + " out of bound (children count =" + children_count + ")");
        }
        NodeList list_child = this.node.getChildNodes();
        int index_child = -1;
        for (int ichild = 0; ichild < list_child.getLength(); ++ichild) {
            Node nodeChild = list_child.item(ichild);
            if (nodeChild.getNodeType() == 1) {
                ++index_child;
            }
            if (index_child != index) continue;
            this.node.removeChild(nodeChild);
        }
        this.flush();
        this.nodesRemoved(new DrbNodesChangeEvent(this));
    }

    @Override
    public DrbNode insertChild(DrbNode new_node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        DrbNodeList new_drb_children;
        Value new_drb_value;
        int children_count = this.getChildrenCount();
        if (new_node == null || index < 0 || index > children_count) {
            throw new IndexOutOfBoundsException("XmlNode.insertChild() : Index #" + index);
        }
        NodeList dom_child = this.node.getChildNodes();
        int drbIndex = -1;
        int domIndex = -1;
        for (domIndex = 0; domIndex < dom_child.getLength(); ++domIndex) {
            if (dom_child.item(domIndex).getNodeType() == 1) {
                ++drbIndex;
            }
            if (drbIndex == index) break;
        }
        Node nodeAfter = null;
        if (domIndex < dom_child.getLength()) {
            nodeAfter = dom_child.item(domIndex);
        }
        Document myDoc = this.node.getOwnerDocument();
        java.lang.String name = new_node.getName();
        java.lang.String ns_uri = new_node.getNamespaceURI();
        Element new_dom_node = myDoc.createElementNS(ns_uri, name);
        if (nodeAfter != null) {
            this.node.insertBefore(new_dom_node, nodeAfter);
        } else {
            this.node.appendChild(new_dom_node);
        }
        XmlNode new_drb_node = new XmlNode(new_dom_node, this.document);
        DrbAttributeList new_drb_attributes = new_node.getAttributes();
        if (new_drb_attributes != null) {
            new_drb_node.setAttributes(new_drb_attributes);
        }
        if ((new_drb_value = new_node.getValue()) != null) {
            new_drb_node.setValue(new_drb_value);
        }
        if ((new_drb_children = new_node.getChildren()) != null) {
            for (int ichild = 0; ichild < new_drb_children.getLength(); ++ichild) {
                new_drb_node.appendChild(new_drb_children.item(ichild));
            }
        }
        this.flush();
        DrbDefaultNodeList node_list = new DrbDefaultNodeList();
        node_list.add(new_drb_node);
        this.nodesInserted(new DrbNodesChangeEvent(this, node_list));
        return new_drb_node;
    }

    @Override
    public DrbNode appendChild(DrbNode nodes) throws NullPointerException, UnsupportedOperationException {
        int child_count = this.getChildrenCount();
        return this.insertChild(nodes, child_count);
    }
}

