/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.SaxDocument;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.impl.xml.XmlNode;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import fr.gael.drb.xsd.XsdAtomicType;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.log4j.Logger;

public class XmlWriter {
    private static Logger logger = Logger.getLogger(XmlFactory.class);
    public static final int SHOW_ALL = 0xFFFFFF;
    public static final int SHOW_ATTRIBUTE = 1;
    public static final int SHOW_COMMENT = 2;
    public static final int SHOW_PROCESSING_INSTRUCTION = 4;
    public static final int SHOW_NOTATION = 8;
    private XmlStream stream;

    public XmlWriter(OutputStream file) {
        try {
            this.stream = new XmlStream(file);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public XmlWriter(Writer file, String encoding) {
        try {
            this.stream = new XmlStream(file, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public XmlWriter(DrbNode node) {
        if (node == null || !(node instanceof DrbNodeImpl)) {
            return;
        }
        DrbNodeImpl baseImpl = (DrbNodeImpl)node;
        OutputStream file = (OutputStream)baseImpl.getImpl(OutputStream.class);
        if (file == null) {
            throw new NullPointerException("Cannot retrieve an output stream for writing XML.");
        }
        try {
            this.stream = new XmlStream(file);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public static void writeXML(DrbNode node, OutputStream file) {
        new XmlWriter(file).save(node);
    }

    public static void writeXML(DrbNode node, OutputStream file, Context context, boolean prolog) {
        new XmlWriter(file).save(node, context, prolog);
    }

    public void save(DrbNode node) {
        this.save(node, new Context(), false);
    }

    public void save(DrbNode node, Context context, boolean prolog) {
        if (prolog) {
            this.stream.println("<?xml version=\"1.0\" encoding=\"" + this.stream.encoding + "\"?>");
            this.stream.println();
        }
        if (context == null) {
            context = new Context();
        }
        this.writeNode(node, context);
        this.stream.flush();
    }

    private void writeNode(DrbNode node, Context context) {
        String attr_string;
        if (node == null || context == null) {
            logger.error("XmlWriter.writeNode() : Invalid parameter.");
            return;
        }
        DrbAttributeList attributes = node.getAttributes();
        Namespace declared_namespace = null;
        Namespace namespace = context.getNamespace();
        int indent = context.getIndent();
        int filter = context.getFilter();
        if (node instanceof DrbAbstractNode) {
            declared_namespace = ((DrbAbstractNode)node).getNamespaceBindings();
            namespace.addNamespaces(declared_namespace);
        }
        if (declared_namespace == null) {
            declared_namespace = new Namespace();
        }
        if (attributes != null) {
            for (int iattr = 0; iattr < attributes.getLength(); ++iattr) {
                String attr_name = attributes.item(iattr).getName();
                String attr_uri = attributes.item(iattr).getNamespaceURI();
                String attr_value = attributes.item(iattr).getValue().toString();
                if (!"http://www.w3.org/2000/xmlns/".equals(attr_uri)) continue;
                namespace.bind(attr_name, attr_value);
                declared_namespace.unbind(attr_name);
            }
        }
        for (int i = 0; i < context.getIndent(); ++i) {
            this.stream.print(" ");
        }
        this.stream.print("<");
        String node_fullname = node.getName();
        String node_uri = node.getNamespaceURI();
        String node_prefix = namespace.resolvePrefix(node_uri);
        if ("".equals(node_prefix)) {
            node_prefix = null;
        }
        if ("".equals(node_uri)) {
            node_uri = null;
        }
        if (node_prefix != null) {
            node_fullname = node_prefix + ":" + node_fullname;
        }
        if (node.getName() != null) {
            this.stream.print(node_fullname);
        } else {
            this.stream.print("unnamed");
        }
        if (attributes != null && (filter & 1) != 0) {
            for (int iattr = 0; iattr < attributes.getLength(); ++iattr) {
                String attribute_name = attributes.item(iattr).getName();
                if (attribute_name == null || attribute_name.equals("xmlns")) continue;
                String attr_name = attributes.item(iattr).getName();
                String attr_uri = attributes.item(iattr).getNamespaceURI();
                String attr_prefix = namespace.resolvePrefix(attr_uri);
                Value attr_value = attributes.item(iattr).getValue();
                String attr_string2 = "";
                if (attr_value != null) {
                    attr_string2 = XmlNode.toXML(attr_value.toString());
                }
                if (attr_prefix != null) {
                    attr_name = attr_prefix + ":" + attr_name;
                }
                this.stream.print(" " + attr_name + "=\"" + attr_string2 + "\"");
            }
        }
        boolean default_namespace_written = false;
        String default_namespace = context.getDefaultElementNamespaceURI();
        String[] prefixes = declared_namespace.getDeclaredPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String attr_string3 = namespace.resolveNamespace(prefixes[i]);
            if (attr_string3 == null || prefixes[i].equals("") || prefixes[i].equals("xml") || prefixes[i].equals("xmlns")) continue;
            this.stream.print(" xmlns:" + prefixes[i] + "=\"" + attr_string3 + "\"");
        }
        if (!(node_prefix != null || node_uri == default_namespace || node_uri != null && node_uri.equals(default_namespace))) {
            if (node_uri == null) {
                this.stream.print(" xmlns=\"\"");
            } else {
                this.stream.print(" xmlns=\"" + node_uri + "\"");
            }
            default_namespace_written = true;
            default_namespace = node_uri;
        }
        if (!default_namespace_written && (attr_string = declared_namespace.getDefaultNamespaceURI()) != null && !attr_string.equals(context.getDefaultElementNamespaceURI())) {
            default_namespace_written = true;
            this.stream.print(" xmlns=\"" + attr_string + "\"");
            default_namespace = attr_string;
        }
        DrbSequence content = null;
        if (node instanceof DrbAbstractNode) {
            content = ((DrbAbstractNode)node).getContent();
        } else {
            content = new DrbDefaultSequence(node.getChildren());
            Value value = node.getValue();
            if (value != null) {
                content.addItem(content.getLength(), value);
            }
        }
        if (content != null && content.getLength() > 0) {
            this.stream.print(">");
        }
        boolean single_line = false;
        if (content != null) {
            for (int ichild = 0; ichild < content.getLength(); ++ichild) {
                String value_string;
                Value value;
                DrbItem item = content.getItem(ichild);
                if (item.getItemType() == 1) {
                    Context child_context = context.cloneContext();
                    child_context.setIndent(indent + 3);
                    child_context.setDefaultElementNamespaceURI(default_namespace);
                    if (ichild == 0) {
                        this.stream.println("");
                    }
                    this.writeNode((DrbNode)item, child_context);
                    this.stream.println("");
                    continue;
                }
                if (item.getItemType() == 3 || "#cdata-section".equals(item.getName())) {
                    value = item.getValue();
                    value_string = value == null ? "" : value.toString();
                    boolean use_cdata = "#cdata-section".equals(item.getName());
                    if (use_cdata || value_string.indexOf(60) >= 0 || value_string.indexOf(38) >= 0) {
                        value_string = "<![CDATA[" + value_string + "]]>";
                        use_cdata = true;
                    }
                    if (!use_cdata && !context.preserveSpace) {
                        value_string = value_string.trim();
                    }
                    if (!use_cdata && context.preserveSpace) {
                        value_string = value_string.replaceAll("\n", "&#10;");
                    }
                    if (value_string.equals("")) continue;
                    if (content.getLength() != 1 || value_string.indexOf(10) >= 0) {
                        this.stream.println("");
                        String indent_string = "";
                        for (int i = 0; i < indent + 3; ++i) {
                            indent_string = indent_string + " ";
                        }
                        this.stream.print(indent_string);
                        if (!use_cdata) {
                            value_string = value_string.replaceAll("\n", "\n" + indent_string);
                        }
                    } else {
                        single_line = true;
                    }
                    this.stream.print(value_string);
                    if (single_line) continue;
                    this.stream.println("");
                    continue;
                }
                if (item.getItemType() == 4 && (filter & 2) != 0) {
                    this.stream.println("");
                    for (int i = 0; i < indent + 3; ++i) {
                        this.stream.print(" ");
                    }
                    value = item.getValue();
                    value_string = value == null ? "" : value.toString();
                    this.stream.println("<!--" + value_string + "-->");
                    continue;
                }
                if (item.getItemType() != 5 || (filter & 4) == 0) continue;
                this.stream.println("");
                for (int i = 0; i < indent + 3; ++i) {
                    this.stream.print(" ");
                }
                String pi_target = item.getName();
                Value value2 = item.getValue();
                String value_string2 = value2 == null ? "" : value2.toString();
                this.stream.println("<?" + pi_target + " " + value_string2 + "?>");
            }
        }
        if (content != null && content.getLength() > 0) {
            if (!single_line) {
                for (int i = 0; i < indent; ++i) {
                    this.stream.print(" ");
                }
            }
            this.stream.print("</");
            if (node.getName() != null) {
                this.stream.print(node_fullname);
            } else {
                this.stream.print("unnamed");
            }
            this.stream.print(">");
        } else {
            this.stream.print("/>");
        }
    }

    public static void dump(DrbItem item, OutputStream stream, String indent) {
        PrintWriter printer = new PrintWriter(stream, true);
        if (item instanceof DrbAbstractNode) {
            int i;
            DrbAbstractNode node = (DrbAbstractNode)item;
            printer.println(indent + "element=[");
            printer.println(indent + "  namespace name=[" + node.getNamespaceURI() + "]");
            printer.println(indent + "  local name=[" + node.getName() + "]");
            printer.println(indent + "  index=[" + node.getIndex() + "]");
            printer.println(indent + "  base URI=[" + node.getPath() + "]");
            printer.print(indent + "  attributes=[");
            DrbAttributeList attribs = node.getAttributes();
            if (attribs != null && attribs.getLength() > 0) {
                printer.println("");
                for (int i2 = 0; i2 < attribs.getLength(); ++i2) {
                    XmlWriter.dump(attribs.getItem(i2), stream, indent + "    ");
                }
                printer.println(indent + "  ");
            }
            printer.println("]");
            printer.print(indent + "  namespace declaration=[");
            Namespace namespace = node.getNamespaceBindings();
            if (namespace != null) {
                printer.print(namespace.getDefaultNamespaceURI());
                String[] prefixes = namespace.getDeclaredPrefixes();
                for (i = 0; i < prefixes.length; ++i) {
                    printer.print(" " + prefixes[i] + "=\"" + namespace.resolveNamespace(prefixes[i]) + "\"");
                }
            }
            printer.println("]");
            printer.print(indent + "  children=[");
            DrbSequence content = node.getContent();
            if (content != null && content.getLength() > 0) {
                printer.println("");
                for (i = 0; i < content.getLength(); ++i) {
                    XmlWriter.dump(content.getItem(i), stream, indent + "    ");
                }
                printer.print(indent + "  ");
            }
            printer.println("]");
            printer.println(indent + "]");
        } else if (item instanceof DrbAttribute) {
            DrbAttribute attr = (DrbAttribute)item;
            printer.println(indent + "attribute=[");
            printer.println(indent + "  namespace name=[" + attr.getNamespaceURI() + "]");
            printer.println(indent + "  local name=[" + attr.getName() + "]");
            printer.println(indent + "  prefix=[]");
            printer.print(indent + "  normalized value=[");
            if (attr.getValue() != null) {
                printer.print(attr.getValue().toString());
            }
            printer.println("]");
            printer.println(indent + "  specified=[" + attr.isSpecified() + "]");
            printer.println(indent + "  attribute type=[CDATA]");
            printer.println(indent + "  references=[]");
            printer.println(indent + "]");
        } else if (item instanceof Value) {
            Value value = (Value)item;
            printer.println(indent + "value=[");
            printer.println(indent + "  text=[" + value.toString() + "]");
            printer.print(indent + "  type=[");
            if (value.getType() != 10) {
                printer.print(new XsdAtomicType(value.getType()).getName());
            } else {
                printer.print("array");
            }
            printer.println("]");
            printer.println(indent + "]");
        }
        printer.flush();
    }

    public static void main(String[] args) {
        String xpath = ".";
        XmlWriter writer = new XmlWriter(System.out);
        boolean prolog = false;
        boolean force_sax = false;
        boolean force_xml = false;
        boolean force_dump = false;
        int filter = 0xFFFFFF;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--prolog")) {
                prolog = true;
                continue;
            }
            if (args[i].equals("--no-attribute")) {
                filter ^= 1;
                continue;
            }
            if (args[i].equals("--no-comment")) {
                filter ^= 2;
                continue;
            }
            if (args[i].equals("--xml")) {
                force_xml = true;
                continue;
            }
            if (args[i].equals("--sax")) {
                force_sax = true;
                continue;
            }
            if (args[i].equals("--dump")) {
                force_dump = true;
                continue;
            }
            if (args[i].startsWith("--") || args[i].length() <= 0) continue;
            xpath = args[i];
        }
        DrbNode input_node = DrbFactory.open(xpath);
        if (force_xml) {
            input_node = new XmlFactory().open(input_node);
        }
        if (force_sax) {
            input_node = new SaxDocument(input_node).getFirstChild();
        }
        if (force_dump) {
            XmlWriter.dump(input_node, System.out, "");
        } else {
            Context context = new Context();
            context.setFilter(filter);
            writer.save(input_node, context, prolog);
        }
    }

    class XmlStream
    extends PrintWriter {
        String encoding;

        XmlStream(Writer out, String encoding) throws UnsupportedEncodingException {
            super((Writer)new BufferedWriter(out, 65536), true);
            this.encoding = encoding;
        }

        XmlStream(OutputStream out) throws UnsupportedEncodingException {
            this(out, "UTF-8");
        }

        XmlStream(OutputStream out, String charset_name) throws UnsupportedEncodingException {
            this(new OutputStreamWriter(out, charset_name), charset_name);
        }

        @Override
        public void println() {
            this.write(10);
        }

        @Override
        public void println(String s) {
            this.print(s);
            this.write(10);
        }
    }

    public static class Context
    implements Cloneable {
        private int indent = 0;
        private int filter = 0xFFFFFF;
        protected boolean preserveSpace = true;
        private Namespace namespace = new Namespace();
        private String defaultElementNamespaceURI = null;

        public Context() {
            this.namespace.bind("xml", "http://www.w3.org/XML/1998/namespace");
            this.namespace.bind("xmlns", "http://www.w3.org/2000/xmlns/");
            this.namespace.bind("xs", "http://www.w3.org/2001/XMLSchema");
            this.namespace.bind("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }

        public Context(Namespace namespace, String default_namespace_uri) {
            namespace = namespace.cloneNamespace();
            namespace.bind("xml", "http://www.w3.org/XML/1998/namespace");
            namespace.bind("xmlns", "http://www.w3.org/2000/xmlns/");
            namespace.bind("xs", "http://www.w3.org/2001/XMLSchema");
            namespace.bind("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.namespace = namespace;
            this.defaultElementNamespaceURI = default_namespace_uri;
        }

        public Context cloneContext() {
            try {
                Context clone_context = (Context)super.clone();
                clone_context.setNamespace(this.namespace.cloneNamespace());
                return clone_context;
            }
            catch (CloneNotSupportedException clone_exception) {
                logger.error("XmlWriter.Context.clone() : not supported.");
                return null;
            }
        }

        public final int getIndent() {
            return this.indent;
        }

        public final void setIndent(int indent) {
            this.indent = indent;
        }

        public final void setPreserveSpace(boolean preserve_space) {
            this.preserveSpace = preserve_space;
        }

        public final int getFilter() {
            return this.filter;
        }

        public final void setFilter(int filter) {
            this.filter = filter;
        }

        public final Namespace getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(Namespace namespace) {
            if (namespace == null) {
                namespace = new Namespace();
            }
            this.namespace = namespace;
        }

        public final String getDefaultElementNamespaceURI() {
            return this.defaultElementNamespaceURI;
        }

        public final void setDefaultElementNamespaceURI(String namespace_uri) {
            this.defaultElementNamespaceURI = namespace_uri;
        }
    }
}

