/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.value.Arithmetic;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;

class ArithmeticExpression
extends AbstractExpression {
    protected static int PLUS = 0;
    protected static int MINUS = 1;
    protected static int MULTIPLY = 2;
    protected static int DIVIDE = 3;
    protected static int MODULO = 4;
    private Expression leftOperand;
    private Expression rightOperand;
    private int operation;

    public ArithmeticExpression(Token token, Expression left_operand, int operation, Expression right_operand) {
        super("Arithmetic", token);
        this.leftOperand = left_operand;
        this.operation = operation;
        this.rightOperand = right_operand;
    }

    public String toString() {
        String operation_string = this.operation == PLUS ? "+" : (this.operation == MINUS ? "-" : (this.operation == MULTIPLY ? "*" : (this.operation == DIVIDE ? "div" : (this.operation == MODULO ? "mod" : "(unkown arithmetic operation #" + this.operation + ")"))));
        return "(" + this.leftOperand + " " + operation_string + " " + this.rightOperand + ")";
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence left_sequence = this.leftOperand.evaluate(context);
        if (left_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the left operand expression");
        }
        ValueArray left_array = left_sequence.atomize();
        if (left_array.length() == 0) {
            return new DrbDefaultSequence();
        }
        if (left_array.length() > 1) {
            throw new TypeException(this, "The sequence length of left operand is greater than one");
        }
        Value left_value = left_array.getElement(0);
        DrbSequence right_sequence = this.rightOperand.evaluate(context);
        if (right_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the right operand expression");
        }
        ValueArray right_array = right_sequence.atomize();
        if (right_array.length() == 0) {
            return new DrbDefaultSequence();
        }
        if (right_array.length() > 1) {
            throw new TypeException(this, "The sequence length of right operand is greater than one");
        }
        Value right_value = right_array.getElement(0);
        DrbDefaultSequence ouput_sequence = new DrbDefaultSequence();
        Value result = null;
        if (left_value instanceof Arithmetic) {
            if (this.operation == PLUS) {
                result = ((Arithmetic)((Object)left_value)).add(right_value);
            } else if (this.operation == MINUS) {
                result = ((Arithmetic)((Object)left_value)).sub(right_value);
            } else if (this.operation == MULTIPLY) {
                result = ((Arithmetic)((Object)left_value)).multiply(right_value);
            } else if (this.operation == DIVIDE) {
                try {
                    result = ((Arithmetic)((Object)left_value)).divide(right_value);
                }
                catch (ArithmeticException e) {
                    throw new DynamicException(this, e.getMessage());
                }
            } else if (this.operation == MODULO) {
                result = ((Arithmetic)((Object)left_value)).modulus(right_value);
            }
            if (result == null) {
                throw new TypeException(this, "Unable to perform operations.");
            }
            ouput_sequence.add(result);
            return ouput_sequence;
        }
        throw new TypeException(this, "Invalid type of left operand (" + left_value.getType() + ").");
    }

    @Override
    public boolean isConstant() {
        return this.leftOperand.isConstant() && this.rightOperand.isConstant();
    }
}

