/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.LiteralResult;
import fr.gael.drb.query.Token;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;

class GeneralCompExpression
extends AbstractExpression {
    protected static final int EQUALS = 0;
    protected static final int NOT_EQUALS = 1;
    protected static final int LESS_THAN = 2;
    protected static final int LESS_OR_EQUAL_TO = 3;
    protected static final int GREATER_THAN = 4;
    protected static final int GREATER_OR_EQUAL_TO = 5;
    protected Expression leftOperand;
    protected Expression rightOperand;
    protected int comparison;

    public GeneralCompExpression(Token token, Expression left_operand, int comparison, Expression right_operand) {
        super("General comparison", token);
        this.leftOperand = left_operand;
        this.comparison = comparison;
        this.rightOperand = right_operand;
    }

    public String toString() {
        String comparison_string;
        switch (this.comparison) {
            case 0: {
                comparison_string = "=";
                break;
            }
            case 1: {
                comparison_string = "!=";
                break;
            }
            case 2: {
                comparison_string = "<";
                break;
            }
            case 3: {
                comparison_string = "<=";
                break;
            }
            case 4: {
                comparison_string = ">";
                break;
            }
            case 5: {
                comparison_string = ">=";
                break;
            }
            default: {
                comparison_string = "(unkown comparison #" + this.comparison + ")";
            }
        }
        return this.leftOperand + " " + comparison_string + " " + this.rightOperand;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence leftSequence = this.leftOperand.evaluate(context);
        ValueArray leftArray = leftSequence.atomize();
        DrbSequence rightSequence = this.rightOperand.evaluate(context);
        ValueArray rightArray = rightSequence.atomize();
        for (int ileft = 0; ileft < leftArray.length(); ++ileft) {
            for (int iright = 0; iright < rightArray.length(); ++iright) {
                int comparisonResult;
                block12: {
                    block13: {
                        block10: {
                            block11: {
                                Value leftValue = leftArray.getElement(ileft);
                                if (!(leftValue instanceof Comparison)) continue;
                                comparisonResult = ((Comparison)((Object)leftValue)).compareTo(rightArray.getElement(iright));
                                if (comparisonResult >= 0) break block10;
                                if (this.comparison == 1) break block11;
                                if (this.comparison == 2) break block11;
                                if (this.comparison != 3) break block10;
                            }
                            return LiteralResult.TRUE;
                        }
                        if (comparisonResult != 0) break block12;
                        if (this.comparison == 0) break block13;
                        if (this.comparison == 3) break block13;
                        if (this.comparison != 5) break block12;
                    }
                    return LiteralResult.TRUE;
                }
                if (comparisonResult <= 0) continue;
                if (this.comparison != 1) {
                    if (this.comparison != 4) {
                        if (this.comparison != 5) continue;
                    }
                }
                return LiteralResult.TRUE;
            }
        }
        return LiteralResult.FALSE;
    }

    @Override
    public boolean isConstant() {
        return this.leftOperand.isConstant() && this.rightOperand.isConstant();
    }
}

