/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DefaultResult;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.PredicatsListExpression;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.Token;
import org.apache.log4j.Logger;

class GeneralStepExpression
extends AbstractExpression {
    private static Logger logger = Logger.getLogger(GeneralStepExpression.class);
    static final short CHILD_AXIS = 1;
    static final short DESCENDANT_AXIS = 2;
    static final short ATTRIBUTE_AXIS = 3;
    static final short SELF_AXIS = 4;
    static final short DESCENDANT_OR_SELF_AXIS = 5;
    static final short FOLLOWING_SIBLING_AXIS = 6;
    static final short FOLLOWING_AXIS = 7;
    static final short PARENT_AXIS = 8;
    static final short ANCESTOR_AXIS = 9;
    static final short PRECEDING_SIBLING_AXIS = 10;
    static final short PRECEDING_AXIS = 11;
    static final short ANCESTOR_OR_SELF_AXIS = 12;
    private PredicatsListExpression predicatsList;
    short axis;
    String name;
    Expression filter = null;
    Expression schema;
    GeneralStepExpression nextStep = null;
    boolean isAttributeStep = false;
    boolean isDescendantStep = false;

    GeneralStepExpression(Token token, String name, short axis, Expression schema) {
        super("Axis Step", token);
        this.name = name;
        this.axis = axis;
        this.schema = schema;
        this.filter = null;
    }

    public GeneralStepExpression(Expression filter) {
        super("Filter Step", filter.getToken());
        this.name = null;
        this.schema = null;
        this.axis = 1;
        this.filter = filter;
    }

    public void setPredicatsList(PredicatsListExpression predicatsList) {
        this.predicatsList = predicatsList;
    }

    public void setNextStep(GeneralStepExpression step) {
        this.nextStep = step;
    }

    public void setSchema(Expression schema) {
        this.schema = schema;
    }

    public void setIsAttributeStep(boolean flag) {
        this.isAttributeStep = flag;
        if (flag) {
            this.axis = (short)3;
        }
    }

    public void setIsDescendantStep(boolean flag) {
        this.isDescendantStep = flag;
    }

    private DrbSequence getDescendantOrSelf(DrbNode node, DrbDefaultSequence item_list) {
        item_list.addItem(node);
        int count = node.getChildrenCount();
        for (int ichild = 0; ichild < count; ++ichild) {
            this.getDescendantOrSelf(node.getChildAt(ichild), item_list);
        }
        return item_list;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        if (this.isDescendantStep) {
            DrbDefaultSequence item_list = new DrbDefaultSequence();
            DrbItem item = context.focus.getContextItem();
            if (item.getItemType() == 1) {
                DrbDefaultSequence descendant_or_self = new DrbDefaultSequence();
                this.getDescendantOrSelf((DrbNode)item, descendant_or_self);
                int descendant_count = descendant_or_self.getLength();
                for (int i = 0; i < descendant_count; ++i) {
                    DynamicContext inner_context = new DynamicContext(context);
                    inner_context.focus.setContextItem(descendant_or_self.getItem(i));
                    inner_context.focus.setContextPosition(i + 1);
                    inner_context.focus.setContextSize(descendant_count);
                    DrbSequence output_sequence = this.evaluateStep(inner_context);
                    for (int j = 0; j < output_sequence.getLength(); ++j) {
                        item_list.addItem(output_sequence.getItem(j));
                    }
                }
            }
            return item_list;
        }
        return this.evaluateStep(context);
    }

    private DrbSequence evaluateStep(DynamicContext context) {
        if (this.filter == null && this.name == null) {
            throw new DynamicException(this, "No name-test for general step");
        }
        DynamicContext inner_context = new DynamicContext(context);
        boolean case_of_wildcard = "*".equals(this.name);
        if (context == null) {
            throw new DynamicException(this, "Null dynamic context");
        }
        DrbItem item = context.focus.getContextItem();
        if (item == null) {
            throw new DynamicException(this, "Null context item");
        }
        if (item.getItemType() == 3) {
            return new DrbDefaultSequence(item);
        }
        DrbNode base_node = null;
        if (item.getItemType() == 1) {
            base_node = (DrbNode)item;
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        if (this.schema != null) {
            if (item.getItemType() != 1) {
                throw new DynamicException(this, "Cannot apply schema. The context item is not an element");
            }
            inner_context.focus.setContextItem(base_node.getParent());
            inner_context.focus.setContextPosition(1);
            inner_context.focus.setContextSize(1);
            DrbSequence schema_sequence = this.schema.evaluate(inner_context);
            if (schema_sequence == null) {
                throw new DynamicException(this, "Error while evaluating the schema expression");
            }
            if (schema_sequence.getLength() > 1) {
                throw new DynamicException(this, "The schema references to more than one item (" + schema_sequence.getLength() + ")");
            }
            if (schema_sequence.getLength() < 1) {
                throw new DynamicException(this, "The schema references no element");
            }
            DrbItem schema_item = schema_sequence.getItem(0);
            if (schema_item == null) {
                throw new DynamicException(this, "The schema item is null");
            }
            if (schema_item.getItemType() != 1) {
                throw new DynamicException(this, "The schema item is not an element");
            }
            DrbNode schema_node = (DrbNode)schema_item;
            try {
                DrbNodeSpi spi_node = new DrbNodeSpi(base_node);
                spi_node.setSchema(schema_node);
                base_node = spi_node.getFirstChild();
                item = base_node;
            }
            catch (Exception exception) {
                throw new DynamicException(this, "Error while openning node with respect to the schema \"" + schema_node + "\" (" + exception.getMessage() + ")", exception);
            }
        }
        DrbDefaultSequence item_list = new DrbDefaultSequence();
        if (this.isAttributeStep) {
            if (item.getItemType() == 3) {
                throw new DynamicException(this, "XP0020 - Context item is not a node");
            }
            if (item.getItemType() != 1) {
                return output_sequence;
            }
            if (case_of_wildcard) {
                DrbAttributeList attribute_list = base_node.getAttributes();
                if (attribute_list != null) {
                    for (int iattrb = 0; iattrb < attribute_list.getLength(); ++iattrb) {
                        DrbAttribute attribute = attribute_list.item(iattrb);
                        if (attribute == null || attribute.getName() == null) {
                            logger.warn("The attribute #" + (iattrb + 1) + " of context node (" + base_node + ") is null or has  null name.");
                        }
                        output_sequence.add(attribute);
                    }
                }
            } else {
                DrbAttribute attribute = base_node.getAttribute(this.name);
                if (attribute != null) {
                    output_sequence.add(attribute);
                }
            }
            if (this.predicatsList.isEmpty()) {
                item_list = output_sequence;
            } else {
                int attr_count = output_sequence.getLength();
                for (int iattrb = 0; iattrb < attr_count; ++iattrb) {
                    DrbItem attr = output_sequence.getItem(iattrb);
                    inner_context.focus.setContextItem(attr);
                    inner_context.focus.setContextPosition(iattrb + 1);
                    inner_context.focus.setContextSize(attr_count);
                    if (!Query.getEffectiveBooleanValue(this.predicatsList.evaluate(inner_context))) continue;
                    item_list.addItem(attr);
                }
            }
            output_sequence = new DrbDefaultSequence();
        } else if (this.name != null) {
            if (item.getItemType() == 3) {
                throw new DynamicException(this, "XPTY0020 - Context item is not a node");
            }
            if (this.axis == 4) {
                if (this.name.equals(".")) {
                    item_list.addItem(item);
                } else if (item.getItemType() == 1) {
                    if (this.name.equals(((DrbNode)item).getName())) {
                        item_list.addItem(item);
                    }
                } else if (item.getItemType() == 2) {
                    if (this.name.equals(((DrbAttribute)item).getName())) {
                        item_list.addItem(item);
                    }
                } else {
                    throw new DynamicException(this, "XPTY0020 - Context item is not an element nor an attribute");
                }
                if (this.nextStep == null) {
                    return item_list;
                }
            } else {
                if (this.axis == 8) {
                    DrbNode parent_node = null;
                    if (item.getItemType() == 1) {
                        parent_node = base_node.getParent();
                    } else if (item.getItemType() == 2) {
                        parent_node = ((DrbAttribute)item).getOwner();
                    } else if (item.getItemType() == 3) {
                        throw new DynamicException(this, "XPTY0020 - Context item is not a node");
                    }
                    if (parent_node != null && !case_of_wildcard && !this.name.equals(parent_node.getName())) {
                        parent_node = null;
                    }
                    if (this.nextStep != null) {
                        inner_context.focus.setContextItem(parent_node);
                        inner_context.focus.setContextPosition(1);
                        inner_context.focus.setContextSize(1);
                        return this.nextStep.evaluate(inner_context);
                    }
                    if (parent_node != null) {
                        item_list.addItem(parent_node);
                    }
                    return item_list;
                }
                if (base_node == null) {
                    return output_sequence;
                }
                int[] positions = new int[2];
                if (!this.predicatsList.getEvaluationLimit(context, positions)) {
                    return output_sequence;
                }
                Integer min_position = positions[0];
                Integer max_position = positions[1];
                if (min_position == Integer.MAX_VALUE) {
                    min_position = 1;
                }
                if (max_position == Integer.MIN_VALUE) {
                    max_position = Integer.MAX_VALUE;
                }
                DrbNode test_node = null;
                try {
                    if (base_node != null) {
                        test_node = case_of_wildcard ? base_node.getChildAt(min_position - 1) : base_node.getNamedChild(this.name, 1);
                    }
                }
                catch (Exception exception) {
                    throw new DynamicException(this, "Cannot assess if current child is an array (" + exception.getMessage() + ")", exception);
                }
                DrbNode node = null;
                int position = min_position - 1;
                DynamicContext.Size children_count = new DynamicContext.Size(0);
                final DrbNode contextNode = base_node;
                try {
                    children_count = new DynamicContext.Size(){

                        @Override
                        protected int getSize() {
                            return contextNode.getChildrenCount();
                        }
                    };
                }
                catch (Exception exception) {
                    throw new DynamicException(this, "Cannot count children of node \"" + base_node + "\" (" + exception.getMessage() + ")");
                }
                while (++position <= max_position) {
                    if (min_position == 1 && test_node != null) {
                        node = test_node;
                        test_node = null;
                    } else {
                        try {
                            node = case_of_wildcard ? base_node.getChildAt(position - 1) : base_node.getNamedChild(this.name, position);
                        }
                        catch (Exception exception) {
                            throw new DynamicException(this, "Cannot get child of node \"" + base_node + "\" at position " + position + " (" + exception.getMessage() + ")");
                        }
                    }
                    if (node == null) break;
                    inner_context.focus.setContextItem(node);
                    inner_context.focus.setContextPosition(position);
                    inner_context.focus.setContextSize(children_count);
                    if (Query.getEffectiveBooleanValue(this.predicatsList.evaluate(inner_context))) {
                        item_list.addItem(node);
                    }
                    if (node != null) continue;
                }
            }
        }
        if (this.name != null || this.filter != null) {
            if (this.filter != null) {
                item_list = new DrbDefaultSequence(this.filter.evaluate(context));
            }
            if (this.nextStep != null) {
                DefaultResult results = new DefaultResult();
                for (int inode = 0; inode < item_list.getLength(); ++inode) {
                    inner_context.focus.setContextItem(item_list.getItem(inode));
                    inner_context.focus.setContextPosition(inode + 1);
                    inner_context.focus.setContextSize(item_list.getLength());
                    DrbSequence sub_result = this.nextStep.evaluate(inner_context);
                    if (sub_result == null) {
                        throw new DynamicException(this, "Error while evaluating next step: " + this.nextStep);
                    }
                    results.append(sub_result);
                }
                return results;
            }
            output_sequence = item_list;
        }
        return output_sequence;
    }

    public String toString() {
        String output = "";
        if (this.schema != null) {
            output = "(" + this.schema + ")";
        }
        output = this.name != null ? output + this.name + this.predicatsList : output + this.filter;
        return output;
    }
}

