/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbDefaultMetadataResolver;
import fr.gael.drb.impl.sds.SdfFactory;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.query.CancelException;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Environment;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.ExternalVariable;
import fr.gael.drb.query.ParameterResolver;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.QueryParser;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.StaticContext;
import fr.gael.drb.query.StaticException;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.query.Variable;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAnnotation;
import fr.gael.drb.xsd.XsdAttribute;
import fr.gael.drb.xsd.XsdAttributeGroup;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdDocumentation;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Query {
    private static Logger logger = Logger.getLogger(Query.class);
    private QueryParser parser = new QueryParser();
    private StaticContext context;
    private Expression body;
    private boolean isRunningEvaluation = false;

    public Query(String query_string) throws StaticException, TypeException {
        this(query_string, new StaticContext());
    }

    public Query(InputStream stream) throws StaticException, TypeException {
        this(stream, new StaticContext());
    }

    public Query(String query_string, Environment environment) throws StaticException, TypeException {
        this(query_string, new StaticContext(environment));
    }

    protected Query(String query_string, StaticContext static_context) throws StaticException, TypeException {
        this.context = new StaticContext(static_context);
        this.body = this.parser.parse(new StringReader(query_string), this.context);
    }

    public Query(InputStream stream, Environment environment) throws StaticException, TypeException {
        this(stream, new StaticContext(environment));
    }

    protected Query(InputStream stream, StaticContext static_context) throws StaticException, TypeException {
        this.context = new StaticContext(static_context);
        this.body = this.parser.parse(stream, this.context);
    }

    public Environment getEnvironment() {
        return this.context;
    }

    public ExternalVariable[] getExternalVariables() {
        if (this.context != null) {
            return this.context.getExternalVariables();
        }
        return null;
    }

    public boolean isUpdating() {
        return this.body.isUpdating();
    }

    public DrbSequence evaluate(DrbItem context_item, int context_position, int context_size) throws DynamicException, TypeException, CancelException {
        if (this.body == null) {
            throw new DynamicException(null, "No \"body\" expression to evaluate");
        }
        if (context_size < 0 || context_position > context_size) {
            throw new DynamicException(null, "Invalid initial context (position=" + context_position + " size=" + context_size + ")");
        }
        DynamicContext dynamic_context = new DynamicContext(this.context);
        dynamic_context.focus.setContextPosition(context_position);
        dynamic_context.focus.setContextSize(context_size);
        if (context_item != null) {
            dynamic_context.focus.setContextItem(context_item);
        }
        this.isRunningEvaluation = true;
        DrbSequence result = null;
        for (Variable variable : dynamic_context.getInScopeVariables()) {
            variable.initialize(dynamic_context);
        }
        try {
            result = this.body.evaluate(dynamic_context);
        }
        catch (CancelException cancel_exception) {
            this.isRunningEvaluation = false;
            throw new CancelException(cancel_exception.getMessage());
        }
        return result;
    }

    public DrbSequence evaluate(DrbItem context_item) throws DynamicException, TypeException, CancelException {
        return this.evaluate(context_item, 1, 1);
    }

    public synchronized boolean cancel(String reason) {
        if (this.isRunningEvaluation) {
            this.body.cancel(reason);
            return true;
        }
        return false;
    }

    public DrbNodeList eval() {
        return this.eval(null, null);
    }

    public DrbNodeList eval(ParameterResolver resolver) {
        return this.eval(null, resolver);
    }

    public DrbNodeList eval(DrbNode context_node) {
        return this.eval(context_node, null);
    }

    public DrbNodeList eval(DrbNode context_node, ParameterResolver resolver) {
        this.context.resolver = resolver;
        DrbSequence sequence = this.evaluate(context_node);
        DrbDefaultNodeList output_node_list = new DrbDefaultNodeList();
        for (int iitem = 0; iitem < sequence.getLength(); ++iitem) {
            DrbItem item = sequence.getItem(iitem);
            DrbNode output_node = null;
            if (item.getItemType() == 1) {
                output_node = (DrbNode)item;
            } else if (item.getItemType() == 3) {
                output_node = new DrbDefaultMutableNode(null);
                output_node.setValue((Value)item);
            } else {
                logger.warn("Deprecated eval() implementation does not support attrbiute in output.");
                continue;
            }
            output_node_list.addItem(output_node_list.getLength(), output_node);
        }
        return output_node_list;
    }

    public static boolean getEffectiveBooleanValue(DrbSequence sequence) {
        if (sequence == null || sequence.getLength() == 0) {
            return false;
        }
        if (sequence.getLength() == 1) {
            DrbItem item = sequence.getItem(0);
            if (item != null) {
                Value value = item.getValue();
                if (value != null && (value.getType() == 0 && !((Boolean)value).booleanValue() || value.getType() == 7 && ((fr.gael.drb.value.String)value).toString().length() == 0 || value instanceof Numeric && ((Numeric)value).doubleValue() == 0.0 || value.getType() == 6 && (((Numeric)value).doubleValue() == Double.NaN || ((Numeric)value).doubleValue() == Double.POSITIVE_INFINITY || ((Numeric)value).doubleValue() == Double.NEGATIVE_INFINITY) || value.getType() == 5 && (((Numeric)value).floatValue() == Float.NaN || ((Numeric)value).floatValue() == Float.POSITIVE_INFINITY || ((Numeric)value).floatValue() == Float.NEGATIVE_INFINITY))) {
                    return false;
                }
            } else {
                throw new NullPointerException("The item of a singleton sequence shall never be null");
            }
        }
        return true;
    }

    public static String usage() {
        String message = "Usage:\n\njava fr.gael.drb.query.Query [options]\n\nThis command evaluates the XQuery script provided as a string or\na file. The output of the evaluation is printed out in the\nstandard output. The output format may have several forms\naccording to the resulting sequence. Basically the resulting\nnodes are output as XML fragments, the attributes not attached\nto nodes are written as in XML but prefixed with '@' symbol and\nfianlly, the atomic values are printed without decoration, \naccording to the XML Schema lexical space definitions. All items\nof the output sequence are comma separated. A '()' result dennotes\nthe empty sequence.\n\nThe warning or error are printed in the log4j logger (c.f.\nhttp://logging.apache.org/log4j/docs/index.html for detailed\ninformation of the logging system).\n\n[ [-s | --query] <xquery_string> ]\n\n   Command line string to be evaluated as XQuery script.\n   This parameter cannot be used jointly with -f. At least -s\n   or -f is to be set.\n\n[ [-f | --query-file] <xquery_file> ]\n\n   Path to a file containing the sctript to be evaluated. This\n   parameter cannot be used jointly with -s. At least -f or -s is\n   to be set.\n\n[ -variable <QName> <value> [ as <type> ]]\n\n   Pushses an external variable in the environment prior to parse\n   and evaluate the XQuery script.  The variable is pushed in the\n   the environment altough it has not been declared has an\n   external variable, to provide it to the potential nested\n   XQuerys (e.g. a call to evaluate-uri() built-in function).\n   <QName> is the qualified name of the variable to declare\n   whether <value> is a string to bind as value of the variable.\n   If <QName> matches a typed external variable declared in the\n   script, <value> is converted to that type before being bound.\n   The trailing \"as <type>\" is optional and shall follow the\n   XQuery sequence type declaration (e.g. as xs:integer+ ).\n\n[[ -help | --help | -h ] [subject [name]]]\n\n   If no [subject] is specified then prints out the present help\n   message. This parameter overides all others.\n   [subject] can be one of the following:\n     'impl'      : Prints out the available implementations\n     'sdf' [name]: Prints out the available sdf tags\n                   If a [name] is specify then try to display\n                   the detailed information about the specified\n                   tag\n     'xql' [name]: Prints out the available XQuery functions\n                   If a [name] is specify then try to display\n                   the detailed information about all matching\n                   XQuery functions\n     'xsd'       : Prints the supported XML Schema version\n\n[ -v | --version ]\n\n   Prints out the current version of the CLI. This parameter \n   overides all others apart the help trigger.\n\nIt is assumed that DRB classpath and dependecies are correctly\nconfigured.\n";
        return "Usage:\n\njava fr.gael.drb.query.Query [options]\n\nThis command evaluates the XQuery script provided as a string or\na file. The output of the evaluation is printed out in the\nstandard output. The output format may have several forms\naccording to the resulting sequence. Basically the resulting\nnodes are output as XML fragments, the attributes not attached\nto nodes are written as in XML but prefixed with '@' symbol and\nfianlly, the atomic values are printed without decoration, \naccording to the XML Schema lexical space definitions. All items\nof the output sequence are comma separated. A '()' result dennotes\nthe empty sequence.\n\nThe warning or error are printed in the log4j logger (c.f.\nhttp://logging.apache.org/log4j/docs/index.html for detailed\ninformation of the logging system).\n\n[ [-s | --query] <xquery_string> ]\n\n   Command line string to be evaluated as XQuery script.\n   This parameter cannot be used jointly with -f. At least -s\n   or -f is to be set.\n\n[ [-f | --query-file] <xquery_file> ]\n\n   Path to a file containing the sctript to be evaluated. This\n   parameter cannot be used jointly with -s. At least -f or -s is\n   to be set.\n\n[ -variable <QName> <value> [ as <type> ]]\n\n   Pushses an external variable in the environment prior to parse\n   and evaluate the XQuery script.  The variable is pushed in the\n   the environment altough it has not been declared has an\n   external variable, to provide it to the potential nested\n   XQuerys (e.g. a call to evaluate-uri() built-in function).\n   <QName> is the qualified name of the variable to declare\n   whether <value> is a string to bind as value of the variable.\n   If <QName> matches a typed external variable declared in the\n   script, <value> is converted to that type before being bound.\n   The trailing \"as <type>\" is optional and shall follow the\n   XQuery sequence type declaration (e.g. as xs:integer+ ).\n\n[[ -help | --help | -h ] [subject [name]]]\n\n   If no [subject] is specified then prints out the present help\n   message. This parameter overides all others.\n   [subject] can be one of the following:\n     'impl'      : Prints out the available implementations\n     'sdf' [name]: Prints out the available sdf tags\n                   If a [name] is specify then try to display\n                   the detailed information about the specified\n                   tag\n     'xql' [name]: Prints out the available XQuery functions\n                   If a [name] is specify then try to display\n                   the detailed information about all matching\n                   XQuery functions\n     'xsd'       : Prints the supported XML Schema version\n\n[ -v | --version ]\n\n   Prints out the current version of the CLI. This parameter \n   overides all others apart the help trigger.\n\nIt is assumed that DRB classpath and dependecies are correctly\nconfigured.\n";
    }

    public static String helpMsgFor(String subject, String name) {
        String message = null;
        if ("xql".equalsIgnoreCase(subject)) {
            String xqlDocFile = "doc/query_functions.xml";
            URL xql_url = Query.class.getClassLoader().getResource("doc/query_functions.xml");
            DrbNode myNode = DrbFactory.openURI(xql_url + "");
            DrbNode dataRootNode = myNode.getFirstChild();
            if (name != null) {
                DrbSequence mySequence;
                String xqlQueryFunctionsList = "doc/list_function.xql";
                InputStream xql_script_is = Query.class.getClassLoader().getResourceAsStream("doc/list_function.xql");
                Query query = new Query(xql_script_is);
                ExternalVariable[] extVariables = query.getExternalVariables();
                if (extVariables != null) {
                    for (int iext = 0; iext < extVariables.length; ++iext) {
                        ExternalVariable var = extVariables[iext];
                        String varName = var.getName();
                        if (varName.equals("func_pattern")) {
                            var.setValue(new fr.gael.drb.value.String(name));
                            continue;
                        }
                        logger.warn("Unexpected external variable in internal script file: doc/list_function.xql");
                    }
                }
                if ((mySequence = query.evaluate(myNode)).getLength() == 0) {
                    message = "No match found for pattern '" + name + "'";
                } else {
                    message = "";
                    String plural = mySequence.getLength() > 1 ? "s" : "";
                    message = message + "Pattern '" + name + "' match " + mySequence.getLength() + " function" + plural + ":\n\n";
                    for (int iitem = 0; iitem < mySequence.getLength(); ++iitem) {
                        DrbItem myItem = mySequence.getItem(iitem);
                        message = message + myItem.toString().replaceAll("\\\\n", "\n") + "\n\n";
                    }
                }
            } else {
                DrbNodeList fntList = dataRootNode.getChildren();
                if (fntList.getLength() >= 1) {
                    message = "";
                }
                for (int ifnt = 0; ifnt < fntList.getLength(); ++ifnt) {
                    DrbNode fntNode = fntList.item(ifnt);
                    Value supported_val = fntNode.getAttribute("supported").getValue();
                    boolean supported = java.lang.Boolean.parseBoolean(supported_val + "");
                    String supported_str = "";
                    if (!supported) {
                        supported_str = "[NOT SUPPORTED] ";
                    }
                    String deprecated_str = "";
                    if (fntNode.getNamedChild("deprecated", 1) != null) {
                        deprecated_str = "[DEPRECATED] ";
                    }
                    String fntSignature = fntNode.getNamedChild("signature", 1).getValue() + "";
                    message = message + supported_str + deprecated_str + fntSignature + "\n";
                }
            }
        } else if ("impl".equalsIgnoreCase(subject)) {
            message = "Implementation list:\n";
            Hashtable<String, String> extensionHash = DrbDefaultMetadataResolver.getExtensionHash();
            message = message + "  MIME Type -> DRB implementation:\n";
            Enumeration<String> keys = extensionHash.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                message = message + "  ." + key + " -> " + extensionHash.get(key) + "\n";
            }
        } else if ("sdf".equalsIgnoreCase(subject)) {
            message = "Current SDF namespace is: \"" + SdfFactory.getDefaultVersion() + "\"\n";
            String xsdFile = "xsd/sdf-2_3.xsd";
            URL xsd_url = Query.class.getClassLoader().getResource("xsd/sdf-2_3.xsd");
            DrbNode myNode = DrbFactory.openURI(xsd_url + "");
            XmlSchema mySchema = new XsdFactory().open(myNode.getFirstChild());
            if (name != null) {
                boolean found = false;
                XsdElement[] rootElts = mySchema.getRootElements();
                for (int i_root = 0; i_root < rootElts.length; ++i_root) {
                    XsdElement xsdElt = rootElts[i_root];
                    XsdType type = xsdElt.getType();
                    XsdComplexType structure = type.getStructure();
                    XsdModelGroup mg = structure.getComplexContent();
                    XsdParticle part = null;
                    String indent = "";
                    if (xsdElt.getName().equals(name)) {
                        part = xsdElt;
                        found = true;
                    } else {
                        for (int i = 0; i < mg.getLength(); ++i) {
                            XsdParticle tmpPart = mg.getParticle(i);
                            XsdElement tmpElt = (XsdElement)tmpPart;
                            if (!tmpElt.getName().equals(name)) continue;
                            part = tmpPart;
                            found = true;
                            indent = "   ";
                        }
                    }
                    if (part == null) continue;
                    message = message + "\nDetail tag content: (from sdf:" + xsdElt.getName() + ")\n------------------\n\n";
                    message = message + Query.getDocRecursive(part, indent, true);
                }
                if (!found) {
                    message = "No match found for SDF tag '" + name + "'";
                }
            } else {
                int i;
                XsdDocumentation[] mySchemaDocs;
                XsdAnnotation mySchemaAnnot = mySchema.getAnnotation();
                if (mySchemaAnnot != null && (mySchemaDocs = mySchemaAnnot.getDocumentations()) != null && mySchemaDocs.length >= 1) {
                    message = message + "\nNote:\n";
                    for (i = 0; i < mySchemaDocs.length; ++i) {
                        message = message + "       " + mySchemaDocs[i].getContent() + "\n";
                    }
                }
                message = message + "\nSupported SDF tags:\n------------------\n";
                XsdElement[] rootElts = mySchema.getRootElements();
                for (i = 0; i < rootElts.length; ++i) {
                    message = message + "\n" + Query.getDocRecursive(rootElts[i], "", false);
                }
            }
        } else if ("xsd".equalsIgnoreCase(subject)) {
            message = "Current XML Schema namespace: \"http://www.w3.org/2001/XMLSchema\"\nNote that some restrictions may occurred; please contact drb-support@gael.fr for details\n";
        }
        return message;
    }

    private static String getDocumentation(XsdAnnotation annot) {
        XsdDocumentation[] docs;
        String doc = "";
        if (annot != null && (docs = annot.getDocumentations()) != null && docs.length >= 1) {
            for (int i = 0; i < docs.length; ++i) {
                DrbSequence tmp = docs[i].getContent();
                if (tmp == null) continue;
                doc = doc + tmp + "\n";
            }
        }
        return doc;
    }

    private static String getSchemaParticleDocumentation(XsdParticle xsdPart) {
        XsdAnnotation annot = xsdPart.getAnnotation();
        return Query.getDocumentation(annot);
    }

    private static String getDocRecursive(XsdParticle xsdPart, String indent, boolean detailed) {
        XsdComplexType structure;
        XsdAttributeGroup attGrp;
        String msg = "";
        if (xsdPart.getTerm() != 2) {
            return "";
        }
        XsdElement xsdElt = (XsdElement)xsdPart;
        XsdType type = xsdElt.getType();
        String att_str = "";
        String doc_att = "";
        if (type.isComplex() && (attGrp = (structure = type.getStructure()).getAttributeGroup()) != null) {
            XsdAttribute[] xsdAtts = attGrp.getContent();
            for (int i = 0; i < xsdAtts.length; ++i) {
                att_str = att_str + " " + xsdAtts[i].getName() + "=\"\"";
                doc_att = doc_att + "\n" + indent + "   @" + xsdAtts[i].getName() + ":\n" + indent + "         " + Query.getDocumentation(xsdAtts[i].getAnnotation());
            }
        }
        msg = msg + indent + "<sdf:" + xsdElt.getName() + att_str;
        String doc = "";
        if (detailed) {
            doc = Query.getSchemaParticleDocumentation(xsdPart);
            doc = doc + doc_att + "\n";
        }
        boolean hasChild = false;
        XsdComplexType structure2 = null;
        XsdModelGroup mg = null;
        if (type.isComplex() && (mg = (structure2 = type.getStructure()).getComplexContent()).getLength() > 0) {
            hasChild = true;
        }
        if (hasChild) {
            msg = msg + ">\n";
            if (doc != "") {
                msg = msg + indent + "         " + doc;
            }
            for (int i = 0; i < mg.getLength(); ++i) {
                XsdParticle part = mg.getParticle(i);
                msg = msg + Query.getDocRecursive(part, indent + "   ", detailed);
            }
            msg = msg + indent + "</sdf:" + xsdElt.getName() + ">\n";
        } else {
            msg = msg + "/>\n";
            if (doc != "") {
                msg = msg + indent + "         " + doc;
            }
        }
        return msg;
    }

    public static void main(String[] args) {
        int iarg;
        String xquery_string = null;
        String xquery_file_name = null;
        FileInputStream xquery_file = null;
        Vector<String> variable_name = new Vector<String>();
        Vector<DrbSequence> variable_value = new Vector<DrbSequence>();
        Vector<SequenceType> variable_type = new Vector<SequenceType>();
        boolean argument_error = false;
        boolean display_usage = false;
        for (iarg = 0; iarg < args.length; ++iarg) {
            if (!args[iarg].equals("-help") && !args[iarg].equals("--help") && !args[iarg].equals("-h")) continue;
            if (iarg + 1 < args.length && !args[iarg + 1].startsWith("-")) {
                String helpMsg;
                String name = null;
                if (iarg + 2 < args.length && !args[iarg + 2].startsWith("-")) {
                    name = args[iarg + 2];
                }
                if ((helpMsg = Query.helpMsgFor(args[iarg + 1], name)) == null) {
                    logger.error("Invalid subject '" + args[iarg + 1] + "' for detailed help!");
                    return;
                }
                System.out.println(helpMsg);
                return;
            }
            System.out.println(Query.usage());
            return;
        }
        for (iarg = 0; iarg < args.length; ++iarg) {
            if (!args[iarg].equals("-v") && !args[iarg].equals("--version")) continue;
            Package drb_package = Query.class.getPackage();
            System.out.println(drb_package.getImplementationTitle() + " - " + drb_package.getImplementationVersion() + " (" + drb_package.getImplementationVendor() + ")");
            return;
        }
        for (iarg = 0; iarg < args.length; ++iarg) {
            if (args[iarg].equals("-s") || args[iarg].equals("--query")) {
                if (iarg >= args.length - 1) {
                    logger.error("\"-s\" option shall be followed by an argument.");
                    display_usage = true;
                    argument_error = true;
                    continue;
                }
                xquery_string = args[++iarg];
                continue;
            }
            if (args[iarg].equals("-f") || args[iarg].equals("--query-file")) {
                if (xquery_file != null) {
                    logger.error("The file \"" + xquery_file_name + "\" has already been provided as XQuery script.");
                    argument_error = true;
                }
                if (xquery_string != null) {
                    logger.error("A string has already been provided as XQuery script.");
                    argument_error = true;
                }
                if (iarg >= args.length - 1) {
                    logger.error("\"-f\" option shall be followed by a file name.");
                    display_usage = true;
                    argument_error = true;
                    continue;
                }
                ++iarg;
                try {
                    xquery_file = new FileInputStream(args[iarg]);
                }
                catch (FileNotFoundException exception) {
                    logger.error(exception.getMessage());
                    argument_error = true;
                }
                xquery_file_name = args[iarg];
                continue;
            }
            if (args[iarg].equals("-variable")) {
                if (iarg >= args.length - 2) {
                    logger.error("\"-variable\" option shall be followed by a qualified name and a value (not enougth arguments).");
                    display_usage = true;
                    argument_error = true;
                    continue;
                }
                if (variable_name.contains(args[++iarg])) {
                    logger.error("Variable \"" + args[iarg] + "\" already declared.");
                    argument_error = true;
                    continue;
                }
                variable_name.add(args[iarg]);
                fr.gael.drb.value.String value_string = new fr.gael.drb.value.String(args[++iarg]);
                SequenceType sequence_type = null;
                if (iarg < args.length - 2 && args[iarg + 1].equals("as")) {
                    int occurence_indicator = 0;
                    String type_name = args[iarg += 2];
                    if (args[iarg].endsWith("?")) {
                        occurence_indicator = 1;
                        type_name = args[iarg].substring(0, args[iarg].indexOf(63));
                    } else if (args[iarg].endsWith("+")) {
                        occurence_indicator = 3;
                        type_name = args[iarg].substring(0, args[iarg].indexOf(43));
                    } else if (args[iarg].endsWith("*")) {
                        occurence_indicator = 2;
                        type_name = args[iarg].substring(0, args[iarg].indexOf(42));
                    }
                    sequence_type = new SequenceType(type_name, occurence_indicator);
                } else {
                    sequence_type = new SequenceType("xs:string", 3);
                }
                variable_type.add(sequence_type);
                variable_value.add(sequence_type.convert(new DrbDefaultSequence(value_string)));
                continue;
            }
            logger.warn("Unsupported argument \"" + args[iarg] + "\" (Ignored).");
        }
        if (xquery_string == null && xquery_file == null) {
            logger.error("No XQuery script specified (\"-s\" or \"-f\" options).");
            display_usage = true;
            argument_error = true;
        }
        if (display_usage) {
            logger.error("Use the \"-h\" or \"--help\" option for a detailed specification of the parameters.");
        }
        if (argument_error) {
            Runtime.getRuntime().exit(1);
        }
        Query query = null;
        try {
            if (xquery_file != null) {
                Environment env = new Environment();
                env.setBaseURI(new File(xquery_file_name).toURI().toString());
                query = new Query(xquery_file, env);
            } else {
                query = new Query(xquery_string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error(exception.getMessage());
            Runtime.getRuntime().exit(1);
        }
        DrbNode root_node = DrbFactory.openURI(".");
        Environment environment = query.getEnvironment();
        for (int ivar = 0; ivar < variable_name.size(); ++ivar) {
            QName name = environment.resolveQName((String)variable_name.get(ivar));
            ExternalVariable external_variable = environment.getExternalVariable(name);
            if (external_variable == null) {
                external_variable = new ExternalVariable(name, (SequenceType)variable_type.get(ivar), null);
                environment.addExternalVariable(external_variable);
            }
            external_variable.setValue((DrbSequence)variable_value.get(ivar));
        }
        DrbSequence result = null;
        try {
            result = query.evaluate(root_node);
        }
        catch (Throwable exception) {
            logger.error(exception.getMessage());
            exception.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
        for (int iitem = 0; iitem < result.getLength(); ++iitem) {
            DrbItem item = result.getItem(iitem);
            if (iitem != 0) {
                System.out.print(", ");
            }
            if (item.getItemType() == 1) {
                XmlWriter.writeXML((DrbNode)item, System.out, null, false);
                continue;
            }
            System.out.print(item);
        }
        System.out.println();
    }
}

