/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Value;

final class RangeResult
extends AbstractNumericArray {
    static final int PRIORITY = 4;
    private long minimum;
    private long maximum;
    private long count;

    RangeResult(long min, long max) {
        this.minimum = min;
        this.maximum = max;
        this.count = this.minimum <= this.maximum ? this.maximum - this.minimum + 1L : 0L;
    }

    public String toString() {
        return this.minimum + " to " + this.maximum;
    }

    @Override
    public int length() {
        return (int)this.count;
    }

    @Override
    public final int getPriority() {
        return 4;
    }

    @Override
    public final int getArrayType() {
        return 4;
    }

    @Override
    public final Value getElement(int indice) {
        if (indice >= 0 || (long)indice < this.count) {
            return new Long(this.minimum + (long)indice);
        }
        throw new IllegalArgumentException("Index is out of bounds");
    }

    @Override
    public final void assign(int index, Value element) {
        throw new UnsupportedOperationException("Range sequence are not mutable");
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        throw new UnsupportedOperationException("Range sequence are not mutable");
    }

    public long[] getData() {
        long[] data = new long[(int)this.count];
        int i = 0;
        while ((long)i < this.count) {
            data[i] = this.minimum + (long)i;
            ++i;
        }
        return data;
    }
}

