/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.value.AbstractValue;
import fr.gael.drb.value.BooleanArray;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DefaultValueArray;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.ShortArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByteArray;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.UnsignedLongArray;
import fr.gael.drb.value.UnsignedShortArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;

public abstract class AbstractValueArray
extends AbstractValue
implements ValueArray,
Comparison {
    @Override
    public Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        if (this.getLength() == 1) {
            return this.getElement(0).convertTo(type);
        }
        throw new ClassCastException();
    }

    public ValueArray convertArrayTo(int array_type) throws ClassCastException {
        if (array_type == this.getArrayType()) {
            return this;
        }
        AbstractValueArray target_array = null;
        switch (array_type) {
            case 3: {
                target_array = new IntArray(new int[this.length()]);
                break;
            }
            case 6: {
                target_array = new DoubleArray(new double[this.length()]);
                break;
            }
            case 5: {
                target_array = new FloatArray(new float[this.length()]);
                break;
            }
            case 4: {
                target_array = new LongArray(new long[this.length()]);
                break;
            }
            case 2: {
                target_array = new ShortArray(new short[this.length()]);
                break;
            }
            case 1: {
                target_array = new ByteArray(new byte[this.length()]);
                break;
            }
            case 0: {
                target_array = new BooleanArray(new boolean[this.length()]);
                break;
            }
            case 15: {
                target_array = new UnsignedLongArray(new long[this.length()]);
                break;
            }
            case 14: {
                target_array = new UnsignedIntArray(new int[this.length()]);
                break;
            }
            case 13: {
                target_array = new UnsignedShortArray(new short[this.length()]);
                break;
            }
            case 12: {
                target_array = new UnsignedByteArray(new byte[this.length()]);
                break;
            }
            default: {
                throw new ClassCastException(this.getClass().getName() + ": cannot cast to " + array_type);
            }
        }
        for (int i = 0; i < this.length(); ++i) {
            target_array.assign(i, this.getElement(i).convertTo(array_type));
        }
        return target_array;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        if (value == null) {
            return this.length();
        }
        ValueArray value_array = (ValueArray)value.convertTo(10);
        int minLength = Math.min(this.length(), value_array.length());
        for (int i = 0; i < minLength; ++i) {
            int cmp = ((Comparison)((Object)this.getElement(i))).compareTo(value_array.getElement(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.length() - value_array.length();
    }

    @Override
    public DrbItem getItem(int index) {
        try {
            return this.getElement(index);
        }
        catch (IndexOutOfBoundsException exception) {
            return null;
        }
    }

    @Override
    public ValueArray atomize() {
        return this;
    }

    @Override
    public int getLength() {
        return this.length();
    }

    @Override
    public DrbSequence addItem(int index, DrbItem item) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException("AbstractValueArray.addItem: operation not yet support.");
    }

    @Override
    public DrbSequence removeItem(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractValueArray.removeItem: operation not yet support.");
    }

    public static void main(java.lang.String[] args) {
        DefaultValueArray array = new DefaultValueArray(args.length);
        for (int i = 0; i < args.length; ++i) {
            array.assign(i, new String(args[i]));
        }
        ValueArray array_2 = array.convertArrayTo(3);
        System.out.println("Converted Array: " + array_2);
    }
}

