/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.text.DecimalFormat;

public class Byte
extends AbstractNumeric
implements ValueFormat {
    public static final int PRIORITY = 1;
    protected byte value;

    public Byte(byte v) {
        this.value = v;
    }

    public Byte(int v) {
        this.value = (byte)v;
    }

    public String toString() {
        return java.lang.Byte.toString(this.value);
    }

    @Override
    public String getFormattedString(int length) {
        return Byte.getFormattedString(length, this.value, true);
    }

    @Override
    public byte[] getFormattedBuffer() {
        return Byte.getFormattedBuffer(this.value);
    }

    public static String getFormattedString(int length, byte value, boolean is_signed) {
        if (is_signed) {
            return new String(new DecimalFormat("+000;-000").format(value));
        }
        return new String(new DecimalFormat("+000;-000").format((short)(value & 0xFF)));
    }

    public static byte[] getFormattedBuffer(byte value) {
        byte[] buffer = new byte[]{value};
        return buffer;
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public final int getPriority() {
        return 1;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 1: 
            case 9: {
                return this;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public final void assign(Value v) {
        Byte vb = (Byte)v.convertTo(1);
        this.value = vb.byteValue();
    }

    @Override
    public final Value unaryMinus() {
        return new Byte((int)(-this.value));
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short sum = (short)(this.shortValue() + num.shortValue());
        if (sum >= -128) {
            if (sum < 128) {
                return new Byte((byte)sum);
            }
            if (sum < 256) {
                return new UnsignedByte((byte)sum);
            }
        }
        return new Short(sum);
    }

    @Override
    public final Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short dif = (short)(this.shortValue() - num.shortValue());
        if (dif < -128 || dif > 255) {
            return new Short(dif);
        }
        if (dif < 128) {
            return new Byte((byte)dif);
        }
        return new UnsignedByte((byte)dif);
    }

    @Override
    public final Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short prod = (short)(this.shortValue() * num.shortValue());
        if (prod < -128 || prod > 255) {
            return new Short(prod);
        }
        if (prod < 128) {
            return new Byte((byte)prod);
        }
        return new UnsignedByte((byte)prod);
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short div = (short)(this.shortValue() / num.shortValue());
        if (div < -128 || div > 255) {
            return new Short(div);
        }
        if (div < 128) {
            return new Byte((byte)div);
        }
        return new UnsignedByte((byte)div);
    }

    @Override
    public final Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short mod = (short)(this.shortValue() % num.shortValue());
        if (mod < -128 || mod > 255) {
            return new Short(mod);
        }
        if (mod < 128) {
            return new Byte((byte)mod);
        }
        return new UnsignedByte((byte)mod);
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            x = x.convertTo(9);
            return this.intValue() - ((Numeric)x).intValue();
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public final byte byteValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final short shortValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? (byte)1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = (byte)value;
    }

    @Override
    public final void assign(short value) {
        this.value = (byte)value;
    }

    @Override
    public final void assign(long value) {
        this.value = (byte)value;
    }

    @Override
    public final void assign(float value) {
        this.value = (byte)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (byte)value;
    }

    public static void main(String[] args) {
        Byte ub = new Byte(127);
        UnsignedByte ub2 = new UnsignedByte(255);
        System.out.println(ub.add(ub2));
        System.out.println("toString(127) : [" + new Byte(127) + "]");
        System.out.println("toString(-128): [" + new Byte(-128) + "]");
        System.out.println("toString(0)   : [" + new Byte(0) + "]");
        System.out.println("toString(-5)  : [" + new Byte(-5) + "]");
    }
}

