/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValue;
import fr.gael.drb.value.Arithmetic;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DayTimeDuration;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DateTime
extends AbstractValue
implements Value,
Arithmetic,
Comparison,
ValueFormat {
    private static final long MJD2000_TIME = 946684800000L;
    private static Logger logger = Logger.getLogger(DateTime.class);
    static final int PRIORITY = 7;
    protected Timestamp dateTime;

    public DateTime() {
        TimeZone timeZone = TimeZone.getDefault();
        long currentTime = System.currentTimeMillis();
        this.dateTime = new Timestamp(currentTime + (long)timeZone.getOffset(currentTime));
    }

    public DateTime(long dt) {
        this.dateTime = new Timestamp(dt);
    }

    public DateTime(java.lang.String s) {
        this.dateTime = new Timestamp(0L);
        long nanos = 0L;
        SimpleDateFormat pds_formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
        pds_formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        SimpleDateFormat iso_formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        iso_formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        ParsePosition pos = new ParsePosition(0);
        Date date = pds_formatter.parse(s, pos);
        if (date == null) {
            pos = new ParsePosition(0);
            date = iso_formatter.parse(s, pos);
        }
        if (s.indexOf(".") > 0) {
            BigDecimal frac = new BigDecimal("0." + s.substring(s.indexOf(".") + 1));
            nanos = frac.multiply(BigDecimal.valueOf(1000000000L)).longValue();
        }
        this.setTime(date.getTime() + nanos / 1000000L);
        this.setNanos((int)nanos);
    }

    public DateTime(byte[] buffer) {
        this.dateTime = new Timestamp(0L);
        byte[] mjdBuffer = buffer;
        if (buffer.length < 12) {
            logger.error("fr.gael.drb.value.DateTime(buffer[]) : Buffer length is lower than 12, append with zero values.");
            mjdBuffer = new byte[12];
            System.arraycopy(buffer, 0, mjdBuffer, 0, buffer.length);
        } else if (buffer.length > 12) {
            logger.error("fr.gael.drb.value.DateTime(buffer[]) : Buffer length is greater than 12, ignore extra values.");
        }
        int days = ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
        long seconds = ((buffer[4] & 0xFF) << 24) + ((buffer[5] & 0xFF) << 16) + ((buffer[6] & 0xFF) << 8) + (buffer[7] & 0xFF);
        long microseconds = ((buffer[8] & 0xFF) << 24) + ((buffer[9] & 0xFF) << 16) + ((buffer[10] & 0xFF) << 8) + (buffer[11] & 0xFF);
        this.setTime(946684800000L + 1000L * ((long)(86400 * days) + seconds));
        this.setNanos((int)(microseconds * 1000L));
    }

    public long getTime() {
        return this.dateTime.getTime();
    }

    public int getNanos() {
        return this.dateTime.getNanos();
    }

    public void setTime(long time) {
        this.dateTime.setTime(time);
    }

    public void setNanos(int nanos) {
        this.dateTime.setNanos(nanos);
    }

    @Override
    public final int getType() {
        return 8;
    }

    @Override
    public final int getPriority() {
        return 7;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 8: {
                return this;
            }
            case 4: 
            case 9: {
                return new Long(this.getTime());
            }
            case 7: {
                return new String(this.toString());
            }
        }
        throw new ClassCastException();
    }

    @Override
    public void assign(Value v) {
        DateTime vd = (DateTime)v.convertTo(8);
        this.setTime(vd.getTime());
        this.setNanos(vd.getNanos());
    }

    @Override
    public Value add(Value x) {
        DayTimeDuration vd = (DayTimeDuration)x.convertTo(17);
        double sum = this.getFullTime() + vd.getDayTime() * 1000.0;
        DateTime date = new DateTime((long)sum);
        date.setFullTime(sum);
        return date;
    }

    @Override
    public Value unaryMinus() {
        return null;
    }

    @Override
    public Value sub(Value x) {
        if (x instanceof DateTime) {
            DateTime date = (DateTime)x.convertTo(8);
            return new DayTimeDuration((this.getFullTime() - date.getFullTime()) * 0.001);
        }
        DayTimeDuration dur = (DayTimeDuration)x.convertTo(17);
        double diff = this.getFullTime() - dur.getDayTime() * 1000.0;
        DateTime date = new DateTime((long)diff);
        date.setFullTime(diff);
        return date;
    }

    @Override
    public Value multiply(Value x) {
        return null;
    }

    @Override
    public Value divide(Value x) {
        return null;
    }

    @Override
    public Value modulus(Value x) {
        return null;
    }

    final double getFullTime() {
        return (double)(1000L * (this.getTime() / 1000L)) + 1.0E-6 * (double)this.getNanos();
    }

    final void setFullTime(double full_time) {
        long time = 1000L * ((long)full_time / 1000L);
        int nanos = (int)((full_time - (double)time) * 1000000.0);
        if (nanos < 0) {
            nanos = -nanos;
        }
        this.setTime(time);
        this.setNanos(nanos);
    }

    @Override
    public final int compareTo(Value x) {
        DateTime date = (DateTime)x.convertTo(8);
        return this.dateTime.compareTo(date.dateTime);
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        return this.getFormattedString("dd-MMM-yyyy HH:mm:ss", true);
    }

    @Override
    public byte[] getFormattedBuffer() {
        long milliseconds;
        byte[] buffer = new byte[12];
        long currentTime = milliseconds = this.getTime() - 946684800000L;
        int days = (int)(milliseconds / 86400000L);
        if (milliseconds < 0L) {
            --days;
        }
        long seconds = (milliseconds - 86400000L * (long)days) / 1000L;
        long microseconds = (long)this.getNanos() / 1000L;
        buffer[0] = (byte)(days >>> 24);
        buffer[1] = (byte)(days >>> 16);
        buffer[2] = (byte)(days >>> 8);
        buffer[3] = (byte)days;
        buffer[4] = (byte)(seconds >>> 24);
        buffer[5] = (byte)(seconds >>> 16);
        buffer[6] = (byte)(seconds >>> 8);
        buffer[7] = (byte)seconds;
        buffer[8] = (byte)(microseconds >>> 24);
        buffer[9] = (byte)(microseconds >>> 16);
        buffer[10] = (byte)(microseconds >>> 8);
        buffer[11] = (byte)microseconds;
        return buffer;
    }

    private java.lang.String getFormattedString(java.lang.String pattern, boolean with_microsecond) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        java.lang.String dateStr = formatter.format(this.dateTime);
        dateStr = dateStr.toUpperCase();
        if (with_microsecond) {
            int microseconds = this.getNanos() / 1000;
            java.lang.String microsecondsStr = "" + microseconds;
            int microsecondsLen = microsecondsStr.length();
            for (int i = 0; i < 6 - microsecondsLen; ++i) {
                microsecondsStr = "0" + microsecondsStr;
            }
            dateStr = dateStr + "." + microsecondsStr;
        }
        return dateStr;
    }

    public java.lang.String toString() {
        return this.getFormattedString(12);
    }

    public static void main(java.lang.String[] args) {
        DateTime date1 = new DateTime();
        System.out.println("Default DateTime() = " + date1);
        date1 = new DateTime(946684800000L);
        System.out.println("MJD origin DateTime(946684800000L) = " + date1);
        System.out.println("MJD origin getFormattedString: [" + date1.getFormattedString(12) + "]");
        java.lang.String[] dates = new java.lang.String[]{"17-JAN-2005 00:00:00.000000", "29-MAR-1999 16:47:19.625468", "29-MAR-1999 16:47:19.876543", "29-MAR-1999 16:47:19.004321", "01-JAN-2000 16:47:19.625468", "29-JAN-2000 16:47:19.625468", "1970-09-08T21:09:47", "1997-01-26T13:30:30", "2005-05-13T17:33:47", "2029-09-17T03:28:03", "2008-12-05T15:31:29"};
        for (int iDate = 0; iDate < dates.length; ++iDate) {
            date1 = new DateTime(dates[iDate]);
            System.out.println("========================================");
            System.out.println("DateTime(" + dates[iDate] + ") = " + date1);
            System.out.println("  time  = " + date1.getTime());
            System.out.println("  nanos = " + date1.getNanos());
            System.out.println("  getFormattedString: [" + date1.getFormattedString(12) + "]");
            byte[] buftmp = date1.getFormattedBuffer();
            int[] buffer = new int[3];
            for (int i = 0; i < 3; ++i) {
                buffer[i] = ((buftmp[4 * i] & 0xFF) << 24) + ((buftmp[4 * i + 1] & 0xFF) << 16) + ((buftmp[4 * i + 2] & 0xFF) << 8) + (buftmp[4 * i + 3] & 0xFF);
            }
            System.out.println("date mjd = " + buffer[0] + " " + ((long)buffer[1] & 0xFFFFFFFFL) + " " + ((long)buffer[2] & 0xFFFFFFFFL));
            DateTime date3 = new DateTime(buftmp);
            System.out.println("  new DateTime(buffer mjd) = [" + date3.getFormattedString(12) + "]");
            System.out.println(" *time  = " + date3.getTime());
            System.out.println(" *nanos = " + date3.getNanos());
        }
        args = dates;
    }
}

