/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class Double
extends AbstractNumeric
implements ValueFormat {
    public static final int PRIORITY = 7;
    double value;

    public Double(double v) {
        this.value = v;
    }

    public String toString() {
        return java.lang.Double.toString(this.value);
    }

    @Override
    public String getFormattedString(int length) {
        switch (length) {
            case 8: {
                return new String(new DecimalFormat("+.000000;-.000000").format(this.value));
            }
            case 12: {
                return new String(new DecimalFormat("+0000.000000;-0000.000000").format(this.value));
            }
            case 25: {
                return new String(new DecimalFormat("+0.00000000000000000E000;-0.00000000000000000E000").format(this.value));
            }
        }
        return this.toString();
    }

    @Override
    public byte[] getFormattedBuffer() {
        byte[] buffer = new byte[8];
        long longValue = java.lang.Double.doubleToRawLongBits(this.value);
        buffer[0] = (byte)(longValue >>> 56);
        buffer[1] = (byte)(longValue >>> 48);
        buffer[2] = (byte)(longValue >>> 40);
        buffer[3] = (byte)(longValue >>> 32);
        buffer[4] = (byte)(longValue >>> 24);
        buffer[5] = (byte)(longValue >>> 16);
        buffer[6] = (byte)(longValue >>> 8);
        buffer[7] = (byte)longValue;
        return buffer;
    }

    @Override
    public final int getType() {
        return 6;
    }

    @Override
    public final int getPriority() {
        return 7;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 6: 
            case 9: {
                return this;
            }
            case 10: {
                DoubleArray doubleArray = new DoubleArray(1);
                doubleArray.assign(0, this.doubleValue());
                return doubleArray;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Double vs = (Double)v.convertTo(6);
        this.value = vs.doubleValue();
    }

    @Override
    public Value unaryMinus() {
        return new Double(-this.value);
    }

    @Override
    public Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        return new Double(this.doubleValue() + ((Numeric)x).doubleValue());
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        return new Double(this.doubleValue() - ((Numeric)x).doubleValue());
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        return new Double(this.doubleValue() * ((Numeric)x).doubleValue());
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        return new Double(this.doubleValue() / ((Numeric)x).doubleValue());
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        return new Double(this.doubleValue() % ((Numeric)x).doubleValue());
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            double cmp = this.doubleValue() - ((Numeric)x).doubleValue();
            if (cmp == 0.0) {
                return 0;
            }
            if (cmp < 0.0) {
                return -1;
            }
            return 1;
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return !java.lang.Double.isNaN(this.value) && this.value != 0.0;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final short shortValue() {
        return (short)this.value;
    }

    @Override
    public final long longValue() {
        return (long)this.value;
    }

    @Override
    public final float floatValue() {
        return (float)this.value;
    }

    @Override
    protected BigInteger integerValue() {
        return new BigDecimal(this.toString()).toBigInteger();
    }

    @Override
    protected BigDecimal decimalValue() {
        return new BigDecimal(this.toString());
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? 1.0 : 0.0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = value;
    }

    @Override
    public final void assign(short value) {
        this.value = value;
    }

    @Override
    public final void assign(float value) {
        this.value = value;
    }

    @Override
    public final void assign(double value) {
        this.value = value;
    }
}

